/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server.connection;

import java.security.KeyFactory;
import java.security.spec.X509EncodedKeySpec;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import su.plo.voice.BaseVoice;
import su.plo.voice.api.server.PlasmoVoiceServer;
import su.plo.voice.api.server.audio.capture.ServerActivation;
import su.plo.voice.api.server.audio.source.ServerAudioSource;
import su.plo.voice.api.server.connection.TcpServerPacketManager;
import su.plo.voice.api.server.event.audio.source.PlayerSpeakEndEvent;
import su.plo.voice.api.server.event.connection.TcpPacketReceivedEvent;
import su.plo.voice.api.server.player.VoiceServerPlayer;
import su.plo.voice.proto.data.audio.source.SourceInfo;
import su.plo.voice.proto.packets.Packet;
import su.plo.voice.proto.packets.PacketHandler;
import su.plo.voice.proto.packets.tcp.clientbound.LanguagePacket;
import su.plo.voice.proto.packets.tcp.clientbound.SourceInfoPacket;
import su.plo.voice.proto.packets.tcp.serverbound.LanguageRequestPacket;
import su.plo.voice.proto.packets.tcp.serverbound.PlayerActivationDistancesPacket;
import su.plo.voice.proto.packets.tcp.serverbound.PlayerAudioEndPacket;
import su.plo.voice.proto.packets.tcp.serverbound.PlayerInfoPacket;
import su.plo.voice.proto.packets.tcp.serverbound.PlayerStatePacket;
import su.plo.voice.proto.packets.tcp.serverbound.ServerPacketTcpHandler;
import su.plo.voice.proto.packets.tcp.serverbound.SourceInfoRequestPacket;
import su.plo.voice.server.player.BaseVoicePlayer;
import su.plo.voice.server.util.version.ServerVersionUtil;
import su.plo.voice.util.version.SemanticVersion;

public final class PlayerChannelHandler
implements ServerPacketTcpHandler {
    private final PlasmoVoiceServer voiceServer;
    private final TcpServerPacketManager tcpConnections;
    private final VoiceServerPlayer player;

    public PlayerChannelHandler(@NotNull PlasmoVoiceServer voiceServer, @NotNull VoiceServerPlayer player) {
        this.voiceServer = voiceServer;
        this.tcpConnections = voiceServer.getTcpPacketManager();
        this.player = player;
    }

    public void handlePacket(Packet<PacketHandler> packet) {
        if (!this.voiceServer.getUdpServer().isPresent()) {
            return;
        }
        TcpPacketReceivedEvent event = new TcpPacketReceivedEvent(this.player, packet);
        this.voiceServer.getEventBus().fire(event);
        if (event.isCancelled()) {
            return;
        }
        try {
            packet.handle(this);
        }
        catch (Exception e) {
            BaseVoice.DEBUG_LOGGER.log("Failed to handle packet ({}): {}", packet, e);
        }
    }

    @Override
    public void handle(@NotNull PlayerInfoPacket packet) {
        SemanticVersion serverVersion = SemanticVersion.parse(this.voiceServer.getVersion());
        SemanticVersion clientVersion = SemanticVersion.parse(packet.getVersion());
        if (clientVersion.major() != serverVersion.major()) {
            ServerVersionUtil.suggestSupportedVersion(this.player, serverVersion, packet.getMinecraftVersion());
            return;
        }
        SemanticVersion minVersion = SemanticVersion.parse("2.0.0");
        try {
            minVersion = SemanticVersion.parse(this.voiceServer.getConfig().voice().clientModMinVersion());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (clientVersion.asInt() < minVersion.asInt()) {
            ServerVersionUtil.suggestSupportedVersion(this.player, clientVersion, packet.getMinecraftVersion());
            return;
        }
        BaseVoicePlayer voicePlayer = (BaseVoicePlayer)((Object)this.player);
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(packet.getPublicKey());
            voicePlayer.setPublicKey(keyFactory.generatePublic(publicKeySpec));
        }
        catch (Exception e) {
            BaseVoice.LOGGER.error("Failed to generate RSA public key: {}", e.toString());
            e.printStackTrace();
            return;
        }
        voicePlayer.setVoiceDisabled(packet.isVoiceDisabled());
        voicePlayer.setMicrophoneMuted(packet.isMicrophoneMuted());
        voicePlayer.setModVersion(packet.getVersion());
        this.tcpConnections.connect(this.player);
    }

    @Override
    public void handle(@NotNull PlayerStatePacket packet) {
        if (!this.player.hasVoiceChat()) {
            return;
        }
        BaseVoicePlayer voicePlayer = (BaseVoicePlayer)((Object)this.player);
        voicePlayer.setVoiceDisabled(packet.isVoiceDisabled());
        voicePlayer.setMicrophoneMuted(packet.isMicrophoneMuted());
        this.tcpConnections.broadcastPlayerInfoUpdate(this.player);
    }

    @Override
    public void handle(@NotNull PlayerActivationDistancesPacket packet) {
        BaseVoicePlayer voicePlayer = (BaseVoicePlayer)((Object)this.player);
        packet.getDistanceByActivationId().forEach((activationId, distance) -> {
            Optional activation = this.voiceServer.getActivationManager().getActivationById((UUID)activationId);
            if (!activation.isPresent()) {
                return;
            }
            voicePlayer.setActivationDistance((ServerActivation)activation.get(), (int)distance);
        });
    }

    @Override
    public void handle(@NotNull PlayerAudioEndPacket packet) {
        if (!this.player.hasVoiceChat()) {
            return;
        }
        if (this.voiceServer.getMuteManager().getMute(this.player.getInstance().getUuid()).isPresent()) {
            return;
        }
        if (this.player.isMicrophoneMuted()) {
            return;
        }
        this.voiceServer.getEventBus().fire(new PlayerSpeakEndEvent(this.player, packet));
    }

    @Override
    public void handle(@NotNull SourceInfoRequestPacket packet) {
        if (!this.player.hasVoiceChat()) {
            return;
        }
        Optional<ServerAudioSource> source2 = this.voiceServer.getSourceLineManager().getLines().stream().map(line -> line.getSourceById(packet.getSourceId()).orElse(null)).filter(Objects::nonNull).findFirst();
        if (!source2.isPresent()) {
            return;
        }
        if (source2.get().notMatchFilters(this.player)) {
            source2.get().resolveSourceInfo().thenAccept(sourceInfo -> BaseVoice.LOGGER.warn("{} tried to request a source {} to which he doesn't have access", this.player.getInstance().getName(), ((ServerAudioSource)source2.get()).getSourceInfo()));
            return;
        }
        source2.get().resolveSourceInfo().thenAccept(sourceInfo -> this.player.sendPacket(new SourceInfoPacket((SourceInfo)sourceInfo)));
    }

    @Override
    public void handle(@NotNull LanguageRequestPacket packet) {
        this.player.sendPacket(new LanguagePacket(packet.getLanguage(), this.voiceServer.getLanguages().getClientLanguage(packet.getLanguage())));
    }
}

