/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server.audio.source;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.slib.api.server.position.ServerPos3d;
import su.plo.voice.api.addon.AddonContainer;
import su.plo.voice.api.server.PlasmoVoiceServer;
import su.plo.voice.api.server.audio.line.ServerSourceLine;
import su.plo.voice.api.server.audio.source.ServerStaticSource;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;
import su.plo.voice.proto.data.audio.codec.CodecInfo;
import su.plo.voice.proto.data.audio.source.StaticSourceInfo;
import su.plo.voice.server.audio.source.VoiceServerProximitySource;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B9\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u001cH\u0016R\u000e\u0010\u0012\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000f8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001d"}, d2={"Lsu/plo/voice/server/audio/source/VoiceServerStaticSource;", "Lsu/plo/voice/server/audio/source/VoiceServerProximitySource;", "Lsu/plo/voice/proto/data/audio/source/StaticSourceInfo;", "Lsu/plo/voice/api/server/audio/source/ServerStaticSource;", "voiceServer", "Lsu/plo/voice/api/server/PlasmoVoiceServer;", "addon", "Lsu/plo/voice/api/addon/AddonContainer;", "line", "Lsu/plo/voice/api/server/audio/line/ServerSourceLine;", "decoderInfo", "Lsu/plo/voice/proto/data/audio/codec/CodecInfo;", "stereo", "", "defaultPosition", "Lsu/plo/slib/api/server/position/ServerPos3d;", "<init>", "(Lsu/plo/voice/api/server/PlasmoVoiceServer;Lsu/plo/voice/api/addon/AddonContainer;Lsu/plo/voice/api/server/audio/line/ServerSourceLine;Lsu/plo/voice/proto/data/audio/codec/CodecInfo;ZLsu/plo/slib/api/server/position/ServerPos3d;)V", "sourcePosition", "position", "getPosition", "()Lsu/plo/slib/api/server/position/ServerPos3d;", "setPosition", "(Lsu/plo/slib/api/server/position/ServerPos3d;)V", "sourceInfo", "getSourceInfo", "()Lsu/plo/voice/proto/data/audio/source/StaticSourceInfo;", "resolveSourceInfo", "Ljava/util/concurrent/CompletableFuture;", "common"})
public final class VoiceServerStaticSource
extends VoiceServerProximitySource<StaticSourceInfo>
implements ServerStaticSource {
    @NotNull
    private ServerPos3d sourcePosition;

    public VoiceServerStaticSource(@NotNull PlasmoVoiceServer voiceServer, @NotNull AddonContainer addon, @NotNull ServerSourceLine line, @Nullable CodecInfo decoderInfo, boolean stereo, @NotNull ServerPos3d defaultPosition) {
        Intrinsics.checkNotNullParameter(voiceServer, "voiceServer");
        Intrinsics.checkNotNullParameter(addon, "addon");
        Intrinsics.checkNotNullParameter(line, "line");
        Intrinsics.checkNotNullParameter(defaultPosition, "defaultPosition");
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue(uUID, "randomUUID(...)");
        super(voiceServer, addon, uUID, line, decoderInfo, stereo);
        this.sourcePosition = defaultPosition;
    }

    @Override
    @NotNull
    public ServerPos3d getPosition() {
        return this.sourcePosition;
    }

    @Override
    public void setPosition(@NotNull ServerPos3d position) {
        Intrinsics.checkNotNullParameter(position, "position");
        if (!Intrinsics.areEqual(this.sourcePosition, position)) {
            this.sourcePosition = position;
            this.setDirty();
        }
    }

    @Override
    @NotNull
    public StaticSourceInfo getSourceInfo() {
        return new StaticSourceInfo(this.addon.getId(), this.id, this.line.getId(), this.name, (byte)this.state.get(), this.decoderInfo, this.stereo, this.iconVisible, this.getAngle(), this.getPosition().toPosition(), this.getPosition().getLookAngle());
    }

    @Override
    @NotNull
    public CompletableFuture<StaticSourceInfo> resolveSourceInfo() {
        CompletableFuture<StaticSourceInfo> completableFuture = CompletableFuture.completedFuture(this.getSourceInfo());
        Intrinsics.checkNotNullExpressionValue(completableFuture, "completedFuture(...)");
        return completableFuture;
    }
}

