/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.libs.crowdin;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.Closeable;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.voice.libs.crowdin.Crowdin;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.Pair;
import su.plo.voice.libs.kotlin.TuplesKt;
import su.plo.voice.libs.kotlin.Unit;
import su.plo.voice.libs.kotlin.collections.CollectionsKt;
import su.plo.voice.libs.kotlin.collections.MapsKt;
import su.plo.voice.libs.kotlin.io.ByteStreamsKt;
import su.plo.voice.libs.kotlin.io.CloseableKt;
import su.plo.voice.libs.kotlin.jvm.functions.Function0;
import su.plo.voice.libs.kotlin.jvm.functions.Function1;
import su.plo.voice.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;
import su.plo.voice.libs.kotlin.jvm.internal.SourceDebugExtension;
import su.plo.voice.libs.kotlin.ranges.RangesKt;
import su.plo.voice.libs.kotlin.sequences.SequencesKt;
import su.plo.voice.libs.kotlin.text.StringsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0012\n\u0002\b\u0004\u0018\u0000 \u00112\u00020\u0001:\u0002\u0011\u0012B2\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0019\b\u0002\u0010\u0006\u001a\u0013\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\b\n\u00a2\u0006\u0002\u0010\u000bJ\u001e\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u000eR\u001f\u0010\u0006\u001a\u0013\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lsu/plo/voice/libs/crowdin/Crowdin;", "", "url", "Ljava/net/URL;", "keyTransformer", "Lsu/plo/voice/libs/crowdin/Crowdin$KeyTransformer;", "connectionBuilder", "Lsu/plo/voice/libs/kotlin/Function1;", "Ljava/net/URLConnection;", "", "Lsu/plo/voice/libs/kotlin/ExtensionFunctionType;", "(Ljava/net/URL;Lsu/plo/crowdin/Crowdin$KeyTransformer;Lkotlin/jvm/functions/Function1;)V", "downloadRawTranslations", "", "", "", "fileName", "Companion", "KeyTransformer", "crowdin-lib"})
@SourceDebugExtension(value={"SMAP\nCrowdin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Crowdin.kt\nsu/plo/crowdin/Crowdin\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,195:1\n515#2:196\n500#2,2:197\n502#2,4:200\n1#3:199\n125#4:204\n152#4,3:205\n125#4:217\n152#4,3:218\n766#5:208\n857#5,2:209\n1179#5,2:211\n1253#5,4:213\n*S KotlinDebug\n*F\n+ 1 Crowdin.kt\nsu/plo/crowdin/Crowdin\n*L\n34#1:196\n34#1:197,2\n34#1:200,4\n39#1:204\n39#1:205,3\n183#1:217\n183#1:218,3\n40#1:208\n40#1:209,2\n41#1:211,2\n41#1:213,4\n*E\n"})
public final class Crowdin {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final URL url;
    @NotNull
    private final KeyTransformer keyTransformer;
    @NotNull
    private final Function1<URLConnection, Unit> connectionBuilder;
    @NotNull
    private static final Cache<URL, Map<String, byte[]>> CACHE;
    private static final Pattern JSON_PATTERN;
    @NotNull
    private static final Map<String, String> MC_CODE_TO_CROWDIN_CODE;
    @NotNull
    private static final Map<String, String> CROWDIN_CODE_TO_MC_CODE;
    @NotNull
    private static final KeyTransformer GITHUB_LOCALE_KEY_TRANSFORMER;
    @NotNull
    private static final KeyTransformer DEFAULT_KEY_TRANSFORMER;

    public Crowdin(@NotNull URL url, @NotNull KeyTransformer keyTransformer, @NotNull Function1<? super URLConnection, Unit> connectionBuilder) {
        Intrinsics.checkNotNullParameter(url, "url");
        Intrinsics.checkNotNullParameter(keyTransformer, "keyTransformer");
        Intrinsics.checkNotNullParameter(connectionBuilder, "connectionBuilder");
        this.url = url;
        this.keyTransformer = keyTransformer;
        this.connectionBuilder = connectionBuilder;
    }

    public /* synthetic */ Crowdin(URL uRL, KeyTransformer keyTransformer, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            keyTransformer = DEFAULT_KEY_TRANSFORMER;
        }
        if ((n & 4) != 0) {
            function1 = 1.INSTANCE;
        }
        this(uRL, keyTransformer, function1);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, byte[]> downloadRawTranslations(@Nullable String fileName) throws IOException {
        void $this$associateTo$iv$iv;
        Pair it;
        Object $this$mapTo$iv$iv;
        Object it2;
        Map.Entry entry;
        Map.Entry element$iv$iv;
        Map $this$filterTo$iv$iv;
        Object object = CACHE.get((Object)this.url, () -> Crowdin.downloadRawTranslations$lambda$1(this));
        Intrinsics.checkNotNullExpressionValue(object, "CACHE.get(url) {\n       \u2026)\n            }\n        }");
        Object $this$filter$iv = (Map)object;
        boolean $i$f$filter = false;
        Map map2 = $this$filter$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            boolean bl;
            entry = element$iv$iv = iterator2.next();
            boolean bl2 = false;
            if (fileName != null) {
                it2 = fileName;
                boolean bl3 = false;
                bl = StringsKt.endsWith$default((String)entry.getKey(), (String)it2, false, 2, null);
            } else {
                bl = JSON_PATTERN.matcher((CharSequence)entry.getKey()).matches();
            }
            if (!bl) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map $this$map$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
            entry = item$iv$iv;
            Object object2 = destination$iv$iv;
            boolean bl = false;
            object2.add(TuplesKt.to(this.keyTransformer.transform((String)it.getKey()), it.getValue()));
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        iterator2 = $this$filterTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv$iv = iterator2.next();
            it = (Pair)((Object)element$iv$iv);
            boolean bl = false;
            if (!(it.getFirst() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$associate$iv = (List)destination$iv$iv;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv2 : $this$associateTo$iv$iv) {
            Map map3 = destination$iv$iv2;
            it2 = (Pair)element$iv$iv2;
            boolean bl = false;
            Object a = ((Pair)it2).getFirst();
            Intrinsics.checkNotNull(a);
            Pair pair = TuplesKt.to(a, ((Pair)it2).getSecond());
            map3.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv2;
    }

    public static /* synthetic */ Map downloadRawTranslations$default(Crowdin crowdin, String string, int n, Object object) throws IOException {
        if ((n & 1) != 0) {
            string = null;
        }
        return crowdin.downloadRawTranslations(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Map downloadRawTranslations$lambda$1(Crowdin this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        URLConnection connection = this$0.url.openConnection();
        connection.setConnectTimeout(3000);
        connection.setReadTimeout(30000);
        Object object = connection;
        this$0.connectionBuilder.invoke((URLConnection)object);
        object = new ZipInputStream(connection.getInputStream());
        Throwable throwable = null;
        try {
            ZipInputStream zis = (ZipInputStream)object;
            boolean bl = false;
            Map map2 = MapsKt.toMap(SequencesKt.map(SequencesKt.filter(SequencesKt.generateSequence((Function0)new Function0<ZipEntry>(zis){
                final /* synthetic */ ZipInputStream $zis;
                {
                    this.$zis = $zis;
                    super(0);
                }

                @Nullable
                public final ZipEntry invoke() {
                    return this.$zis.getNextEntry();
                }
            }), downloadRawTranslations.1.1.2.INSTANCE), (Function1)new Function1<ZipEntry, Pair<? extends String, ? extends byte[]>>(zis){
                final /* synthetic */ ZipInputStream $zis;
                {
                    this.$zis = $zis;
                    super(1);
                }

                @NotNull
                public final Pair<String, byte[]> invoke(@NotNull ZipEntry it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return TuplesKt.to(it.getName(), ByteStreamsKt.readBytes(this.$zis));
                }
            }));
            return map2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, throwable);
        }
    }

    private static final String GITHUB_LOCALE_KEY_TRANSFORMER$lambda$9(String it) {
        String string;
        Intrinsics.checkNotNullParameter(it, "it");
        String[] stringArray = new String[]{"/"};
        String string2 = (String)CollectionsKt.getOrNull(StringsKt.split$default((CharSequence)it, stringArray, false, 0, 6, null), 1);
        if (string2 != null) {
            String string3 = string2.toLowerCase(Locale.ROOT);
            string = string3;
            Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String).toLowerCase(Locale.ROOT)");
        } else {
            string = null;
        }
        return string;
    }

    private static final String DEFAULT_KEY_TRANSFORMER$lambda$10(String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return CROWDIN_CODE_TO_MC_CODE.get(StringsKt.substringBefore$default(it, "/", null, 2, null));
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_5;
        void $this$mapTo$iv$iv;
        HashMap hashMap;
        Companion = new Companion(null);
        Cache cache2 = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build();
        Intrinsics.checkNotNullExpressionValue(cache2, "newBuilder()\n           \u2026TES)\n            .build()");
        CACHE = cache2;
        JSON_PATTERN = Pattern.compile("^([a-z]{2}(-[A-Z]{2})?)/(.+\\.json)$");
        HashMap it = hashMap = new HashMap();
        boolean $i$a$-also-Crowdin$Companion$MC_CODE_TO_CROWDIN_CODE$22 = false;
        ((Map)it).put("af_za", "af");
        ((Map)it).put("ar_sa", "ar");
        ((Map)it).put("ast_es", "ast");
        ((Map)it).put("az_az", "az");
        ((Map)it).put("ba_ru", "ba");
        ((Map)it).put("be_by", "be");
        ((Map)it).put("bg_bg", "bg");
        ((Map)it).put("br_fr", "br-FR");
        ((Map)it).put("bs_ba", "bs");
        ((Map)it).put("ca_es", "ca");
        ((Map)it).put("cs_cz", "cs");
        ((Map)it).put("cy_gb", "cy");
        ((Map)it).put("da_dk", "da");
        ((Map)it).put("de_at", "de-AT");
        ((Map)it).put("de_ch", "de-CH");
        ((Map)it).put("de_de", "de");
        ((Map)it).put("el_gr", "el");
        ((Map)it).put("en_au", "de-AT");
        ((Map)it).put("en_ca", "en-CA");
        ((Map)it).put("en_gb", "en-GB");
        ((Map)it).put("en_nz", "en-NZ");
        ((Map)it).put("en_pt", "en-PT");
        ((Map)it).put("en_za", "en-ZA");
        ((Map)it).put("en_ud", "en-UD");
        ((Map)it).put("en_us", "en-US");
        ((Map)it).put("eo_uy", "eo");
        ((Map)it).put("es_ar", "es-AR");
        ((Map)it).put("es_cl", "es-CL");
        ((Map)it).put("es_ec", "es-EC");
        ((Map)it).put("es_es", "es-ES");
        ((Map)it).put("es_mx", "es-MX");
        ((Map)it).put("es_uy", "es-UY");
        ((Map)it).put("es_ve", "es-VE");
        ((Map)it).put("et_ee", "et");
        ((Map)it).put("eu_es", "eu");
        ((Map)it).put("fa_ir", "fa");
        ((Map)it).put("fi_fi", "fi");
        ((Map)it).put("fil_ph", "fil");
        ((Map)it).put("fo_fo", "fo");
        ((Map)it).put("fr_ca", "fr-CA");
        ((Map)it).put("fr_fr", "fr");
        ((Map)it).put("fra_de", "fra-DE");
        ((Map)it).put("fy_nl", "fy-NL");
        ((Map)it).put("ga_ie", "ga-IE");
        ((Map)it).put("gd_gb", "gd");
        ((Map)it).put("gl_es", "gl");
        ((Map)it).put("haw_us", "haw");
        ((Map)it).put("he_il", "he");
        ((Map)it).put("hi_in", "hi");
        ((Map)it).put("hr_hr", "hr");
        ((Map)it).put("hu_hu", "hu");
        ((Map)it).put("hy_am", "hy-AM");
        ((Map)it).put("id_id", "id");
        ((Map)it).put("ig_ng", "ig");
        ((Map)it).put("io_en", "ido");
        ((Map)it).put("is_is", "is");
        ((Map)it).put("it_it", "it");
        ((Map)it).put("ja_jp", "ja");
        ((Map)it).put("jbo_en", "jbo");
        ((Map)it).put("ka_ge", "ka");
        ((Map)it).put("kk_kz", "kk");
        ((Map)it).put("kn_in", "kn");
        ((Map)it).put("ko_kr", "ko");
        ((Map)it).put("kw_gb", "kw");
        ((Map)it).put("la_la", "la-LA");
        ((Map)it).put("lb_lu", "lb");
        ((Map)it).put("li_li", "li");
        ((Map)it).put("lol_us", "lol");
        ((Map)it).put("lt_lt", "lt");
        ((Map)it).put("lv_lv", "lv");
        ((Map)it).put("mi_NZ", "mi");
        ((Map)it).put("mk_mk", "mk");
        ((Map)it).put("mn_mn", "mn");
        ((Map)it).put("ms_my", "ms");
        ((Map)it).put("mt_mt", "mt");
        ((Map)it).put("nds_de", "nds");
        ((Map)it).put("nl_be", "nl-BE");
        ((Map)it).put("nl_nl", "nl");
        ((Map)it).put("nn_no", "nn-NO");
        ((Map)it).put("no_no\u200c", "no");
        ((Map)it).put("oc_fr", "oc");
        ((Map)it).put("pl_pl", "pl");
        ((Map)it).put("pt_br", "pt-BR");
        ((Map)it).put("pt_pt", "pt-PT");
        ((Map)it).put("qya_aa", "qya-AA");
        ((Map)it).put("ro_ro", "ro");
        ((Map)it).put("ru_ru", "ru");
        ((Map)it).put("se_no", "se");
        ((Map)it).put("sk_sk", "sk");
        ((Map)it).put("sl_si", "sl");
        ((Map)it).put("so_so", "so");
        ((Map)it).put("sq_al", "sq");
        ((Map)it).put("sr_sp", "sr");
        ((Map)it).put("sv_se", "sv-SE");
        ((Map)it).put("ta_in", "ta");
        ((Map)it).put("th_th", "th");
        ((Map)it).put("tl_ph", "tl");
        ((Map)it).put("tlh_aa", "tlh-AA");
        ((Map)it).put("tr_tr", "tr");
        ((Map)it).put("tt_ru", "tt-RU");
        ((Map)it).put("uk_ua", "uk");
        ((Map)it).put("val_es", "val-ES");
        ((Map)it).put("vec_it", "vec");
        ((Map)it).put("vi_vn", "vi");
        ((Map)it).put("yi_de", "yi");
        ((Map)it).put("yo_ng", "yo");
        ((Map)it).put("zh_cn", "zh-CN");
        ((Map)it).put("zh_hk", "zh-HK");
        ((Map)it).put("zh_tw", "zh-TW");
        MC_CODE_TO_CROWDIN_CODE = hashMap;
        Map<String, String> $this$map$iv = MC_CODE_TO_CROWDIN_CODE;
        boolean $i$f$map = false;
        Map<String, String> $i$a$-also-Crowdin$Companion$MC_CODE_TO_CROWDIN_CODE$22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void it2;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to(it2.getValue(), it2.getKey()));
        }
        CROWDIN_CODE_TO_MC_CODE = MapsKt.toMap((List)var3_5);
        GITHUB_LOCALE_KEY_TRANSFORMER = Crowdin::GITHUB_LOCALE_KEY_TRANSFORMER$lambda$9;
        DEFAULT_KEY_TRANSFORMER = Crowdin::DEFAULT_KEY_TRANSFORMER$lambda$10;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R&\u0010\u0003\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0016\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lsu/plo/voice/libs/crowdin/Crowdin$Companion;", "", "()V", "CACHE", "Lcom/google/common/cache/Cache;", "Ljava/net/URL;", "", "", "", "CROWDIN_CODE_TO_MC_CODE", "DEFAULT_KEY_TRANSFORMER", "Lsu/plo/voice/libs/crowdin/Crowdin$KeyTransformer;", "getDEFAULT_KEY_TRANSFORMER", "()Lsu/plo/crowdin/Crowdin$KeyTransformer;", "GITHUB_LOCALE_KEY_TRANSFORMER", "getGITHUB_LOCALE_KEY_TRANSFORMER", "JSON_PATTERN", "Ljava/util/regex/Pattern;", "su.plo.voice.libs.kotlin.jvm.PlatformType", "MC_CODE_TO_CROWDIN_CODE", "crowdin-lib"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KeyTransformer getGITHUB_LOCALE_KEY_TRANSFORMER() {
            return GITHUB_LOCALE_KEY_TRANSFORMER;
        }

        @NotNull
        public final KeyTransformer getDEFAULT_KEY_TRANSFORMER() {
            return DEFAULT_KEY_TRANSFORMER;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0003H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0005\u00c0\u0006\u0001"}, d2={"Lsu/plo/voice/libs/crowdin/Crowdin$KeyTransformer;", "", "transform", "", "key", "crowdin-lib"})
    public static interface KeyTransformer {
        @Nullable
        public String transform(@NotNull String var1);
    }
}

