/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.gui.settings.widget;

import java.awt.Color;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import su.plo.lib.mod.client.gui.widget.GuiAbstractWidget;
import su.plo.lib.mod.client.gui.widget.GuiWidgetTexture;
import su.plo.lib.mod.client.render.Colors;
import su.plo.lib.mod.client.render.RenderUtil;
import su.plo.lib.mod.client.render.gui.GuiRenderContext;
import su.plo.slib.api.chat.component.McTextComponent;
import su.plo.voice.client.gui.settings.VoiceSettingsScreen;
import su.plo.voice.client.gui.settings.widget.DropDownWidgetList;

public final class DropDownWidget
extends GuiAbstractWidget {
    private final DropDownWidgetList list;
    private boolean open;

    public DropDownWidget(@NotNull VoiceSettingsScreen parent, int x, int y, int width, int height, @NotNull McTextComponent message, @NotNull List<McTextComponent> elements, boolean tooltip, @NotNull Consumer<Integer> onSelect) {
        super(x, y, width, height, message);
        this.list = new DropDownWidgetList(this, elements, parent, width, tooltip, index -> {
            this.text = (McTextComponent)elements.get((int)index);
            this.switchOpen();
            this.playDownSound();
            onSelect.accept((Integer)index);
        });
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.open && this.list.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (super.mouseClicked(mouseX, mouseY, button)) {
            this.switchOpen();
            return true;
        }
        if (!this.open) {
            return false;
        }
        this.switchOpen();
        this.playDownSound();
        return true;
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return this.open && this.list.mouseDragged(mouseX, mouseY, button, deltaX, deltaY) || super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    @Override
    public void renderButton(@NotNull GuiRenderContext context, int mouseX, int mouseY, float delta) {
        this.renderBackground(context, mouseX, mouseY);
        this.renderArrow(context);
        this.renderText(context);
        if (!this.open) {
            return;
        }
        this.list.render(context, mouseX, mouseY, delta);
    }

    @Override
    protected void renderBackground(@NotNull GuiRenderContext context, int mouseX, int mouseY) {
        GuiWidgetTexture sprite = this.isFocused() ? GuiWidgetTexture.TEXT_FIELD_ACTIVE : GuiWidgetTexture.TEXT_FIELD;
        context.blitSprite(sprite, this.x, this.y, 0, 0, this.width / 2, this.height);
        context.blitSprite(sprite, this.x + this.width / 2, this.y, sprite.getSpriteWidth() - this.width / 2, 0, this.width / 2, this.height);
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double delta) {
        return this.open && this.list.mouseScrolled(mouseX, mouseY, delta);
    }

    @Override
    public boolean isMouseOver(double mouseX, double mouseY) {
        return this.open && this.list.isMouseOver(mouseX, mouseY) || super.isMouseOver(mouseX, mouseY);
    }

    private void switchOpen() {
        if (this.open) {
            this.open = false;
            this.list.setScrollTop(0.0);
        } else {
            this.open = true;
        }
    }

    private void renderText(@NotNull GuiRenderContext context) {
        context.drawOrderedString(this.getText(), this.active ? this.width - 23 : this.width - 5, this.x + 5, this.y + this.height / 2 - RenderUtil.getFontHeight() / 2, this.active ? new Color(0xE0E0E0) : new Color(0x707070));
    }

    private void renderArrow(@NotNull GuiRenderContext context) {
        if (!this.active) {
            return;
        }
        if (this.open) {
            for (int i = 0; i < 5; ++i) {
                context.fill(this.x + this.width - (9 + i), this.y + (this.height - 5) / 2 + i, this.x + this.width - (8 - i), this.y + (this.height - 5) / 2 + 2 + i, Colors.GRAY);
            }
        } else {
            for (int i = 0; i < 5; ++i) {
                context.fill(this.x + this.width - (13 - i), this.y + (this.height - 5) / 2 + (i > 0 ? 1 + i : 0), this.x + this.width - (4 + i), this.y + (this.height - 5) / 2 + 2 + i, Colors.GRAY);
            }
        }
    }
}

