/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.config.hotkey;

import org.jetbrains.annotations.NotNull;
import su.plo.config.entry.BooleanConfigEntry;
import su.plo.config.entry.ConfigEntry;
import su.plo.lib.mod.client.chat.ClientChatUtil;
import su.plo.slib.api.chat.component.McTextComponent;
import su.plo.voice.api.client.PlasmoVoiceClient;
import su.plo.voice.api.client.config.hotkey.Hotkey;
import su.plo.voice.api.client.config.hotkey.Hotkeys;
import su.plo.voice.client.config.VoiceClientConfig;
import su.plo.voice.proto.packets.tcp.serverbound.PlayerStatePacket;

public final class HotkeyActions {
    private final PlasmoVoiceClient voiceClient;
    private final Hotkeys hotkeys;
    private final VoiceClientConfig config;

    public void register() {
        this.setHotkeyAction("key.plasmovoice.general.mute_microphone", this.createConfigToggleAction(this.config.getVoice().getMicrophoneDisabled()));
        this.config.getVoice().getMicrophoneDisabled().addChangeListener(value -> this.sendPlayerStatePacket());
        this.setHotkeyAction("key.plasmovoice.general.disable_voice", this.createConfigToggleAction(this.config.getVoice().getDisabled()));
        this.config.getVoice().getDisabled().addChangeListener(value -> this.sendPlayerStatePacket());
        this.setHotkeyAction("key.plasmovoice.occlusion.toggle", this.createKeyDownAction(() -> {
            BooleanConfigEntry entry;
            entry.set((Boolean)(entry = this.config.getVoice().getSoundOcclusion()).value() == false);
            ClientChatUtil.setActionBar(McTextComponent.translatable("message.plasmovoice.occlusion_changed", (Boolean)entry.value() != false ? McTextComponent.translatable("message.plasmovoice.on", new Object[0]) : McTextComponent.translatable("message.plasmovoice.off", new Object[0])));
        }));
    }

    private Hotkey.OnPress createConfigToggleAction(ConfigEntry<Boolean> entry) {
        return this.createKeyDownAction(() -> entry.set((Boolean)entry.value() == false));
    }

    private Hotkey.OnPress createKeyDownAction(Runnable runnable) {
        return action -> {
            if (action != Hotkey.Action.DOWN) {
                return;
            }
            runnable.run();
        };
    }

    private void setHotkeyAction(@NotNull String name, @NotNull Hotkey.OnPress onPress) {
        this.hotkeys.getHotkey(name).ifPresent(hotkey -> hotkey.addPressListener(onPress));
    }

    private void sendPlayerStatePacket() {
        this.voiceClient.getServerConnection().ifPresent(connection -> connection.sendPacket(new PlayerStatePacket((Boolean)this.config.getVoice().getDisabled().value(), (Boolean)this.config.getVoice().getMicrophoneDisabled().value())));
    }

    public HotkeyActions(PlasmoVoiceClient voiceClient, Hotkeys hotkeys, VoiceClientConfig config) {
        this.voiceClient = voiceClient;
        this.hotkeys = hotkeys;
        this.config = config;
    }
}

