/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.audio.device;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.sound.sampled.AudioFormat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.voice.api.client.PlasmoVoiceClient;
import su.plo.voice.api.client.audio.device.AudioDevice;
import su.plo.voice.api.client.audio.device.DeviceException;
import su.plo.voice.api.client.audio.filter.AudioFilter;
import su.plo.voice.api.client.audio.filter.AudioFilterContext;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;
import su.plo.voice.libs.kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0017\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u0016H\u0016J\u0010\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0017H\u0016J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00170\u001fH\u0016J \u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\u000e\u0010#\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010$H\u0016J\b\u0010%\u001a\u00020\u0019H$R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lsu/plo/voice/client/audio/device/BaseAudioDevice;", "Lsu/plo/voice/api/client/audio/device/AudioDevice;", "voiceClient", "Lsu/plo/voice/api/client/PlasmoVoiceClient;", "name", "", "format", "Ljavax/sound/sampled/AudioFormat;", "<init>", "(Lsu/plo/voice/api/client/PlasmoVoiceClient;Ljava/lang/String;Ljavax/sound/sampled/AudioFormat;)V", "getVoiceClient", "()Lsu/plo/voice/api/client/PlasmoVoiceClient;", "getName", "()Ljava/lang/String;", "getFormat", "()Ljavax/sound/sampled/AudioFormat;", "frameSize", "", "getFrameSize", "()I", "filters", "Lcom/google/common/collect/ListMultimap;", "Lsu/plo/voice/api/client/audio/filter/AudioFilter$Priority;", "Lsu/plo/voice/api/client/audio/filter/AudioFilter;", "reload", "", "addFilter", "filter", "priority", "removeFilter", "getFilters", "", "processFilters", "", "samples", "excludeFilter", "Ljava/util/function/Predicate;", "open", "plasmovoice-fabric-1.21.4"})
@SourceDebugExtension(value={"SMAP\nBaseAudioDevice.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseAudioDevice.kt\nsu/plo/voice/client/audio/device/BaseAudioDevice\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,71:1\n1#2:72\n*E\n"})
public abstract class BaseAudioDevice
implements AudioDevice {
    @NotNull
    private final PlasmoVoiceClient voiceClient;
    @NotNull
    private final String name;
    @NotNull
    private final AudioFormat format;
    private final int frameSize;
    @NotNull
    private final ListMultimap<AudioFilter.Priority, AudioFilter> filters;

    public BaseAudioDevice(@NotNull PlasmoVoiceClient voiceClient, @NotNull String name, @NotNull AudioFormat format) {
        Intrinsics.checkNotNullParameter(voiceClient, "voiceClient");
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(format, "format");
        this.voiceClient = voiceClient;
        this.name = name;
        this.format = format;
        this.frameSize = (int)this.getFormat().getSampleRate() / 1000 * 20;
        ListMultimap listMultimap = Multimaps.synchronizedListMultimap((ListMultimap)Multimaps.newListMultimap((Map)new HashMap(), BaseAudioDevice::filters$lambda$0));
        Intrinsics.checkNotNullExpressionValue(listMultimap, "synchronizedListMultimap(...)");
        this.filters = listMultimap;
    }

    @NotNull
    protected final PlasmoVoiceClient getVoiceClient() {
        return this.voiceClient;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public AudioFormat getFormat() {
        return this.format;
    }

    @Override
    public int getFrameSize() {
        return this.frameSize;
    }

    @Override
    public void reload() throws DeviceException {
        if (!this.isOpen()) {
            throw new DeviceException("Device is not open");
        }
        this.close();
        this.open();
    }

    @Override
    public void addFilter(@NotNull AudioFilter filter2, @NotNull AudioFilter.Priority priority) {
        Intrinsics.checkNotNullParameter(filter2, "filter");
        Intrinsics.checkNotNullParameter((Object)priority, "priority");
        for (AudioFilter.Priority filtersPriority : AudioFilter.Priority.values()) {
            List list = this.filters.get((Object)filtersPriority);
            Intrinsics.checkNotNullExpressionValue(list, "get(...)");
            Collection filters = list;
            if (!filters.contains(filter2)) continue;
            boolean bl = false;
            String string = "Filter is already exist with priority: " + filtersPriority;
            throw new IllegalArgumentException(string.toString());
        }
        this.filters.put((Object)priority, (Object)filter2);
    }

    @Override
    public void removeFilter(@NotNull AudioFilter filter2) {
        Intrinsics.checkNotNullParameter(filter2, "filter");
        for (AudioFilter.Priority filtersPriority : AudioFilter.Priority.values()) {
            List list = this.filters.get((Object)filtersPriority);
            Intrinsics.checkNotNullExpressionValue(list, "get(...)");
            Collection filters = list;
            filters.remove(filter2);
        }
    }

    @Override
    @NotNull
    public Collection<AudioFilter> getFilters() {
        Collection collection = this.filters.values();
        Intrinsics.checkNotNullExpressionValue(collection, "values(...)");
        return collection;
    }

    @Override
    @NotNull
    public short[] processFilters(@NotNull short[] samples, @Nullable Predicate<AudioFilter> excludeFilter) {
        Intrinsics.checkNotNullParameter(samples, "samples");
        AudioFilterContext context = new AudioFilterContext(this);
        short[] samples2 = samples;
        for (AudioFilter filter2 : this.filters.values()) {
            if (!filter2.isEnabled() || filter2.getSupportedChannels() > 0 && filter2.getSupportedChannels() != context.getChannels()) continue;
            Predicate<AudioFilter> predicate = excludeFilter;
            if (predicate != null ? predicate.test(filter2) : false) continue;
            samples2 = filter2.process(context, samples2);
        }
        return samples2;
    }

    protected abstract void open() throws DeviceException;

    private static final List filters$lambda$0() {
        return new ArrayList();
    }
}

