/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.api.server.config;

import java.util.Collection;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ServerConfig {
    @NotNull
    public String serverId();

    @NotNull
    public String defaultLanguage();

    public boolean debug();

    public boolean useCrowdinTranslations();

    public boolean checkForUpdates();

    @NotNull
    public Host host();

    @NotNull
    public Voice voice();

    public static interface Voice {
        public byte[] aesEncryptionKey();

        public int sampleRate();

        public int keepAliveTimeoutMs();

        public int mtuSize();

        public boolean clientModRequired();

        public long clientModRequiredCheckTimeoutMs();

        @NotNull
        public String clientModMinVersion();

        @NotNull
        public Proximity proximity();

        @NotNull
        public Opus opus();

        @NotNull
        public Weights weights();

        public static interface Opus {
            @NotNull
            public String mode();

            public int bitrate();
        }

        public static interface Proximity {
            public Collection<Integer> distances();

            public int defaultDistance();
        }

        public static interface Weights {
            public Optional<Integer> getActivationWeight(@NotNull String var1);

            public Optional<Integer> getSourceLineWeight(@NotNull String var1);
        }
    }

    public static interface Host {
        @NotNull
        public String ip();

        public int port();

        @Nullable
        public Public hostPublic();

        public static interface Public {
            @NotNull
            public String ip();

            public int port();
        }
    }
}

