/*
 * Decompiled with CFR 0.152.
 */
package su.plo.lib.mod.client.chat;

import java.text.MessageFormat;
import java.util.Locale;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.lib.mod.client.chat.ClientLanguageSupplier;
import su.plo.lib.mod.client.language.LanguageUtil;
import su.plo.slib.api.chat.component.McTextComponent;
import su.plo.slib.api.chat.converter.McTextConverter;
import su.plo.slib.chat.AdventureComponentTextConverter;
import su.plo.slib.language.MiniMessageComponentRenderer;
import su.plo.slib.libs.adventure.adventure.key.Key;
import su.plo.slib.libs.adventure.adventure.text.Component;
import su.plo.slib.libs.adventure.adventure.text.TranslatableComponent;
import su.plo.slib.libs.adventure.adventure.text.renderer.TranslatableComponentRenderer;
import su.plo.slib.libs.adventure.adventure.translation.Translator;
import su.plo.slib.mod.chat.ComponentTextConverter;

public final class ClientTextConverter
implements McTextConverter<class_2561> {
    private final AdventureComponentTextConverter adventureTextConverter = new AdventureComponentTextConverter();
    private final ComponentTextConverter textConverter = ComponentTextConverter.INSTANCE;
    private final TranslatableComponentRenderer<Locale> textRenderer;
    private ClientLanguageSupplier languageSupplier;

    public ClientTextConverter() {
        Translator translator = new Translator(){

            @Override
            @NotNull
            public Key name() {
                return Key.key("plasmo", "voice/v2/client/translator");
            }

            @Override
            public @Nullable Component translate(@NotNull TranslatableComponent component, @NotNull Locale locale) {
                if (LanguageUtil.has(component.key())) {
                    return null;
                }
                String translationString = ClientTextConverter.this.languageSupplier.get().map(language -> (String)language.get(component.key())).orElse(null);
                if (translationString == null) {
                    return null;
                }
                return MiniMessageComponentRenderer.INSTANCE.renderTranslatable(component, translationString, locale, ClientTextConverter.this.textRenderer);
            }

            @Override
            @Nullable
            public MessageFormat translate(@NotNull String key, @NotNull Locale locale) {
                return null;
            }
        };
        this.textRenderer = TranslatableComponentRenderer.usingTranslationSource(translator);
    }

    @Override
    @NotNull
    public String convertToJson(@NotNull class_2561 text) {
        return this.textConverter.convertToJson(text);
    }

    @Override
    public class_2561 convertFromJson(@NotNull String json) {
        return this.textConverter.convertFromJson(json);
    }

    @Override
    public class_2561 convert(@NotNull McTextComponent text) {
        String json = this.adventureTextConverter.convertToJson(this.textRenderer.render(this.adventureTextConverter.convert(text), Translator.parseLocale("en_us")));
        return this.convertFromJson(json);
    }

    public void setLanguageSupplier(ClientLanguageSupplier languageSupplier) {
        this.languageSupplier = languageSupplier;
    }
}

