/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.render;

import com.mojang.blaze3d.systems.RenderSystem;
import net.diebuddies.compat.Iris;
import net.diebuddies.compat.Optifine;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.opengl.VAO;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.PhysicsWorld;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.liquid.Liquid;
import net.diebuddies.render.MainRenderer;
import net.diebuddies.util.PerformanceTracker;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_286;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_5944;
import net.minecraft.class_638;
import org.joml.Matrix4d;
import org.joml.Matrix4dc;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.lwjgl.opengl.GL20;

public class LiquidRenderer {
    private MainRenderer mainRenderer;
    private int mcEntityLocation = -1;
    private Matrix4d transformation = new Matrix4d();
    private Matrix4f localT = new Matrix4f();

    public LiquidRenderer(MainRenderer mainRenderer) {
        this.mainRenderer = mainRenderer;
    }

    public void render(class_638 level, class_1921 blockLayerIn, double xIn, double yIn, double zInm, Matrix4f viewMatrix, Matrix4f projectionMatrix) {
        PhysicsMod mod;
        PhysicsWorld physics;
        if (level != null && ((physics = (mod = PhysicsMod.getInstance((class_1937)level)).getPhysicsWorld()).getLiquids().size() > 0 || physics.getOceanWorld().getOceanMeshes().size() > 0)) {
            blockLayerIn.method_23516();
            Matrix4fStack matrixStackIn = RenderSystem.getModelViewStack();
            class_243 view = class_310.method_1551().field_1773.method_19418().method_19326();
            matrixStackIn.pushMatrix();
            matrixStackIn.set((Matrix4fc)viewMatrix);
            class_310.method_1551().field_1773.method_22974().method_3316();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.mainRenderer.setupShader(RenderSystem.getShader());
            VAO.storePreviouslyBoundState();
            if (StarterClient.optifabric && Optifine.areShadersEnabled()) {
                this.mcEntityLocation = 11;
            } else if (StarterClient.iris) {
                this.mcEntityLocation = GL20.glGetAttribLocation((int)RenderSystem.getShader().method_1270(), (CharSequence)"mc_Entity");
            }
            PerformanceTracker.startNoFlush("liquid_rendering");
            if (ConfigClient.cudaLiquids()) {
                this.mainRenderer.liquidDeferredRenderer.render(physics, level, matrixStackIn, view);
            } else {
                for (int i = 0; i < physics.getLiquids().size(); ++i) {
                    Liquid liquid = physics.getLiquids().get(i);
                    if (liquid.vao == null) continue;
                    this.renderLiquid(physics, level, matrixStackIn, view, liquid);
                }
            }
            PerformanceTracker.end("liquid_rendering");
            this.mainRenderer.oceanRenderer.render(physics, level, matrixStackIn, view);
            VAO.restorePreviouslyBoundState();
            class_286.method_34420();
            RenderSystem.getShader().method_34585();
            matrixStackIn.popMatrix();
            RenderSystem.activeTexture((int)33984);
            RenderSystem.enableCull();
            blockLayerIn.method_23518();
            if (level.method_28103().method_29993()) {
                class_308.method_1452();
            } else {
                class_308.method_27869();
            }
            this.setupAttribute(this.mcEntityLocation, 0.0f, 0.0f, 0.0f, 1.0f);
            if (StarterClient.optifabric && Optifine.isUsingShadersNoInternal()) {
                Optifine.useWaterShader();
            }
        }
    }

    private void renderLiquid(PhysicsWorld physics, class_638 level, Matrix4fStack matrixStackIn, class_243 view, Liquid liquid) {
        this.setupAttribute(this.mcEntityLocation, liquid.materialID, liquid.renderType, -1.0f, -1.0f);
        RenderSystem.enableCull();
        this.transformation.set((Matrix4dc)liquid.transformation);
        this.transformation.m30(this.transformation.m30() - view.field_1352);
        this.transformation.m31(this.transformation.m31() - view.field_1351);
        this.transformation.m32(this.transformation.m32() - view.field_1350);
        float scale = 1.0f / (float)liquid.gridSize;
        this.transformation.scale((double)scale);
        matrixStackIn.pushMatrix();
        this.localT.set((Matrix4dc)this.transformation);
        matrixStackIn.mul((Matrix4fc)this.localT);
        if (level.method_28103().method_29993()) {
            RenderSystem.shaderLightDirections[0] = MainRenderer.NETHER_DIFFUSE_LIGHT_0;
            RenderSystem.shaderLightDirections[1] = MainRenderer.NETHER_DIFFUSE_LIGHT_1;
        } else {
            RenderSystem.shaderLightDirections[0] = MainRenderer.DIFFUSE_LIGHT_0;
            RenderSystem.shaderLightDirections[1] = MainRenderer.DIFFUSE_LIGHT_1;
        }
        RenderSystem.setShaderTexture((int)0, (int)liquid.textureID);
        RenderSystem.activeTexture((int)33984);
        RenderSystem.bindTexture((int)liquid.textureID);
        this.mainRenderer.setupPBRTextures();
        class_5944 shader = RenderSystem.getShader();
        RenderSystem.setupShaderLights((class_5944)shader);
        if (!StarterClient.optifabric || !Optifine.isUsingShadersNoInternal()) {
            if (shader.field_29475 != null) {
                shader.field_29475.method_1300();
            }
            if (shader.field_29476 != null) {
                shader.field_29476.method_1300();
            }
        }
        if (StarterClient.optifabric && Optifine.isUsingShadersNoInternal()) {
            Optifine.setModelViewMatrix(RenderSystem.getModelViewMatrix());
        } else {
            shader.field_29470.method_1250(RenderSystem.getModelViewMatrix());
            shader.field_29470.method_1300();
            if (StarterClient.iris) {
                Iris.setNormalMatrix(shader, RenderSystem.getModelViewMatrix());
            }
        }
        liquid.vao.render();
        matrixStackIn.popMatrix();
    }

    public void setupAttribute(int location, float v0, float v1, float v2, float v3) {
        if (location != -1) {
            GL20.glVertexAttrib4f((int)location, (float)v0, (float)v1, (float)v2, (float)v3);
        }
    }
}

