/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.verlet.constraints;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.PhysicsWorld;
import net.diebuddies.physics.verlet.VerletHelper;
import net.diebuddies.physics.verlet.VerletPoint;
import net.diebuddies.physics.verlet.VerletSimulation;
import net.diebuddies.physics.verlet.VerletSimulationData;
import net.diebuddies.physics.verlet.constraints.VerletConstraint;
import net.diebuddies.physics.vines.VineHelper;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import org.joml.Matrix4fStack;
import org.joml.Vector3i;
import org.joml.Vector3ic;

public class WorldConstraint
implements VerletConstraint {
    public static final double CONTACT_FRICTION = 0.6;
    private class_1297 entity;
    private class_1937 level;
    private Map<Vector3i, List<class_238>> bodies;
    private Vector3i tmpInt = new Vector3i();
    private VerletHelper helper = new VerletHelper();
    private float preferUpMovement;

    public WorldConstraint(class_1937 level, float preferUpMovement) {
        this.preferUpMovement = preferUpMovement;
        this.level = level;
    }

    public WorldConstraint(class_1297 entity, float preferUpMovement) {
        this.preferUpMovement = preferUpMovement;
        this.entity = entity;
    }

    public WorldConstraint(class_1297 entity) {
        this(entity, 0.7f);
    }

    @Override
    public void updateBefore(double delta, VerletSimulation simulation) {
    }

    @Override
    public void subStep(double percent, VerletSimulation simulation) {
    }

    @Override
    public void updateAfter(double delta, VerletSimulation simulation) {
        this.checkVerletCollisions(simulation);
    }

    @Override
    public boolean initAsyncData(PhysicsWorld world, VerletSimulation simulation) {
        VerletSimulationData data = simulation.getData();
        if (data.points.size() == 0) {
            return false;
        }
        if (this.entity != null) {
            this.level = this.entity.method_5770();
        }
        PhysicsWorld physics = PhysicsMod.getInstance(this.level).getPhysicsWorld();
        VerletPoint start = data.points.get(0);
        class_2338.class_2339 min = new class_2338.class_2339(start.position.x + data.offset.x, start.position.y + data.offset.y, start.position.z + data.offset.z);
        class_2338.class_2339 max = new class_2338.class_2339(start.position.x + data.offset.x, start.position.y + data.offset.y, start.position.z + data.offset.z);
        for (int i = 0; i < data.points.size(); ++i) {
            VerletPoint point = data.points.get(i);
            int x = class_3532.method_15357((double)(point.position.x + data.offset.x));
            int y = class_3532.method_15357((double)(point.position.y + data.offset.y));
            int z = class_3532.method_15357((double)(point.position.z + data.offset.z));
            if (x < min.method_10263()) {
                min.method_33097(x);
            } else if (x > max.method_10263()) {
                max.method_33097(x);
            }
            if (y < min.method_10264()) {
                min.method_33098(y);
            } else if (y > max.method_10264()) {
                max.method_33098(y);
            }
            if (z < min.method_10260()) {
                min.method_33099(z);
                continue;
            }
            if (z <= max.method_10260()) continue;
            max.method_33099(z);
        }
        this.bodies = new Object2ObjectOpenHashMap();
        class_2338.class_2339 currentPos = new class_2338.class_2339(0, 0, 0);
        if (max.method_10263() - min.method_10263() > 10) {
            return false;
        }
        if (max.method_10264() - min.method_10264() > 10) {
            return false;
        }
        if (max.method_10260() - min.method_10260() > 10) {
            return false;
        }
        for (int x = min.method_10263() - 1; x <= max.method_10263() + 1; ++x) {
            for (int y = min.method_10264() - 1; y <= max.method_10264() + 1; ++y) {
                for (int z = min.method_10260() - 1; z <= max.method_10260() + 1; ++z) {
                    class_265 voxelShape;
                    currentPos.method_10103(x, y, z);
                    class_2680 state = physics.getWorld().method_8320((class_2338)currentPos);
                    if (state.method_26204() == class_2246.field_10124 || (voxelShape = state.method_26220((class_1922)physics.getWorld(), (class_2338)currentPos)).method_1110() || VineHelper.getSetting(state) != null) continue;
                    for (class_238 aabb : voxelShape.method_1090()) {
                        this.addToSuroundings(new class_238(aabb.field_1323 + (double)x - data.offset.x, aabb.field_1322 + (double)y - data.offset.y, aabb.field_1321 + (double)z - data.offset.z, aabb.field_1320 + (double)x - data.offset.x, aabb.field_1325 + (double)y - data.offset.y, aabb.field_1324 + (double)z - data.offset.z), x, y, z, this.bodies);
                    }
                }
            }
        }
        return false;
    }

    private void addToSuroundings(class_238 box, int x, int y, int z, Map<Vector3i, List<class_238>> bodies) {
        for (int xi = -1; xi <= 1; ++xi) {
            for (int yi = -1; yi <= 1; ++yi) {
                for (int zi = -1; zi <= 1; ++zi) {
                    ObjectArrayList boxes = bodies.get(this.tmpInt.set(x + xi, y + yi, z + zi));
                    if (boxes == null) {
                        boxes = new ObjectArrayList();
                        bodies.put(new Vector3i((Vector3ic)this.tmpInt), (List<class_238>)boxes);
                    }
                    boxes.add((class_238)box);
                }
            }
        }
    }

    private void checkVerletCollisions(VerletSimulation simulation) {
        VerletSimulationData data = simulation.getData();
        double enlarge = 0.05;
        block0: for (VerletPoint point : data.points) {
            int z;
            int y;
            int x;
            List<class_238> boxes;
            if (point.locked || (boxes = this.bodies.get(this.tmpInt.set(x = class_3532.method_15357((double)(point.position.x + data.offset.x)), y = class_3532.method_15357((double)(point.position.y + data.offset.y)), z = class_3532.method_15357((double)(point.position.z + data.offset.z))))) == null) continue;
            for (int i = 0; i < boxes.size(); ++i) {
                class_238 box = boxes.get(i);
                if (!this.helper.movePointOutOfBox(point.position, this.preferUpMovement, (double)((float)(box.field_1323 - enlarge)), (double)((float)(box.field_1322 - enlarge)), (double)((float)(box.field_1321 - enlarge)), (double)((float)(box.field_1320 + enlarge)), (double)((float)(box.field_1325 + enlarge)), (double)((float)(box.field_1324 + enlarge)))) continue;
                point.friction = 0.6;
                continue block0;
            }
        }
    }

    @Override
    public void renderBefore(Matrix4fStack matrixStack, double delta, VerletSimulation simulation) {
    }

    @Override
    public void renderAfter(Matrix4fStack matrixStack, double delta, VerletSimulation simulation) {
    }

    @Override
    public void render(Matrix4fStack matrixStack, double delta, VerletSimulation simulation) {
    }
}

