/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.snow;

import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import java.util.Map;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.physics.snow.IChunk;
import net.diebuddies.physics.snow.SnowProperty;
import net.diebuddies.physics.snow.SnowWorld;
import net.diebuddies.physics.vines.FastBlockSearcherConsumer;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2493;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2837;
import net.minecraft.class_4076;
import org.joml.Vector3i;

public class SnowSearcher
implements FastBlockSearcherConsumer {
    private static final Map<class_2248, SnowProperty> snowBlocks = new Reference2ReferenceOpenHashMap(3, 0.25f);
    private class_2837<class_2680> palette;
    private int xc;
    private int yc;
    private int zc;
    private SnowWorld snowWorld;
    private Map<Vector3i, class_2680> snow;
    private ShortSet lightUpdates;
    private int count;
    private class_2338.class_2339 pos = new class_2338.class_2339();

    public static boolean isPhysicsSnow(class_2680 blockState) {
        return SnowSearcher.getSnowProperty(blockState) != null;
    }

    public static SnowProperty getSnowProperty(class_2680 state) {
        class_2248 block = state.method_26204();
        SnowProperty property = snowBlocks.get(block);
        if (ConfigClient.grassSnowy && property == null && block instanceof class_2493 && ((Boolean)state.method_11654((class_2769)class_2493.field_11522)).booleanValue()) {
            return SnowProperty.FULL;
        }
        return property;
    }

    public SnowSearcher(SnowWorld snowWorld, Map<Vector3i, class_2680> snow, int x, int y, int z, class_2837<class_2680> data) {
        this.snowWorld = snowWorld;
        this.xc = x;
        this.yc = y;
        this.zc = z;
        this.snow = snow;
        this.palette = data;
        this.lightUpdates = this.snowWorld.getLightUpdates(class_4076.method_18685((int)class_4076.method_18675((int)x), (int)class_4076.method_18675((int)y), (int)class_4076.method_18675((int)z)));
    }

    @Override
    public void accept(int value, int amount) {
        this.accept((class_2680)this.palette.method_12288(value), amount);
    }

    @Override
    public void accept(class_2680 state, int amount) {
        if (SnowSearcher.getSnowProperty(state) != null) {
            for (int i = 0; i < amount; ++i) {
                int x = this.count & 0xF;
                int y = this.count >> 8 & 0xF;
                int z = this.count >> 4 & 0xF;
                int rx = x * IChunk.CHUNK_MULTIPLE;
                int ry = y * IChunk.CHUNK_MULTIPLE;
                int rz = z * IChunk.CHUNK_MULTIPLE;
                this.pos.method_10103(x + this.xc, y + this.yc, z + this.zc);
                this.snow.put(new Vector3i(rx, ry, rz), state);
                SnowSearcher.queueLightUpdates(this.snowWorld, this.lightUpdates, this.pos.method_10263(), this.pos.method_10264(), this.pos.method_10260());
                ++this.count;
            }
        } else {
            this.count += amount;
        }
    }

    public static void queueLightUpdates(SnowWorld snowWorld, ShortSet lightUpdates, int x, int y, int z) {
        int ax = x & 0xF;
        int ay = y & 0xF;
        int az = z & 0xF;
        for (int xo = -1; xo <= 1; ++xo) {
            for (int yo = -1; yo <= 1; ++yo) {
                for (int zo = -1; zo <= 1; ++zo) {
                    int lx = ax + xo;
                    int ly = ay + yo;
                    int lz = az + zo;
                    if (SnowSearcher.outOfBounds(lx, ly, lz)) {
                        ShortSet updates = snowWorld.getLightUpdates(class_4076.method_18685((int)class_4076.method_18675((int)(x + xo)), (int)class_4076.method_18675((int)(y + yo)), (int)class_4076.method_18675((int)(z + zo))));
                        updates.add((short)((lx & 0xF) << 8 | (ly & 0xF) << 4 | lz & 0xF));
                        continue;
                    }
                    lightUpdates.add((short)(lx << 8 | ly << 4 | lz));
                }
            }
        }
    }

    private static boolean outOfBounds(int x, int y, int z) {
        return x >= 16 || y >= 16 || z >= 16 || x < 0 || y < 0 || z < 0;
    }

    static {
        snowBlocks.put(class_2246.field_10477, SnowProperty.LAYER);
        snowBlocks.put(class_2246.field_10491, SnowProperty.FULL);
        snowBlocks.put(class_2246.field_27879, SnowProperty.FULL);
    }
}

