/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.settings.gui.legacy;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import net.diebuddies.physics.settings.ButtonSettings;
import net.diebuddies.physics.settings.gui.legacy.UXTooltipAccessor;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_4264;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import org.jetbrains.annotations.Nullable;

public class CycleButton<T>
extends class_4264
implements UXTooltipAccessor {
    static final BooleanSupplier DEFAULT_ALT_LIST_SELECTOR = class_437::method_25443;
    private static final List<Boolean> BOOLEAN_OPTIONS = ImmutableList.of((Object)Boolean.TRUE, (Object)Boolean.FALSE);
    private final class_2561 name;
    private int index;
    private T value;
    private final ValueListSupplier<T> values;
    private final Function<T, class_2561> valueStringifier;
    private final Function<CycleButton<T>, class_5250> narrationProvider;
    private final OnValueChange<T> onValueChange;
    private final TooltipSupplier<T> tooltipSupplier;
    private final boolean displayOnlyValue;

    CycleButton(int i, int j, int k, int l, class_2561 component, class_2561 component2, int m, T object, ValueListSupplier<T> valueListSupplier, Function<T, class_2561> function, Function<CycleButton<T>, class_5250> function2, OnValueChange<T> onValueChange, TooltipSupplier<T> tooltipSupplier, boolean bl) {
        super(i, j, k, l, component);
        this.name = component2;
        this.index = m;
        this.value = object;
        this.values = valueListSupplier;
        this.valueStringifier = function;
        this.narrationProvider = function2;
        this.onValueChange = onValueChange;
        this.tooltipSupplier = tooltipSupplier;
        this.displayOnlyValue = bl;
        ButtonSettings.addCustomButtonStyle(this);
    }

    public void method_25306() {
        if (class_437.method_25442()) {
            this.cycleValue(-1);
        } else {
            this.cycleValue(1);
        }
    }

    private void cycleValue(int i) {
        List<T> list = this.values.getSelectedList();
        this.index = class_3532.method_15387((int)(this.index + i), (int)list.size());
        T object = list.get(this.index);
        this.updateValue(object);
        this.onValueChange.onValueChange(this, object);
    }

    private T getCycledValue(int i) {
        List<T> list = this.values.getSelectedList();
        return list.get(class_3532.method_15387((int)(this.index + i), (int)list.size()));
    }

    public boolean method_25401(double d, double e, double f, double g) {
        if (g > 0.0) {
            this.cycleValue(-1);
        } else if (g < 0.0) {
            this.cycleValue(1);
        }
        return true;
    }

    public void setValue(T object) {
        List<T> list = this.values.getSelectedList();
        int i = list.indexOf(object);
        if (i != -1) {
            this.index = i;
        }
        this.updateValue(object);
    }

    private void updateValue(T object) {
        class_2561 component = this.createLabelForValue(object);
        this.method_25355(component);
        this.value = object;
    }

    private class_2561 createLabelForValue(T object) {
        return this.displayOnlyValue ? this.valueStringifier.apply(object) : this.createFullName(object);
    }

    private class_5250 createFullName(T object) {
        return class_5244.method_32700((class_2561)this.name, (class_2561)this.valueStringifier.apply(object));
    }

    public T getValue() {
        return this.value;
    }

    protected class_5250 method_25360() {
        return this.narrationProvider.apply(this);
    }

    public void method_47399(class_6382 narrationElementOutput) {
        narrationElementOutput.method_37034(class_6381.field_33788, (class_2561)this.method_25360());
        if (this.field_22763) {
            T object = this.getCycledValue(1);
            class_2561 component = this.createLabelForValue(object);
            if (this.method_25370()) {
                narrationElementOutput.method_37034(class_6381.field_33791, (class_2561)class_2561.method_43469((String)"narration.cycle_button.usage.focused", (Object[])new Object[]{component}));
            } else {
                narrationElementOutput.method_37034(class_6381.field_33791, (class_2561)class_2561.method_43469((String)"narration.cycle_button.usage.hovered", (Object[])new Object[]{component}));
            }
        }
    }

    public class_5250 createDefaultNarrationMessage() {
        return CycleButton.method_32602((class_2561)(this.displayOnlyValue ? this.createFullName(this.value) : this.method_25369()));
    }

    @Override
    public class_2561 getTooltipLegacy() {
        return (class_2561)this.tooltipSupplier.apply(this.value);
    }

    public static <T> Builder<T> builder(Function<T, class_2561> function) {
        return new Builder<T>(function);
    }

    public static Builder<Boolean> booleanBuilder(class_2561 component, class_2561 component2) {
        return new Builder<Boolean>(boolean_ -> boolean_ != false ? component : component2).withValues(BOOLEAN_OPTIONS);
    }

    public static Builder<Boolean> onOffBuilder() {
        return new Builder<Boolean>(boolean_ -> boolean_ != false ? class_5244.field_24332 : class_5244.field_24333).withValues(BOOLEAN_OPTIONS);
    }

    public static Builder<Boolean> onOffBuilder(boolean bl) {
        return CycleButton.onOffBuilder().withInitialValue(bl);
    }

    public boolean method_25405(double d, double e) {
        return this.field_22764 && d >= (double)this.method_46426() && e >= (double)this.method_46427() && d < (double)(this.method_46426() + this.field_22758) && e < (double)(this.method_46427() + this.field_22759);
    }

    static interface ValueListSupplier<T> {
        public List<T> getSelectedList();

        public List<T> getDefaultList();

        public static <T> ValueListSupplier<T> create(List<T> list) {
            final ImmutableList list2 = ImmutableList.copyOf(list);
            return new ValueListSupplier<T>(){

                @Override
                public List<T> getSelectedList() {
                    return list2;
                }

                @Override
                public List<T> getDefaultList() {
                    return list2;
                }
            };
        }

        public static <T> ValueListSupplier<T> create(final BooleanSupplier booleanSupplier, List<T> list, List<T> list2) {
            final ImmutableList list3 = ImmutableList.copyOf(list);
            final ImmutableList list4 = ImmutableList.copyOf(list2);
            return new ValueListSupplier<T>(){

                @Override
                public List<T> getSelectedList() {
                    return booleanSupplier.getAsBoolean() ? list4 : list3;
                }

                @Override
                public List<T> getDefaultList() {
                    return list3;
                }
            };
        }
    }

    public static interface OnValueChange<T> {
        public void onValueChange(CycleButton var1, T var2);
    }

    @FunctionalInterface
    public static interface TooltipSupplier<T>
    extends Function<T, class_2561> {
    }

    public static class Builder<T> {
        private int initialIndex;
        @Nullable
        private T initialValue;
        private final Function<T, class_2561> valueStringifier;
        private TooltipSupplier<T> tooltipSupplier = object -> null;
        private Function<CycleButton<T>, class_5250> narrationProvider = CycleButton::createDefaultNarrationMessage;
        private ValueListSupplier<T> values = ValueListSupplier.create(ImmutableList.of());
        private boolean displayOnlyValue;

        public Builder(Function<T, class_2561> function) {
            this.valueStringifier = function;
        }

        public Builder<T> withValues(List<T> list) {
            this.values = ValueListSupplier.create(list);
            return this;
        }

        @SafeVarargs
        public final Builder<T> withValues(T ... objects) {
            return this.withValues((List<T>)ImmutableList.copyOf((Object[])objects));
        }

        public Builder<T> withValues(List<T> list, List<T> list2) {
            this.values = ValueListSupplier.create(DEFAULT_ALT_LIST_SELECTOR, list, list2);
            return this;
        }

        public Builder<T> withValues(BooleanSupplier booleanSupplier, List<T> list, List<T> list2) {
            this.values = ValueListSupplier.create(booleanSupplier, list, list2);
            return this;
        }

        public Builder<T> withTooltip(TooltipSupplier<T> tooltipSupplier) {
            this.tooltipSupplier = tooltipSupplier;
            return this;
        }

        public Builder<T> withInitialValue(T object) {
            this.initialValue = object;
            int i = this.values.getDefaultList().indexOf(object);
            if (i != -1) {
                this.initialIndex = i;
            }
            return this;
        }

        public Builder<T> withCustomNarration(Function<CycleButton<T>, class_5250> function) {
            this.narrationProvider = function;
            return this;
        }

        public Builder<T> displayOnlyValue() {
            this.displayOnlyValue = true;
            return this;
        }

        public CycleButton<T> create(int i, int j, int k, int l, class_2561 component) {
            return this.create(i, j, k, l, component, (cycleButton, object) -> {});
        }

        public CycleButton<T> create(int i, int j, int k, int l, class_2561 component, OnValueChange<T> onValueChange) {
            List<T> list = this.values.getDefaultList();
            if (list.isEmpty()) {
                throw new IllegalStateException("No values for cycle button");
            }
            T object = this.initialValue != null ? this.initialValue : list.get(this.initialIndex);
            class_2561 component2 = this.valueStringifier.apply(object);
            class_2561 component3 = this.displayOnlyValue ? component2 : class_5244.method_32700((class_2561)component, (class_2561)component2);
            return new CycleButton<T>(i, j, k, l, component3, component, this.initialIndex, object, this.values, this.valueStringifier, this.narrationProvider, onValueChange, this.tooltipSupplier, this.displayOnlyValue);
        }
    }
}

