/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.settings.animation;

import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.diebuddies.math.Math;
import net.diebuddies.opengl.Box;
import net.diebuddies.physics.animation.Animation;
import net.diebuddies.physics.animation.AnimationType;
import net.diebuddies.physics.animation.CurveType;
import net.diebuddies.physics.animation.ParticleSpawn;
import net.diebuddies.physics.settings.ButtonSettings;
import net.diebuddies.physics.settings.animation.ParticleEngineExtension;
import net.diebuddies.physics.settings.animation.ParticleExtension;
import net.diebuddies.physics.settings.ux.Animatable;
import net.minecraft.class_10142;
import net.minecraft.class_10156;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_2394;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_364;
import net.minecraft.class_3999;
import net.minecraft.class_4184;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5944;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.class_7923;
import net.minecraft.class_9801;
import org.joml.Matrix4fStack;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class ParticleDisplayScreen
extends class_437 {
    public static final class_2960 STONE_TEXTURE = class_2960.method_60656((String)"textures/block/stone.png");
    public class_437 parent;
    private double xPosition = 70.0;
    private double animationStart;
    private boolean createdParticles;
    public Animation animation;
    private List<class_703> particles;
    private class_4184 camera = new class_4184();
    private long lastTick = System.currentTimeMillis();

    protected ParticleDisplayScreen(class_437 parent, class_2561 component) {
        super(component);
        this.parent = parent;
        this.particles = new ObjectArrayList();
        this.animation = new Animation("default", CurveType.Linear, 0.5f);
    }

    protected void method_25426() {
        super.method_25426();
        this.startAnimation();
        this.method_37063((class_364)((class_4185)((Animatable)ButtonSettings.builder((int)this.xPosition - 30, this.field_22790 - 57, 60, 20, (class_2561)class_2561.method_43471((String)"physicsmod.menu.animation.replay"), button -> this.startAnimation())).setAnimDepth(200.0f)));
    }

    public void startAnimation() {
        this.particles.clear();
        this.animationStart = (double)this.animation.speed + 0.5;
        this.createdParticles = false;
    }

    private void createParticles() {
        if (this.createdParticles) {
            return;
        }
        this.createdParticles = true;
        this.particles.clear();
        for (ParticleSpawn spawn : this.animation.particleSpawns) {
            class_2394 particleOptions = spawn.particle;
            if (particleOptions == null) continue;
            Int2ObjectMap<class_707<?>> provider = ((ParticleEngineExtension)this.field_22787.field_1713).getParticleProviders();
            class_707 particleProvider = (class_707)provider.get(class_7923.field_41180.method_10206((Object)particleOptions.method_10295()));
            if (!((double)Math.random() < spawn.spawnChance)) continue;
            for (int i = 0; i < spawn.amount; ++i) {
                double halfSpread = spawn.spread * 0.5;
                double px = (double)Math.random() * spawn.spread - halfSpread;
                double py = (double)Math.random() * spawn.spread - halfSpread;
                double pz = (double)Math.random() * spawn.spread - halfSpread;
                try {
                    class_703 particle = particleProvider.method_3090(particleOptions, null, px, py, pz, spawn.vx, spawn.vy, spawn.vz);
                    ((ParticleExtension)particle).setPhysics(false);
                    ((ParticleExtension)particle).setFakeLight(true);
                    this.particles.add(particle);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (spawn.sound == null) continue;
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)spawn.sound, (float)1.0f));
        }
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        guiGraphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 15, 0xFFFFFF);
        this.renderAnimation(delta);
        super.method_25394(guiGraphics, mouseX, mouseY, delta);
    }

    public void method_25393() {
        super.method_25393();
        this.lastTick = System.currentTimeMillis();
        Iterator<class_703> it = this.particles.iterator();
        while (it.hasNext()) {
            class_703 particle = it.next();
            if (!particle.method_3086()) continue;
            try {
                particle.method_3070();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (particle.method_3086()) continue;
            it.remove();
        }
    }

    private void renderAnimation(float delta) {
        float scale = 30.0f;
        Matrix4fStack matrices = RenderSystem.getModelViewStack();
        float realDelta = java.lang.Math.min(1.0f, (float)(System.currentTimeMillis() - this.lastTick) / 50.0f);
        double startX = -1.0;
        double endX = 1.0;
        double startY = -1.0;
        double endY = 1.0;
        double startZ = -1.0;
        double endZ = 1.0;
        double capeWidth = endX - startX;
        double capeHeight = endY - startY;
        double capeDepth = endZ - startZ;
        matrices.pushMatrix();
        matrices.translate((float)this.xPosition, (float)this.field_22790 / 2.0f, 100.0f);
        matrices.scale(scale, -scale, scale);
        matrices.translate((float)(-capeWidth * 0.5 - startX), (float)(-capeHeight * 0.5 - startY), (float)(-capeDepth * 0.5 - startZ));
        matrices.pushMatrix();
        matrices.rotate((Quaternionfc)new Quaternionf().rotationXYZ((float)java.lang.Math.toRadians(25.0), (float)java.lang.Math.toRadians(-25.0), 0.0f));
        class_5944 shader = RenderSystem.getShader();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShader((class_10156)class_10142.field_53886);
        RenderSystem.enableDepthTest();
        class_310.method_1551().field_1773.method_22974().method_3316();
        class_308.method_34742();
        RenderSystem.activeTexture((int)33984);
        RenderSystem.setShaderTexture((int)0, (class_2960)STONE_TEXTURE);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableCull();
        int brightness = 0xF00000;
        class_289 tesselator = class_289.method_1348();
        this.animationStart -= (double)delta * 0.05;
        float despawnScale = this.animation.getCurve().get((float)(this.animationStart / (double)this.animation.speed));
        if (this.animationStart > (double)this.animation.speed) {
            despawnScale = 1.0f;
        } else if (this.animationStart <= 0.0) {
            despawnScale = 0.0f;
        }
        float alpha = 1.0f;
        if (this.animation.despawnType == AnimationType.Vanish) {
            alpha = java.lang.Math.min(1.0f, despawnScale);
            despawnScale = 1.0f;
        } else if (this.animation.despawnType == AnimationType.Shrink_and_Vanish) {
            alpha = java.lang.Math.min(1.0f, despawnScale);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        class_287 bufferbuilder = tesselator.method_60827(class_293.class_5596.field_27379, class_290.field_1580);
        int[] indices = Box.INDICES;
        float[] positions = Box.POSITIONS;
        float[] normals = Box.NORMALS;
        float[] uvs = Box.UVS;
        for (int i = 0; i < indices.length; ++i) {
            int index = indices[i];
            float x = positions[index * 3] * 0.5f * despawnScale;
            float y = positions[index * 3 + 1] * 0.5f * despawnScale;
            float z = positions[index * 3 + 2] * 0.5f * despawnScale;
            float nx = -normals[index * 3];
            float ny = -normals[index * 3 + 1];
            float nz = -normals[index * 3 + 2];
            float uvx = uvs[index * 2];
            float uvy = uvs[index * 2 + 1];
            bufferbuilder.method_22912(x, y, z).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(uvx, uvy).method_22922(class_4608.field_21444).method_60803(brightness).method_22914(nx, ny, nz);
        }
        class_286.method_43433((class_9801)bufferbuilder.method_60794());
        if (this.animationStart <= 0.0) {
            this.createParticles();
        }
        matrices.popMatrix();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_4597.class_4598 bufferSource = class_310.method_1551().method_22940().method_23000();
        for (class_703 particle : this.particles) {
            if (!particle.method_3086()) continue;
            class_3999 particleRenderType = particle.method_18122();
            RenderSystem.setShader((class_10156)class_10142.field_53874);
            class_4588 vertexConsumer = bufferSource.getBuffer(Objects.requireNonNull(particleRenderType.comp_3341()));
            particle.method_3074(vertexConsumer, this.camera, realDelta);
            bufferSource.method_22994(particleRenderType.comp_3341());
        }
        matrices.popMatrix();
        class_308.method_24211();
        RenderSystem.setShader((class_5944)shader);
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    public void method_25420(class_332 guiGraphics, int i, int j, float f) {
    }
}

