/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.mixins.ocean;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import net.diebuddies.physics.ocean.OceanSplashParticle;
import net.minecraft.class_243;
import net.minecraft.class_3999;
import net.minecraft.class_4184;
import net.minecraft.class_4597;
import net.minecraft.class_702;
import net.minecraft.class_703;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_702.class})
public class MixinParticleEngine {
    @Shadow
    @Final
    private Map<class_3999, Queue<class_703>> field_3830;
    @Unique
    private List<OceanSplashParticle> translucent = new ObjectArrayList();

    @Inject(at={@At(value="HEAD")}, method={"render"})
    public void render(final class_4184 camera, final float renderPercent, class_4597.class_4598 bufferSource, CallbackInfo info) {
        Queue<class_703> queue = this.field_3830.get(class_3999.field_17829);
        if (queue != null) {
            this.translucent.clear();
            Iterator it = queue.iterator();
            while (it.hasNext()) {
                class_703 particle = (class_703)it.next();
                if (!(particle instanceof OceanSplashParticle)) continue;
                OceanSplashParticle oceanSplash = (OceanSplashParticle)particle;
                this.translucent.add(oceanSplash);
                it.remove();
            }
            Collections.sort(this.translucent, Collections.reverseOrder(new Comparator<OceanSplashParticle>(){

                @Override
                public int compare(OceanSplashParticle o1, OceanSplashParticle o2) {
                    return Double.compare(MixinParticleEngine.this.distanceToCameraNearPlaneApprox(o1, camera, renderPercent), MixinParticleEngine.this.distanceToCameraNearPlaneApprox(o2, camera, renderPercent));
                }
            }));
            queue.addAll(this.translucent);
        }
    }

    @Unique
    private double distanceToCameraNearPlaneApprox(OceanSplashParticle particle, class_4184 camera, float renderPercent) {
        Vector3f forward = camera.method_19335();
        class_243 camPos = camera.method_19326();
        return this.distToPlaneApprox(forward.x, forward.y, forward.z, 0.0f, (float)(particle.getX(renderPercent) - camPos.field_1352), (float)(particle.getY(renderPercent) - camPos.field_1351), (float)(particle.getZ(renderPercent) - camPos.field_1350));
    }

    @Unique
    private float distToPlaneApprox(float planeX, float planeY, float planeZ, float offset, float pointX, float pointY, float pointZ) {
        return planeX * pointX + planeY * pointY + planeZ * pointZ + offset;
    }
}

