/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.mixins.ocean;

import net.diebuddies.compat.ValkyrienSkies;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.math.Math;
import net.diebuddies.minecraft.weather.WeatherEffects;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.ocean.EntityOcean;
import net.diebuddies.physics.ocean.OceanWorld;
import net.minecraft.class_1297;
import net.minecraft.class_1690;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_638;
import net.minecraft.class_742;
import org.joml.Vector3d;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1297.class})
public class MixinEntity
implements EntityOcean {
    @Unique
    private double physicsOffset;
    @Unique
    private double physicsOldOffset;
    @Unique
    private double physicsRoll;
    @Unique
    private double physicsOldRoll;
    @Unique
    private double physicsPitch;
    @Unique
    private double physicsOldPitch;
    @Unique
    private double velocityY;
    @Unique
    private double velocityRoll;
    @Unique
    private double velocityPitch;
    @Unique
    private boolean wasInAir;
    @Unique
    private double rippleTime;
    @Unique
    private boolean wasEyeUnderwater;

    @Inject(at={@At(value="HEAD")}, method={"doWaterSplashEffect"})
    private void physicsmod$doOceanRippleEffect(CallbackInfo info) {
        class_1297 entity = (class_1297)this;
        if (ConfigClient.areOceanPhysicsEnabled() && entity.method_37908() instanceof class_638) {
            if (ConfigClient.oceanRipples) {
                this.spawnSplashRipple(entity);
            }
            this.spawnSplashParticles(entity);
        }
    }

    @Unique
    private void spawnSplashRipple(class_1297 entity) {
        class_243 deltaMovement = entity.method_18798();
        double vy = java.lang.Math.abs(deltaMovement.field_1351);
        if (vy < 0.1) {
            return;
        }
        double speed = Math.remapClamp(vy, 0.1, 2.0, 0.0425, 0.0625);
        int amount = (int)Math.remapClamp(vy, 0.1, 2.0, 120.0, 240.0);
        int lifetime = (int)Math.remapClamp(vy, 0.1, 2.0, 70.0, 80.0);
        float scale = (float)Math.remapClamp(vy, 0.1, 2.0, 0.2, 0.65);
        OceanWorld oceanWorld = PhysicsMod.getInstance(entity.method_37908()).getPhysicsWorld().getOceanWorld();
        oceanWorld.spawnRipple(amount, lifetime, scale, entity.method_23317(), entity.method_23318() + this.getPhysicsYOffset(), entity.method_23321(), speed);
    }

    @Unique
    private void spawnSplashParticles(class_1297 entity) {
        class_243 deltaMovement = entity.method_18798();
        double vy = java.lang.Math.abs(deltaMovement.field_1351);
        if (vy < 0.25) {
            return;
        }
        int splashamount = (int)Math.remapClamp(vy, 0.1, 2.0, 10.0, 75.0);
        double intensity = Math.remapClamp(vy, 0.1, 2.0, 0.075, 0.5);
        float volume = (float)intensity * ConfigClient.oceanSplashVolume;
        float pitch = Math.random() * 0.4f + 0.7f;
        class_1937 level = entity.method_37908();
        level.method_8486(entity.method_23317(), entity.method_23318() + this.getPhysicsYOffset(), entity.method_23321(), WeatherEffects.SPLASH_SOUND_EVENT, class_3419.field_15256, volume, pitch, true);
        if (ConfigClient.oceanParticles) {
            OceanWorld.createWaterSplash(level, entity.method_23317(), entity.method_23318() + this.getPhysicsYOffset(), entity.method_23321(), 0.0, 0.0, 0.0, 0.25, intensity, splashamount);
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"tick"})
    private void physicsmod$spawnMovementRippleEffect(CallbackInfo info) {
        class_1297 entity = (class_1297)this;
        if (ConfigClient.areOceanPhysicsEnabled() && entity.method_37908() instanceof class_638) {
            class_243 movement;
            double speedSquared;
            if (ConfigClient.oceanRipples && this.isCausingRipples(entity) && (speedSquared = (movement = entity.method_18798()).method_37268()) > 0.001) {
                double rippleSpeed = Math.remapClamp(java.lang.Math.sqrt(speedSquared), 0.077, 0.4, 0.0375, 0.0625);
                int lifetime = (int)Math.remapClamp(java.lang.Math.sqrt(speedSquared), 0.077, 0.4, 100.0, 60.0);
                OceanWorld oceanWorld = PhysicsMod.getInstance(entity.method_37908()).getPhysicsWorld().getOceanWorld();
                oceanWorld.spawnAngularRipple(360, lifetime, entity.method_23317(), entity.method_23318(), entity.method_23321(), movement.field_1352, movement.field_1350, java.lang.Math.toRadians(100.0), rippleSpeed, 0.0);
                double perc = 0.5;
                oceanWorld.spawnAngularRipple(360, lifetime, class_3532.method_16436((double)perc, (double)entity.field_6014, (double)entity.method_23317()), class_3532.method_16436((double)perc, (double)entity.field_6036, (double)entity.method_23318()), class_3532.method_16436((double)perc, (double)entity.field_5969, (double)entity.method_23321()), movement.field_1352, movement.field_1350, java.lang.Math.toRadians(100.0), rippleSpeed, 0.0);
            }
            if (this.isCausingSplash(entity)) {
                if (ConfigClient.oceanRipples) {
                    this.spawnSplashRipple(entity);
                }
                this.spawnSplashParticles(entity);
            }
        }
    }

    @Unique
    private boolean isCausingSplash(class_1297 entity) {
        boolean isEyeUnderwater = entity.method_5777(class_3486.field_15517);
        boolean result = !isEyeUnderwater && this.wasEyeUnderwater;
        this.wasEyeUnderwater = isEyeUnderwater;
        return result;
    }

    @Unique
    private boolean isCausingRipples(class_1297 entity) {
        boolean isOnSurface = true;
        if (!ConfigClient.oceanStickyEntities && entity instanceof class_1690) {
            isOnSurface = !((EntityOcean)entity).isInPhysicsAir();
        }
        return isOnSurface && !entity.method_7325() && entity.method_5799() && (entity.method_37908().method_8320(entity.method_24515().method_10084()).method_26215() || entity instanceof class_742 && entity.method_37908().method_8320(entity.method_24515().method_10084().method_10084()).method_26215());
    }

    @Inject(at={@At(value="TAIL")}, method={"tick"})
    private void physicsmod$updateOceanTransformations(CallbackInfo info) {
        class_1297 entity = (class_1297)this;
        if (ConfigClient.areOceanPhysicsEnabled() && entity.method_37908() instanceof class_638) {
            double gravityThreshold;
            OceanWorld oceanWorld = PhysicsMod.getInstance(entity.method_37908()).getPhysicsWorld().getOceanWorld();
            this.physicsOldOffset = this.physicsOffset;
            this.physicsOldRoll = this.physicsRoll;
            this.physicsOldPitch = this.physicsPitch;
            double targetOffset = oceanWorld.computeYOffset(entity.method_37908(), entity);
            boolean inAir = false;
            double threshold = 0.5;
            double absDistance = java.lang.Math.abs(targetOffset - this.physicsOffset);
            double dynamicDamping = 1.0;
            if (absDistance < threshold) {
                dynamicDamping = Math.remap(absDistance / threshold, 0.0, 1.0, 0.0, 1.0);
            }
            if (targetOffset - (gravityThreshold = 0.0) >= this.physicsOffset) {
                this.velocityY += 0.24100000000000002 * dynamicDamping;
                this.velocityY *= 0.6;
            } else if (targetOffset + gravityThreshold < this.physicsOffset) {
                this.velocityY += -0.040999999999999995 * dynamicDamping;
                this.velocityY *= 0.95;
            } else {
                this.velocityY *= 0.8;
            }
            if (this.physicsOffset - targetOffset > 0.075) {
                inAir = true;
            }
            this.physicsOffset += this.velocityY;
            if (ConfigClient.oceanStickyEntities) {
                this.physicsOffset = targetOffset;
            }
            if (entity instanceof class_1690) {
                double wx = entity.method_23317();
                double wy = entity.method_23318();
                double wz = entity.method_23321();
                class_243 forward = entity.method_5828(1.0f);
                double leftX = forward.field_1350;
                double leftZ = -forward.field_1352;
                double leftHeight = oceanWorld.calculateYOffset(wx + leftX, wy, wz + leftZ);
                double rightHeight = oceanWorld.calculateYOffset(wx - leftX, wy, wz - leftZ);
                double forwardHeight = oceanWorld.calculateYOffset(wx + forward.field_1352, wy, wz + forward.field_1350);
                double backwardsHeight = oceanWorld.calculateYOffset(wx - forward.field_1352, wy, wz - forward.field_1350);
                double targetRoll = java.lang.Math.atan2(rightHeight - leftHeight, 2.0);
                double targetPitch = java.lang.Math.atan2(backwardsHeight - forwardHeight, 2.0);
                double dampingAdjusterRoll = 1.0 - java.lang.Math.pow(java.lang.Math.min(1.0, java.lang.Math.abs(this.physicsRoll) / java.lang.Math.toRadians(130.0)), 3.0);
                double dampingAdjusterPitch = 1.0 - java.lang.Math.pow(java.lang.Math.min(1.0, java.lang.Math.abs(this.physicsPitch) / java.lang.Math.toRadians(130.0)), 3.0);
                if (inAir) {
                    this.velocityRoll *= 0.95 * dampingAdjusterRoll;
                    this.velocityPitch *= 0.95 * dampingAdjusterPitch;
                } else {
                    this.velocityRoll += (targetRoll - this.physicsOldRoll) * 0.2;
                    this.velocityPitch += (targetPitch - this.physicsOldPitch) * 0.2;
                    this.velocityRoll *= 0.6 * dampingAdjusterRoll;
                    this.velocityPitch *= 0.6 * dampingAdjusterPitch;
                }
                this.physicsRoll += this.velocityRoll;
                this.physicsPitch += this.velocityPitch;
                if (this.wasInAir != inAir && this.velocityY < -0.11 && !ConfigClient.oceanStickyEntities) {
                    class_243 movement = entity.method_18798();
                    int amount = (int)Math.remapClamp(this.velocityY, -0.11, -0.25, 75.0, 150.0);
                    double intensity = Math.remapClamp(this.velocityY, -0.11, -0.25, 0.5, 1.0);
                    float volume = (float)intensity * 0.8f * ConfigClient.oceanSplashVolume;
                    float pitch = Math.random() * 0.3f + 0.8f;
                    entity.method_37908().method_8486(wx, wy + this.physicsOffset, wz, WeatherEffects.SPLASH_SOUND_EVENT, class_3419.field_15256, volume, pitch, true);
                    if (ConfigClient.oceanParticles) {
                        OceanWorld.createWaterSplash(entity.method_37908(), entity.method_23317(), entity.method_23318() + targetOffset, entity.method_23321(), movement.field_1352 * 0.4, 0.0, movement.field_1350 * 0.4, 1.0, intensity, amount);
                    }
                }
                if (ConfigClient.oceanStickyEntities) {
                    this.physicsRoll = targetRoll;
                    this.physicsPitch = targetPitch;
                }
            }
            this.wasInAir = ConfigClient.oceanStickyEntities ? false : inAir;
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"pick"}, cancellable=true)
    private void physicsmod$modifyBlockPickingForOceanTransformations(double range, float renderPercent, boolean bl, CallbackInfoReturnable<class_239> info) {
        class_1297 entity = (class_1297)this;
        if (ConfigClient.areOceanPhysicsEnabled() && entity.method_37908() instanceof class_638 && ConfigClient.oceanAdjustHitbox) {
            OceanWorld oceanWorld = PhysicsMod.getInstance(entity.method_37908()).getPhysicsWorld().getOceanWorld();
            double xOffset = 0.0;
            double zOffset = 0.0;
            double yOffset = oceanWorld.computeYOffset(entity.method_37908(), entity, renderPercent);
            if (StarterClient.valkyrienSkies && entity.method_5854() == null && ValkyrienSkies.hasShipMount(entity) != null) {
                Vector3d offset = ValkyrienSkies.getEntityOffset3D(entity, renderPercent);
                xOffset = offset.x;
                yOffset = offset.y;
                zOffset = offset.z;
            }
            class_243 oldEyePos = entity.method_5836(renderPercent);
            class_243 eyePos = new class_243(oldEyePos.field_1352 + xOffset, oldEyePos.field_1351 + yOffset, oldEyePos.field_1350 + zOffset);
            class_243 viewDir = entity.method_5828(renderPercent);
            class_243 target = eyePos.method_1031(viewDir.field_1352 * range, viewDir.field_1351 * range, viewDir.field_1350 * range);
            info.setReturnValue((Object)entity.method_37908().method_17742(new class_3959(eyePos, target, class_3959.class_3960.field_17559, bl ? class_3959.class_242.field_1347 : class_3959.class_242.field_1348, entity)));
        }
    }

    @Override
    public double getPhysicsYOffset(float renderPercent) {
        if (PhysicsMod.hudRendering) {
            return 0.0;
        }
        return class_3532.method_16436((double)renderPercent, (double)this.getPhysicsOldYOffset(), (double)this.getPhysicsYOffset());
    }

    @Override
    public double getPhysicsPitch(float renderPercent) {
        if (PhysicsMod.hudRendering) {
            return 0.0;
        }
        return class_3532.method_16436((double)renderPercent, (double)this.getPhysicsOldPitch(), (double)this.getPhysicsPitch());
    }

    @Override
    public double getPhysicsRoll(float renderPercent) {
        if (PhysicsMod.hudRendering) {
            return 0.0;
        }
        return class_3532.method_16436((double)renderPercent, (double)this.getPhysicsOldRoll(), (double)this.getPhysicsRoll());
    }

    @Override
    public double getPhysicsYOffset() {
        class_1297 entity = (class_1297)this;
        EntityOcean vehicle = (EntityOcean)entity.method_5854();
        if (StarterClient.valkyrienSkies && vehicle == null) {
            vehicle = ValkyrienSkies.hasShipMount(entity);
        }
        if (vehicle != null) {
            return vehicle.getPhysicsYOffset();
        }
        return this.physicsOffset;
    }

    @Override
    public double getPhysicsOldYOffset() {
        class_1297 entity = (class_1297)this;
        EntityOcean vehicle = (EntityOcean)entity.method_5854();
        if (StarterClient.valkyrienSkies && vehicle == null) {
            vehicle = ValkyrienSkies.hasShipMount(entity);
        }
        if (vehicle != null) {
            return vehicle.getPhysicsOldYOffset();
        }
        return this.physicsOldOffset;
    }

    @Override
    public double getPhysicsPitch() {
        class_1297 entity = (class_1297)this;
        EntityOcean vehicle = (EntityOcean)entity.method_5854();
        if (StarterClient.valkyrienSkies && vehicle == null) {
            vehicle = ValkyrienSkies.hasShipMount(entity);
        }
        if (vehicle != null) {
            return vehicle.getPhysicsPitch();
        }
        return this.physicsPitch;
    }

    @Override
    public double getPhysicsOldPitch() {
        class_1297 entity = (class_1297)this;
        EntityOcean vehicle = (EntityOcean)entity.method_5854();
        if (StarterClient.valkyrienSkies && vehicle == null) {
            vehicle = ValkyrienSkies.hasShipMount(entity);
        }
        if (vehicle != null) {
            return vehicle.getPhysicsOldPitch();
        }
        return this.physicsOldPitch;
    }

    @Override
    public double getPhysicsRoll() {
        class_1297 entity = (class_1297)this;
        EntityOcean vehicle = (EntityOcean)entity.method_5854();
        if (StarterClient.valkyrienSkies && vehicle == null) {
            vehicle = ValkyrienSkies.hasShipMount(entity);
        }
        if (vehicle != null) {
            return vehicle.getPhysicsRoll();
        }
        return this.physicsRoll;
    }

    @Override
    public double getPhysicsOldRoll() {
        class_1297 entity = (class_1297)this;
        EntityOcean vehicle = (EntityOcean)entity.method_5854();
        if (StarterClient.valkyrienSkies && vehicle == null) {
            vehicle = ValkyrienSkies.hasShipMount(entity);
        }
        if (vehicle != null) {
            return vehicle.getPhysicsOldRoll();
        }
        return this.physicsOldRoll;
    }

    @Override
    public boolean isInPhysicsAir() {
        return this.wasInAir;
    }
}

