/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.mixins.cloth;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Iterator;
import java.util.Map;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.physics.EntityRenderStateExtended;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.ocean.OceanWorld;
import net.diebuddies.physics.verlet.VerletSimulation;
import net.diebuddies.physics.verlet.constraints.LeashConstraint;
import net.diebuddies.physics.verlet.constraints.WorldConstraint;
import net.diebuddies.util.ObjectPacked;
import net.minecraft.class_10017;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_638;
import net.minecraft.class_765;
import net.minecraft.class_897;
import net.minecraft.class_898;
import net.minecraft.class_9817;
import org.joml.Vector3d;
import org.joml.Vector3fc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_897.class}, priority=900)
public abstract class MixinMobRenderer<T extends class_1297, S extends class_10017> {
    @Shadow
    @Final
    private class_898 field_4676;
    @Unique
    private Map<ObjectPacked, VerletSimulation> simulations = new Object2ObjectOpenHashMap();
    @Unique
    private ObjectPacked tmp = new ObjectPacked(null, null);
    @Unique
    private static double oceanOffset;

    @Inject(at={@At(value="HEAD")}, method={"render"}, cancellable=true)
    private void render(class_10017 entityRenderState, class_4587 poseStack, class_4597 multiBufferSource, int i, CallbackInfo info) {
        class_10017.class_10018 leashState = entityRenderState.field_53324;
        if (leashState != null) {
            class_1297 entity;
            class_1297 mob = ((EntityRenderStateExtended)entityRenderState).getEntity();
            float tickDelta = ((EntityRenderStateExtended)entityRenderState).getTickDelta();
            if (mob instanceof class_9817) {
                class_9817 leashable = (class_9817)mob;
                v0 = leashable.method_60952();
            } else {
                v0 = entity = null;
            }
            if (ConfigClient.areOceanPhysicsEnabled() && !ConfigClient.leashPhysics && entity != null && entity.method_37908() instanceof class_638) {
                OceanWorld oceanWorld = PhysicsMod.getInstance(entity.method_37908()).getPhysicsWorld().getOceanWorld();
                oceanOffset = oceanWorld.computeYOffset(entity.method_37908(), entity, tickDelta) - oceanWorld.computeYOffset(mob.method_37908(), mob, 1.0f);
            }
            if (ConfigClient.leashPhysics && mob.method_5770() instanceof class_638) {
                Iterator<Map.Entry<ObjectPacked, VerletSimulation>> it = this.simulations.entrySet().iterator();
                while (it.hasNext()) {
                    if (!it.next().getValue().destroyed) continue;
                    it.remove();
                }
                this.tmp.e1 = mob;
                this.tmp.e2 = entity;
                VerletSimulation simulation = this.simulations.get(this.tmp);
                class_2338 mob1Pos = class_2338.method_49638((class_2374)mob.method_5836(tickDelta));
                int mob1Brightness = ((class_897)this).method_24087(mob, mob1Pos);
                int mob1BrightnessSky = mob.method_37908().method_8314(class_1944.field_9284, mob1Pos);
                int brightness = class_765.method_23687((int)mob1Brightness, (int)mob1BrightnessSky);
                if (simulation == null) {
                    simulation = new VerletSimulation(new Vector3d((Vector3fc)ConfigClient.getGravity(mob.method_5770().method_27983().method_29177())), 20, 0.855);
                    simulation.addConstraint(new WorldConstraint(mob, 0.25f));
                    simulation.addConstraint(new LeashConstraint(simulation, mob, entity, this.field_4676, tickDelta));
                    simulation.brightness = brightness;
                    simulation.textureID = PhysicsMod.whiteTexture.getID();
                    simulation.alwaysFetchInstantly = false;
                    this.simulations.put(new ObjectPacked(mob, entity), simulation);
                    PhysicsMod.getInstance((class_1937)mob.method_5770()).physicsWorld.addVerletSimulation(simulation);
                } else if (!simulation.destroyed) {
                    simulation.active = true;
                    simulation.brightness = brightness;
                }
                if (StarterClient.optifabric) {
                    PhysicsMod.optifineClothCompat.add(simulation);
                } else {
                    simulation.renderSlow(mob.method_5770());
                }
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"renderLeash"}, cancellable=true)
    private static void renderLeash(class_4587 poseStack, class_4597 multiBufferSource, class_10017.class_10018 leashState, CallbackInfo info) {
        if (ConfigClient.leashPhysics) {
            info.cancel();
        }
    }

    @ModifyVariable(at=@At(value="HEAD"), method={"addVertexPair"}, ordinal=1)
    private static float addVertexPair(float y) {
        return y + (float)oceanOffset;
    }
}

