/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.mixins.cloth;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Iterator;
import java.util.Map;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.physics.EntityRenderStateExtended;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.ocean.OceanWorld;
import net.diebuddies.physics.verlet.VerletSimulation;
import net.diebuddies.physics.verlet.constraints.FishingHookConstraint;
import net.diebuddies.physics.verlet.constraints.WorldConstraint;
import net.minecraft.class_10026;
import net.minecraft.class_1297;
import net.minecraft.class_1536;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_638;
import net.minecraft.class_897;
import net.minecraft.class_906;
import org.joml.Vector3d;
import org.joml.Vector3fc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_906.class})
public abstract class MixinFishingHookRenderer
extends class_897<class_1536, class_10026> {
    @Unique
    private Map<class_1536, VerletSimulation> simulations = new Object2ObjectOpenHashMap();
    @Unique
    private static double oceanOffset;

    protected MixinFishingHookRenderer(class_5617.class_5618 context) {
        super(context);
    }

    @Inject(at={@At(value="HEAD")}, method={"render"})
    public void render(class_10026 fishingHookRenderState, class_4587 poseStack, class_4597 multiBufferSource, int light, CallbackInfo info) {
        class_1536 fishingHook = (class_1536)((EntityRenderStateExtended)fishingHookRenderState).getEntity();
        float tickDelta = ((EntityRenderStateExtended)fishingHookRenderState).getTickDelta();
        if (ConfigClient.areOceanPhysicsEnabled() && !ConfigClient.fishingRodPhysics) {
            class_1657 player = fishingHook.method_6947();
            if (player != null && player.method_37908() instanceof class_638) {
                OceanWorld oceanWorld = PhysicsMod.getInstance(player.method_37908()).getPhysicsWorld().getOceanWorld();
                oceanOffset = oceanWorld.computeYOffset(player.method_37908(), (class_1297)player, tickDelta) - oceanWorld.computeYOffset(fishingHook.method_37908(), (class_1297)fishingHook, 1.0f);
            }
        } else {
            oceanOffset = 0.0;
        }
        if (ConfigClient.fishingRodPhysics) {
            Iterator<Map.Entry<class_1536, VerletSimulation>> it = this.simulations.entrySet().iterator();
            while (it.hasNext()) {
                if (!it.next().getValue().destroyed) continue;
                it.remove();
            }
            VerletSimulation simulation = this.simulations.get(fishingHook);
            class_1657 player = fishingHook.method_6947();
            if (player != null && player.method_37908() instanceof class_638) {
                if (simulation == null) {
                    simulation = new VerletSimulation(new Vector3d((Vector3fc)ConfigClient.getGravity(fishingHook.method_5770().method_27983().method_29177())), 20, 0.855);
                    simulation.addConstraint(new WorldConstraint((class_1297)fishingHook, 0.0f));
                    simulation.addConstraint(new FishingHookConstraint(simulation, fishingHook, player, this.field_4676, tickDelta));
                    simulation.brightness = light;
                    simulation.textureID = PhysicsMod.whiteTexture.getID();
                    simulation.alwaysFetchInstantly = false;
                    this.simulations.put(fishingHook, simulation);
                    PhysicsMod.getInstance((class_1937)fishingHook.method_5770()).physicsWorld.addVerletSimulation(simulation);
                } else if (!simulation.destroyed) {
                    simulation.active = true;
                    simulation.brightness = light;
                }
                if (StarterClient.optifabric) {
                    PhysicsMod.optifineClothCompat.add(simulation);
                } else {
                    simulation.renderSlow(fishingHook.method_5770());
                }
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"stringVertex"}, cancellable=true)
    private static void stringVertex(float x, float y, float z, class_4588 vertexConsumer, class_4587.class_4665 pose, float startPerc, float endPerc, CallbackInfo info) {
        if (ConfigClient.fishingRodPhysics) {
            info.cancel();
        }
    }

    @ModifyVariable(at=@At(value="HEAD"), method={"stringVertex"}, ordinal=1)
    private static float stringVertex(float y) {
        return y + (float)oceanOffset;
    }
}

