/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.mixins.cloth;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Iterator;
import java.util.Map;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.verlet.VerletSimulation;
import net.diebuddies.physics.verlet.constraints.BannerConstraint;
import net.diebuddies.physics.verlet.constraints.ClosestPlayerConstraint;
import net.diebuddies.physics.verlet.constraints.WindConstraint;
import net.diebuddies.physics.verlet.constraints.WorldConstraint;
import net.minecraft.class_10377;
import net.minecraft.class_10378;
import net.minecraft.class_1088;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2215;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2546;
import net.minecraft.class_2573;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_638;
import net.minecraft.class_7718;
import net.minecraft.class_7833;
import net.minecraft.class_823;
import net.minecraft.class_9307;
import org.joml.Vector3d;
import org.joml.Vector3fc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_823.class})
public abstract class MixinBannerRenderer {
    @Shadow
    @Final
    private class_10378 field_55154;
    @Shadow
    @Final
    private class_10378 field_55155;
    @Shadow
    @Final
    private class_10377 field_55156;
    @Shadow
    @Final
    private class_10377 field_55157;
    @Unique
    private Map<class_2573, VerletSimulation> simulations = new Object2ObjectOpenHashMap();

    @Inject(at={@At(value="HEAD")}, method={"render"}, cancellable=true)
    public void render(class_2573 bannerBlockEntity, float tickDelta, class_4587 poseStack, class_4597 multiBufferSource, int brightness, int j, CallbackInfo info) {
        if (ConfigClient.bannerPhysics) {
            boolean guiRendering;
            class_9307 list = bannerBlockEntity.method_58122();
            boolean bl = guiRendering = bannerBlockEntity.method_10997() == null;
            if (list != null && !guiRendering && bannerBlockEntity.method_10997() instanceof class_638) {
                class_2338 blockPos = bannerBlockEntity.method_11016();
                boolean isPlayerInSight = false;
                if (class_310.method_1551().field_1724 != null) {
                    boolean bl2 = isPlayerInSight = class_310.method_1551().field_1724.method_24515().method_10262((class_2382)blockPos) < ConfigClient.bannerPhysicsRange * ConfigClient.bannerPhysicsRange;
                }
                if (isPlayerInSight) {
                    class_10377 bannerFlagModel;
                    class_10378 bannerModel;
                    float rotation;
                    class_2680 blockState = bannerBlockEntity.method_11010();
                    if (blockState.method_26204() instanceof class_2215) {
                        rotation = -class_7718.method_45482((int)((Integer)blockState.method_11654((class_2769)class_2215.field_9924)));
                        bannerModel = this.field_55154;
                        bannerFlagModel = this.field_55156;
                    } else {
                        rotation = -((class_2350)blockState.method_11654((class_2769)class_2546.field_11722)).method_10144();
                        bannerModel = this.field_55155;
                        bannerFlagModel = this.field_55157;
                    }
                    long l = bannerBlockEntity.method_10997().method_8510();
                    float timeOffset = ((float)Math.floorMod((long)(blockPos.method_10263() * 7 + blockPos.method_10264() * 9 + blockPos.method_10260() * 13) + l, 100L) + tickDelta) / 100.0f;
                    poseStack.method_22903();
                    poseStack.method_46416(0.5f, 0.0f, 0.5f);
                    poseStack.method_22907(class_7833.field_40716.rotationDegrees(rotation));
                    poseStack.method_22905(0.6666667f, -0.6666667f, -0.6666667f);
                    bannerModel.method_60879(poseStack, class_1088.field_20847.method_24145(multiBufferSource, class_1921::method_23572), brightness, j);
                    bannerFlagModel.method_65188(timeOffset);
                    class_1937 level = bannerBlockEntity.method_10997();
                    Iterator<Map.Entry<class_2573, VerletSimulation>> it = this.simulations.entrySet().iterator();
                    while (it.hasNext()) {
                        if (!it.next().getValue().destroyed) continue;
                        it.remove();
                    }
                    VerletSimulation simulation = this.simulations.get(bannerBlockEntity);
                    PhysicsMod mod = PhysicsMod.getInstance(level);
                    if (simulation == null) {
                        simulation = new VerletSimulation(new Vector3d((Vector3fc)ConfigClient.getGravity(bannerBlockEntity.method_10997().method_27983().method_29177())), 25, 0.93);
                        simulation.addConstraint(new WorldConstraint(bannerBlockEntity.method_10997(), 1.0f));
                        simulation.addConstraint(new ClosestPlayerConstraint(bannerBlockEntity.method_10997()));
                        simulation.addConstraint(new BannerConstraint(simulation, bannerBlockEntity, bannerModel, tickDelta));
                        simulation.addConstraint(new WindConstraint());
                        simulation.brightness = brightness;
                        simulation.textureID = PhysicsMod.whiteTexture.getID();
                        simulation.alwaysFetchInstantly = false;
                        this.simulations.put(bannerBlockEntity, simulation);
                        mod.physicsWorld.addVerletSimulation(simulation);
                    } else if (!simulation.destroyed) {
                        simulation.active = true;
                        simulation.brightness = brightness;
                    }
                    if (StarterClient.optifabric) {
                        PhysicsMod.optifineClothCompat.add(simulation);
                    } else {
                        simulation.renderSlow(level);
                    }
                    poseStack.method_22909();
                    info.cancel();
                }
            }
        }
    }
}

