/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.bridge;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.nio.file.Path;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.Version;
import net.diebuddies.physics.liquid.CudaWaterController;
import net.diebuddies.physics.liquid.LiquidCuda;
import net.diebuddies.util.clientcommands.CBlockPosArgumentType;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7157;

public class ModLoaderFunctions {
    public static Version getModID() {
        for (ModContainer container : FabricLoader.getInstance().getAllMods()) {
            ModMetadata mod = container.getMetadata();
            if (!mod.getId().equalsIgnoreCase("physicsmod")) continue;
            return new Version(mod.getVersion().getFriendlyString());
        }
        return null;
    }

    public static boolean isModLoaded(String modID) {
        return FabricLoader.getInstance().isModLoaded(modID);
    }

    public static boolean isModVersionOrNewer(String modID, String version) {
        try {
            return net.fabricmc.loader.api.Version.parse((String)version).compareTo((Object)((ModContainer)FabricLoader.getInstance().getModContainer(modID).get()).getMetadata().getVersion()) <= 0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static Path getGameDir() {
        return FabricLoader.getInstance().getGameDir();
    }

    public static String getModloader() {
        return "fabric";
    }

    public static void registerResourcePack(String namespace, String packname) {
        FabricLoader.getInstance().getModContainer("physicsmod").ifPresent(modContainer -> ResourceManagerHelper.registerBuiltinResourcePack((class_2960)class_2960.method_60655((String)namespace, (String)packname), (ModContainer)modContainer, (ResourcePackActivationType)ResourcePackActivationType.ALWAYS_ENABLED));
    }

    public static void registerLiquidCommands() {
        ClientCommandRegistrationCallback.EVENT.register((Object)new ClientCommandRegistrationCallback(){

            public void register(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 registryAccess) {
                LiteralArgumentBuilder liquids = ClientCommandManager.literal((String)"liquids");
                dispatcher.register((LiteralArgumentBuilder)liquids.then(ClientCommandManager.literal((String)"help").executes(context -> {
                    ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Spawning liquids:"));
                    ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"/liquids box <position> <box width> <box height> <box depth>"));
                    ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"/liquids sphere <position> <sphere radius>"));
                    ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Removing liquids:"));
                    ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"/liquids clear"));
                    return 1;
                })));
                dispatcher.register((LiteralArgumentBuilder)liquids.then(ClientCommandManager.literal((String)"box").then(ClientCommandManager.argument((String)"location", (ArgumentType)CBlockPosArgumentType.blockPos()).then(ClientCommandManager.argument((String)"width", (ArgumentType)DoubleArgumentType.doubleArg((double)0.5, (double)50.0)).then(ClientCommandManager.argument((String)"height", (ArgumentType)DoubleArgumentType.doubleArg((double)0.5, (double)50.0)).then(ClientCommandManager.argument((String)"depth", (ArgumentType)DoubleArgumentType.doubleArg((double)0.5, (double)50.0)).executes(context -> {
                    if (!ConfigClient.cudaLiquids()) {
                        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"You need to enable GPU liquids first!"));
                    } else {
                        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("Spawned liquid at " + String.valueOf(CBlockPosArgumentType.getCBlockPos((CommandContext<FabricClientCommandSource>)context, "location")))));
                        PhysicsMod mod = PhysicsMod.getInstance((class_1937)((FabricClientCommandSource)context.getSource()).getWorld());
                        mod.getPhysicsWorld().addLiquid(new LiquidCuda(new CudaWaterController(CBlockPosArgumentType.getCBlockPos((CommandContext<FabricClientCommandSource>)context, "location"), DoubleArgumentType.getDouble((CommandContext)context, (String)"width"), DoubleArgumentType.getDouble((CommandContext)context, (String)"height"), DoubleArgumentType.getDouble((CommandContext)context, (String)"depth"))));
                    }
                    return 1;
                })))))));
                dispatcher.register((LiteralArgumentBuilder)liquids.then(ClientCommandManager.literal((String)"sphere").then(ClientCommandManager.argument((String)"location", (ArgumentType)CBlockPosArgumentType.blockPos()).then(ClientCommandManager.argument((String)"radius", (ArgumentType)DoubleArgumentType.doubleArg((double)0.5, (double)50.0)).executes(context -> {
                    if (!ConfigClient.cudaLiquids()) {
                        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"You need to enable GPU liquids first!"));
                    } else {
                        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("Spawned liquid at " + String.valueOf(CBlockPosArgumentType.getCBlockPos((CommandContext<FabricClientCommandSource>)context, "location")))));
                        PhysicsMod mod = PhysicsMod.getInstance((class_1937)((FabricClientCommandSource)context.getSource()).getWorld());
                        mod.getPhysicsWorld().addLiquid(new LiquidCuda(new CudaWaterController(CBlockPosArgumentType.getCBlockPos((CommandContext<FabricClientCommandSource>)context, "location"), DoubleArgumentType.getDouble((CommandContext)context, (String)"radius"))));
                    }
                    return 1;
                })))));
                dispatcher.register((LiteralArgumentBuilder)liquids.then(ClientCommandManager.literal((String)"clear").executes(context -> {
                    ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Removed all liquids"));
                    PhysicsMod mod = PhysicsMod.getInstance((class_1937)((FabricClientCommandSource)context.getSource()).getWorld());
                    mod.getPhysicsWorld().clearLiquids();
                    return 1;
                })));
            }
        });
    }
}

