/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.dynamicresources;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.fabric.api.client.model.loading.v1.BlockStateResolver;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelModifier;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1087;
import net.minecraft.class_1091;
import net.minecraft.class_1100;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3665;
import net.minecraft.class_773;
import net.minecraft.class_7775;
import net.minecraft.class_9979;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.dynamicresources.DynamicModelProvider;

public class FabricDynamicModelHandler
implements DynamicModelProvider.DynamicModelPlugin {
    private final List<ModelLoadingPlugin> pluginList;
    private static final class_2960[] MODEL_MODIFIER_PHASES = new class_2960[]{ModelModifier.OVERRIDE_PHASE, ModelModifier.DEFAULT_PHASE, ModelModifier.WRAP_PHASE, ModelModifier.WRAP_LAST_PHASE};
    private final Event<ModelModifier.OnLoad> onLoadModifiers = EventFactory.createWithPhases(ModelModifier.OnLoad.class, modifiers -> (model, context) -> {
        for (ModelModifier.OnLoad modifier : modifiers) {
            try {
                model = modifier.modifyModelOnLoad(model, context);
            }
            catch (Exception exception) {
                ModernFix.LOGGER.error("Failed to modify unbaked model on load", (Throwable)exception);
            }
        }
        return model;
    }, (class_2960[])MODEL_MODIFIER_PHASES);
    private final Event<ModelModifier.OnLoadBlock> onLoadBlockModifiers = EventFactory.createWithPhases(ModelModifier.OnLoadBlock.class, modifiers -> (model, context) -> {
        for (ModelModifier.OnLoadBlock modifier : modifiers) {
            try {
                model = modifier.modifyModelOnLoad(model, context);
            }
            catch (Exception exception) {
                ModernFix.LOGGER.error("Failed to modify unbaked block model on load", (Throwable)exception);
            }
        }
        return model;
    }, (class_2960[])MODEL_MODIFIER_PHASES);
    private final Event<ModelModifier.BeforeBakeBlock> beforeBakeBlockModifiers = EventFactory.createWithPhases(ModelModifier.BeforeBakeBlock.class, modifiers -> (model, context) -> {
        for (ModelModifier.BeforeBakeBlock modifier : modifiers) {
            try {
                model = modifier.modifyModelBeforeBake(model, context);
            }
            catch (Exception exception) {
                ModernFix.LOGGER.error("Failed to modify unbaked block model before bake", (Throwable)exception);
            }
        }
        return model;
    }, (class_2960[])MODEL_MODIFIER_PHASES);
    private final Event<ModelModifier.AfterBakeBlock> afterBakeBlockModifiers = EventFactory.createWithPhases(ModelModifier.AfterBakeBlock.class, modifiers -> (model, context) -> {
        for (ModelModifier.AfterBakeBlock modifier : modifiers) {
            try {
                model = modifier.modifyModelAfterBake(model, context);
            }
            catch (Exception exception) {
                ModernFix.LOGGER.error("Failed to modify baked block model after bake", (Throwable)exception);
            }
        }
        return model;
    }, (class_2960[])MODEL_MODIFIER_PHASES);
    private final Event<ModelModifier.BeforeBake> beforeBakeModifiers = EventFactory.createWithPhases(ModelModifier.BeforeBake.class, modifiers -> (model, context) -> {
        for (ModelModifier.BeforeBake modifier : modifiers) {
            try {
                model = modifier.modifyModelBeforeBake(model, context);
            }
            catch (Exception exception) {
                ModernFix.LOGGER.error("Failed to modify unbaked model before bake", (Throwable)exception);
            }
        }
        return model;
    }, (class_2960[])MODEL_MODIFIER_PHASES);
    private final Event<ModelModifier.AfterBake> afterBakeModifiers = EventFactory.createWithPhases(ModelModifier.AfterBake.class, modifiers -> (model, context) -> {
        for (ModelModifier.AfterBake modifier : modifiers) {
            try {
                model = modifier.modifyModelAfterBake(model, context);
            }
            catch (Exception exception) {
                ModernFix.LOGGER.error("Failed to modify baked model after bake", (Throwable)exception);
            }
        }
        return model;
    }, (class_2960[])MODEL_MODIFIER_PHASES);

    public FabricDynamicModelHandler(DynamicModelProvider provider) {
        this.pluginList = ModelLoadingPlugin.getAll();
        PluginContext context = new PluginContext(provider);
        for (ModelLoadingPlugin plugin : this.pluginList) {
            plugin.initialize((ModelLoadingPlugin.Context)context);
        }
        context.fireResolvers();
    }

    @Override
    public Optional<class_1100> modifyModelOnLoad(Optional<class_1100> model, class_2960 id) {
        return Optional.ofNullable(((ModelModifier.OnLoad)this.onLoadModifiers.invoker()).modifyModelOnLoad((class_1100)model.orElse(null), () -> id));
    }

    @Override
    public class_9979 modifyBlockModelOnLoad(class_9979 model, final class_1091 id, final class_2680 state) {
        return ((ModelModifier.OnLoadBlock)this.onLoadBlockModifiers.invoker()).modifyModelOnLoad(model, new ModelModifier.OnLoadBlock.Context(){

            public class_1091 id() {
                return id;
            }

            public class_2680 state() {
                return state;
            }
        });
    }

    @Override
    public class_1100 modifyModelBeforeBake(class_1100 model, final class_2960 id, final class_3665 state, final class_7775 baker) {
        return ((ModelModifier.BeforeBake)this.beforeBakeModifiers.invoker()).modifyModelBeforeBake(model, new ModelModifier.BeforeBake.Context(){

            public class_2960 id() {
                return id;
            }

            public class_3665 settings() {
                return state;
            }

            public class_7775 baker() {
                return baker;
            }
        });
    }

    @Override
    public class_1087 modifyModelAfterBake(class_1087 bakedModel, final class_1100 model, final class_2960 id, final class_3665 state, final class_7775 baker) {
        return ((ModelModifier.AfterBake)this.afterBakeModifiers.invoker()).modifyModelAfterBake(bakedModel, new ModelModifier.AfterBake.Context(){

            public class_2960 id() {
                return id;
            }

            public class_1100 sourceModel() {
                return model;
            }

            public class_3665 settings() {
                return state;
            }

            public class_7775 baker() {
                return baker;
            }
        });
    }

    @Override
    public class_9979 modifyBlockModelBeforeBake(class_9979 model, final class_1091 id, final class_7775 baker) {
        return ((ModelModifier.BeforeBakeBlock)this.beforeBakeBlockModifiers.invoker()).modifyModelBeforeBake(model, new ModelModifier.BeforeBakeBlock.Context(){

            public class_1091 id() {
                return id;
            }

            public class_7775 baker() {
                return baker;
            }
        });
    }

    @Override
    public class_1087 modifyBlockModelAfterBake(class_1087 bakedModel, final class_9979 model, final class_1091 id, final class_7775 baker) {
        return ((ModelModifier.AfterBakeBlock)this.afterBakeBlockModifiers.invoker()).modifyModelAfterBake(bakedModel, new ModelModifier.AfterBakeBlock.Context(){

            public class_1091 id() {
                return id;
            }

            public class_9979 sourceModel() {
                return model;
            }

            public class_7775 baker() {
                return baker;
            }
        });
    }

    private class PluginContext
    implements ModelLoadingPlugin.Context {
        private final DynamicModelProvider provider;
        private final Map<class_2248, BlockStateResolver> resolvers = new HashMap<class_2248, BlockStateResolver>();

        private PluginContext(DynamicModelProvider provider) {
            this.provider = provider;
        }

        public void addModels(class_2960 ... ids) {
        }

        public void addModels(Collection<? extends class_2960> ids) {
        }

        public void registerBlockStateResolver(class_2248 block, BlockStateResolver resolver) {
            this.resolvers.put(block, resolver);
        }

        public void fireResolvers() {
            this.resolvers.forEach((block, resolver) -> resolver.resolveBlockStates(new BlockStateResolver.Context(){
                final /* synthetic */ class_2248 val$block;
                {
                    this.val$block = class_22482;
                }

                public class_2248 block() {
                    return this.val$block;
                }

                public void setModel(class_2680 state, class_9979 model) {
                    PluginContext.this.provider.addUnbakedBlockStateOverride(class_773.method_3340((class_2680)state), model);
                }
            }));
        }

        public Event<ModelModifier.OnLoad> modifyModelOnLoad() {
            return FabricDynamicModelHandler.this.onLoadModifiers;
        }

        public Event<ModelModifier.OnLoadBlock> modifyBlockModelOnLoad() {
            return FabricDynamicModelHandler.this.onLoadBlockModifiers;
        }

        public Event<ModelModifier.BeforeBake> modifyModelBeforeBake() {
            return FabricDynamicModelHandler.this.beforeBakeModifiers;
        }

        public Event<ModelModifier.AfterBake> modifyModelAfterBake() {
            return FabricDynamicModelHandler.this.afterBakeModifiers;
        }

        public Event<ModelModifier.BeforeBakeBlock> modifyBlockModelBeforeBake() {
            return FabricDynamicModelHandler.this.beforeBakeBlockModifiers;
        }

        public Event<ModelModifier.AfterBakeBlock> modifyBlockModelAfterBake() {
            return FabricDynamicModelHandler.this.afterBakeBlockModifiers;
        }
    }
}

