/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.dynamicresources;

import com.google.common.base.Suppliers;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.BufferedReader;
import java.io.Reader;
import java.lang.ref.WeakReference;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_10096;
import net.minecraft.class_10434;
import net.minecraft.class_10439;
import net.minecraft.class_10447;
import net.minecraft.class_10525;
import net.minecraft.class_10526;
import net.minecraft.class_10527;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1086;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_1091;
import net.minecraft.class_1100;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3665;
import net.minecraft.class_4724;
import net.minecraft.class_4730;
import net.minecraft.class_5321;
import net.minecraft.class_5599;
import net.minecraft.class_773;
import net.minecraft.class_7775;
import net.minecraft.class_790;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import net.minecraft.class_793;
import net.minecraft.class_801;
import net.minecraft.class_9824;
import net.minecraft.class_9979;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.dynamicresources.FabricDynamicModelHandler;
import org.jetbrains.annotations.NotNull;

public class DynamicModelProvider {
    private final LoadingCache<class_2960, Optional<class_9824.class_10095>> loadedStateDefinitions = this.makeLoadingCache(this::loadBlockStateDefinition);
    private final LoadingCache<class_2960, Optional<class_1100>> loadedBlockModels = this.makeLoadingCache(this::loadBlockModel);
    private final LoadingCache<class_1091, Optional<class_1087>> loadedBakedModels = this.makeLoadingCache(this::loadBakedModel);
    private final LoadingCache<class_2960, Optional<class_10434>> loadedClientItemProperties = this.makeLoadingCache(this::loadClientItemProperties);
    private final LoadingCache<class_2960, Optional<class_10439>> loadedItemModels = this.makeLoadingCache(this::loadItemModel);
    private final LoadingCache<class_2960, Optional<class_1087>> loadedStandaloneModels = this.makeLoadingCache(this::loadStandaloneModel);
    private final class_1087 missingModel;
    private final class_10439 missingItemModel;
    private final class_1100 unbakedMissingModel;
    private final Function<class_2960, class_2689<class_2248, class_2680>> stateMapper;
    private final class_3300 resourceManager;
    private final class_1088.class_9826 textureGetter;
    private final DynamicResolver resolver;
    private final class_5599 entityModelSet;
    private final class_801 itemModelGenerator;
    private final Map<class_1091, class_1087> mrlModelOverrides = new ConcurrentHashMap<class_1091, class_1087>();
    private final Map<class_2960, class_10439> itemStackModelOverrides = new ConcurrentHashMap<class_2960, class_10439>();
    private final Map<class_2960, class_1087> standaloneModelOverrides = new ConcurrentHashMap<class_2960, class_1087>();
    private final Map<class_1091, class_9979> unbakedBlockStateModelOverrides = new ConcurrentHashMap<class_1091, class_9979>();
    private final List<DynamicModelPlugin> pluginList = new ArrayList<DynamicModelPlugin>();
    private static final boolean DEBUG_DYNAMIC_MODEL_LOADING = Boolean.getBoolean("modernfix.debugDynamicModelLoading");
    private static final Supplier<Set<class_1091>> TOP_LEVEL_LOCATIONS_SUPPLIER = Suppliers.memoizeWithExpiration(() -> {
        HashSet set = new HashSet();
        class_7923.field_41175.method_29722().forEach(entry -> {
            class_2960 location = ((class_5321)entry.getKey()).method_29177();
            for (class_2680 state : ((class_2248)entry.getValue()).method_9595().method_11662()) {
                set.add(class_773.method_3336((class_2960)location, (class_2680)state));
            }
        });
        return Collections.unmodifiableSet(set);
    }, (long)2L, (TimeUnit)TimeUnit.MINUTES);
    public static WeakReference<DynamicModelProvider> currentReloadingModelProvider = new WeakReference<Object>(null);

    public DynamicModelProvider(class_3300 resourceManager, class_5599 entityModelSet, final Map<class_2960, class_4724.class_7774> atlasMap) {
        this.unbakedMissingModel = class_10096.method_62629();
        this.entityModelSet = entityModelSet;
        final class_1058 missing = atlasMap.get(class_1059.field_5275).method_45868();
        this.textureGetter = new class_1088.class_9826(){

            public class_1058 method_65739(class_10525 modelDebugName, class_4730 material) {
                class_4724.class_7774 atlas = (class_4724.class_7774)atlasMap.get(material.method_24144());
                class_1058 sprite = atlas.method_45869(material.method_24147());
                if (sprite != null) {
                    return sprite;
                }
                ModernFix.LOGGER.warn("Unable to find sprite '{}' referenced by model '{}'", (Object)material.method_24147(), modelDebugName.get());
                return missing;
            }

            public class_1058 method_65740(class_10525 modelDebugName, String string) {
                return missing;
            }
        };
        this.stateMapper = class_9824.method_62626();
        this.resourceManager = resourceManager;
        this.resolver = new DynamicResolver();
        this.itemModelGenerator = new class_801();
        this.missingModel = this.bakeMissingModel();
        this.missingItemModel = new class_10447(this.missingModel);
        try {
            Class.forName("net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin");
            this.pluginList.add(new FabricDynamicModelHandler(this));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public class_1087 getMissingBakedModel() {
        return this.missingModel;
    }

    public class_10439 getMissingItemModel() {
        return this.missingItemModel;
    }

    public Map<class_1091, class_1087> getTopLevelEmulatedRegistry() {
        return new EmulatedRegistry<class_1091, class_1087>(class_1091.class, this.loadedBakedModels, TOP_LEVEL_LOCATIONS_SUPPLIER, this.mrlModelOverrides);
    }

    public Map<class_2960, class_1087> getStandaloneEmulatedRegistry() {
        return new EmulatedRegistry<class_2960, class_1087>(class_2960.class, this.loadedStandaloneModels, Set::of, this.standaloneModelOverrides);
    }

    public Map<class_2960, class_10439> getItemModelEmulatedRegistry() {
        return new EmulatedRegistry<class_2960, class_10439>(class_2960.class, this.loadedItemModels, () -> ((class_7922)class_7923.field_41178).method_10235(), this.itemStackModelOverrides);
    }

    public Map<class_2960, class_10434.class_10543> getItemPropertiesEmulatedRegistry() {
        return Maps.transformValues(new EmulatedRegistry<class_2960, class_10434>(class_2960.class, this.loadedClientItemProperties, () -> ((class_7922)class_7923.field_41178).method_10235(), Map.of()), class_10434::comp_3465);
    }

    private <K, V> LoadingCache<K, Optional<V>> makeLoadingCache(final Function<K, Optional<V>> loadingFunction) {
        return CacheBuilder.newBuilder().expireAfterAccess(3L, TimeUnit.MINUTES).maximumSize(1000L).concurrencyLevel(8).softValues().build(new CacheLoader<K, Optional<V>>(this){

            public Optional<V> load(K key) {
                return (Optional)loadingFunction.apply(key);
            }
        });
    }

    private Optional<class_9824.class_10095> loadBlockStateDefinition(class_2960 location) {
        class_2689<class_2248, class_2680> stateDefinition = this.stateMapper.apply(location);
        if (stateDefinition == null) {
            return Optional.empty();
        }
        if (DEBUG_DYNAMIC_MODEL_LOADING) {
            ModernFix.LOGGER.info("Loading blockstate definition '{}'", (Object)location);
        }
        List resources = this.resourceManager.method_14489(class_2960.method_60655((String)location.method_12836(), (String)("blockstates/" + location.method_12832() + ".json")));
        ArrayList<class_9824.class_10094> loadedDefinitions = new ArrayList<class_9824.class_10094>(resources.size());
        for (class_3298 resource : resources) {
            try {
                BufferedReader reader = resource.method_43039();
                try {
                    JsonObject jsonObject = class_3518.method_15255((Reader)reader);
                    class_790 blockModelDefinition = class_790.method_45787((JsonElement)jsonObject);
                    loadedDefinitions.add(new class_9824.class_10094(resource.method_14480(), blockModelDefinition));
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (Exception e) {
                ModernFix.LOGGER.error("Failed to load blockstate definition {} from pack '{}'", (Object)location, (Object)resource.method_14480(), (Object)e);
            }
        }
        HashMap<class_1091, class_9824.class_9825> loadedModels = new HashMap<class_1091, class_9824.class_9825>(class_9824.method_62627((class_2960)location, stateDefinition, loadedDefinitions, (class_1100)this.unbakedMissingModel).comp_3063());
        if (!this.pluginList.isEmpty()) {
            loadedModels.replaceAll((mrl, oldModel) -> {
                class_9979 ubm = oldModel.comp_2871();
                for (DynamicModelPlugin plugin : this.pluginList) {
                    ubm = plugin.modifyBlockModelOnLoad(ubm, (class_1091)mrl, oldModel.comp_3062());
                }
                if (ubm == oldModel.comp_2871()) {
                    return oldModel;
                }
                return new class_9824.class_9825(oldModel.comp_3062(), ubm);
            });
        }
        return Optional.of(new class_9824.class_10095(loadedModels));
    }

    private class_1087 bakeMissingModel() {
        this.resolver.clearResolver();
        this.unbakedMissingModel.method_62326((class_10526.class_10103)this.resolver);
        DynamicBaker modelBaker = new DynamicBaker(() -> "missing");
        return class_1100.method_65765((class_1100)this.unbakedMissingModel, (class_7775)modelBaker, (class_3665)class_1086.field_5350);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private class_1087 bakeModel(class_1100 model, class_2960 location) {
        if (DEBUG_DYNAMIC_MODEL_LOADING) {
            ModernFix.LOGGER.info("Baking model '{}'", (Object)location);
        }
        DynamicModelProvider dynamicModelProvider = this;
        synchronized (dynamicModelProvider) {
            this.resolver.clearResolver();
            model.method_62326((class_10526.class_10103)this.resolver);
            DynamicBaker modelBaker = new DynamicBaker(() -> ((class_2960)location).toString());
            for (DynamicModelPlugin plugin : this.pluginList) {
                model = plugin.modifyModelBeforeBake(model, location, (class_3665)class_1086.field_5350, modelBaker);
            }
            class_1087 bakedModel = class_1100.method_65765((class_1100)model, (class_7775)modelBaker, (class_3665)class_1086.field_5350);
            for (DynamicModelPlugin plugin : this.pluginList) {
                bakedModel = plugin.modifyModelAfterBake(bakedModel, model, location, (class_3665)class_1086.field_5350, modelBaker);
            }
            return bakedModel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private class_1087 bakeModel(class_9979 model, class_1091 mrl) {
        if (DEBUG_DYNAMIC_MODEL_LOADING) {
            ModernFix.LOGGER.info("Baking model '{}'", (Object)mrl);
        }
        DynamicModelProvider dynamicModelProvider = this;
        synchronized (dynamicModelProvider) {
            this.resolver.clearResolver();
            model.method_62326((class_10526.class_10103)this.resolver);
            DynamicBaker modelBaker = new DynamicBaker(() -> ((class_1091)mrl).toString());
            for (DynamicModelPlugin plugin : this.pluginList) {
                model = plugin.modifyBlockModelBeforeBake(model, mrl, modelBaker);
            }
            class_1087 bakedModel = model.method_65542((class_7775)modelBaker);
            for (DynamicModelPlugin plugin : this.pluginList) {
                bakedModel = plugin.modifyBlockModelAfterBake(bakedModel, model, mrl, modelBaker);
            }
            return bakedModel;
        }
    }

    private Optional<class_1087> loadBakedModel(class_1091 location) {
        class_1087 override = this.mrlModelOverrides.get(location);
        if (override != null) {
            return Optional.of(override);
        }
        if (location.comp_2876().equals("standalone") || location.comp_2876().equals("fabric_resource")) {
            return this.loadStandaloneModel(location.comp_2875());
        }
        Optional<class_9979> unbakedModelOpt = Optional.ofNullable(this.unbakedBlockStateModelOverrides.get(location));
        if (unbakedModelOpt.isEmpty()) {
            Optional optLoadedModels = (Optional)this.loadedStateDefinitions.getUnchecked((Object)location.comp_2875());
            unbakedModelOpt = optLoadedModels.map(loadedModels -> {
                class_9824.class_9825 loadedModel = (class_9824.class_9825)loadedModels.comp_3063().get(location);
                if (loadedModel != null) {
                    return loadedModel.comp_2871();
                }
                return null;
            });
        }
        return unbakedModelOpt.map(unbakedModel -> this.bakeModel((class_9979)unbakedModel, location));
    }

    private Optional<class_1087> loadStandaloneModel(class_2960 location) {
        class_1087 override = this.standaloneModelOverrides.get(location);
        if (override != null) {
            return Optional.of(override);
        }
        return ((Optional)this.loadedBlockModels.getUnchecked((Object)location)).map(unbakedModel -> this.bakeModel((class_1100)unbakedModel, location));
    }

    private Optional<class_1100> loadBlockModelDefault(class_2960 location) {
        if (DEBUG_DYNAMIC_MODEL_LOADING) {
            ModernFix.LOGGER.info("Loading block model '{}'", (Object)location);
        }
        if (location.equals((Object)class_801.field_55273)) {
            return Optional.of(this.itemModelGenerator);
        }
        if (location.equals((Object)class_10096.field_53660)) {
            return Optional.of(this.unbakedMissingModel);
        }
        Optional resource = this.resourceManager.method_14486(class_2960.method_60655((String)location.method_12836(), (String)("models/" + location.method_12832() + ".json")));
        if (resource.isPresent()) {
            Optional<class_793> optional;
            block12: {
                BufferedReader reader = ((class_3298)resource.get()).method_43039();
                try {
                    class_793 blockModel = class_793.method_3437((Reader)reader);
                    optional = Optional.of(blockModel);
                    if (reader == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                ((Reader)reader).close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        ModernFix.LOGGER.error("Failed to load block model {} from '{}'", (Object)location, (Object)((class_3298)resource.get()).method_14480(), (Object)e);
                        return Optional.empty();
                    }
                }
                ((Reader)reader).close();
            }
            return optional;
        }
        ModernFix.LOGGER.warn("Model '{}' does not exist in any resource packs", (Object)location);
        return Optional.empty();
    }

    private Optional<class_1100> loadBlockModel(class_2960 location) {
        Optional<class_1100> value = this.loadBlockModelDefault(location);
        for (DynamicModelPlugin plugin : this.pluginList) {
            value = plugin.modifyModelOnLoad(value, location);
        }
        return value;
    }

    private Optional<class_10434> loadClientItemProperties(class_2960 location) {
        Optional resource;
        if (DEBUG_DYNAMIC_MODEL_LOADING) {
            ModernFix.LOGGER.info("Loading client item '{}'", (Object)location);
        }
        if ((resource = this.resourceManager.method_14486(class_2960.method_60655((String)location.method_12836(), (String)("items/" + location.method_12832() + ".json")))).isPresent()) {
            Optional<class_10434> optional;
            block10: {
                BufferedReader reader = ((class_3298)resource.get()).method_43039();
                try {
                    class_10434 clientItem = (class_10434)class_10434.field_55327.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseReader((Reader)reader)).getOrThrow();
                    optional = Optional.of(clientItem);
                    if (reader == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                ((Reader)reader).close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        ModernFix.LOGGER.error("Failed to load client item {} from '{}'", (Object)location, (Object)((class_3298)resource.get()).method_14480(), (Object)e);
                        return Optional.empty();
                    }
                }
                ((Reader)reader).close();
            }
            return optional;
        }
        ModernFix.LOGGER.warn("Client item '{}' does not exist in any resource packs", (Object)location);
        return Optional.empty();
    }

    private Optional<class_10439> loadItemModel(class_2960 location) {
        class_10439 override;
        if (DEBUG_DYNAMIC_MODEL_LOADING) {
            ModernFix.LOGGER.info("Loading item model '{}'", (Object)location);
        }
        if ((override = this.itemStackModelOverrides.get(location)) != null) {
            return Optional.of(override);
        }
        return ((Optional)this.loadedClientItemProperties.getUnchecked((Object)location)).map(clientItem -> {
            class_10439.class_10440 bakingContext = new class_10439.class_10440((class_7775)new DynamicBaker(() -> ((class_2960)location).toString()), this.entityModelSet, this.missingItemModel);
            return clientItem.comp_3385().method_65587(bakingContext);
        });
    }

    public class_1087 getModel(class_1091 location) {
        return ((Optional)this.loadedBakedModels.getUnchecked((Object)location)).orElse(this.missingModel);
    }

    public class_10434.class_10543 getClientItemProperties(class_2960 location) {
        return ((Optional)this.loadedClientItemProperties.getUnchecked((Object)location)).map(class_10434::comp_3465).orElse(class_10434.class_10543.field_55549);
    }

    public class_10439 getItemModel(class_2960 location) {
        return ((Optional)this.loadedItemModels.getUnchecked((Object)location)).orElse(this.missingItemModel);
    }

    public class_1087 getStandaloneModel(class_2960 location) {
        return ((Optional)this.loadedStandaloneModels.getUnchecked((Object)location)).orElse(this.missingModel);
    }

    public void addUnbakedBlockStateOverride(class_1091 location, class_9979 model) {
        this.unbakedBlockStateModelOverrides.put(location, model);
    }

    private class DynamicResolver
    implements class_10526.class_10103 {
        private final Set<class_2960> stack = new ObjectOpenHashSet(4);
        private final Set<class_2960> resolvedModels = new ObjectOpenHashSet();

        private DynamicResolver() {
        }

        public class_1100 method_62642(class_2960 resourceLocation) {
            if (this.stack.contains(resourceLocation)) {
                ModernFix.LOGGER.warn("Detected model loading loop: {}->{}", (Object)this.stacktraceToString(), (Object)resourceLocation);
                return DynamicModelProvider.this.unbakedMissingModel;
            }
            class_1100 unbakedModel = ((Optional)DynamicModelProvider.this.loadedBlockModels.getUnchecked((Object)resourceLocation)).orElse(DynamicModelProvider.this.unbakedMissingModel);
            if (this.resolvedModels.add(resourceLocation)) {
                this.stack.add(resourceLocation);
                unbakedModel.method_62326((class_10526.class_10103)this);
                this.stack.remove(resourceLocation);
            }
            return unbakedModel;
        }

        private String stacktraceToString() {
            return this.stack.stream().map(class_2960::toString).collect(Collectors.joining("->"));
        }

        public void clearResolver() {
            this.stack.clear();
            this.resolvedModels.clear();
        }
    }

    private static class EmulatedRegistry<K, V>
    implements Map<K, V> {
        private final LoadingCache<K, Optional<V>> realCache;
        private final Supplier<Set<K>> keys;
        private final Map<K, V> overrides;
        private final Class<K> keyClass;

        public EmulatedRegistry(Class<K> keyClass, LoadingCache<K, Optional<V>> realCache, Supplier<Set<K>> keys, Map<K, V> overrides) {
            this.keyClass = keyClass;
            this.realCache = realCache;
            this.keys = keys;
            this.overrides = overrides;
        }

        @Override
        public V get(Object key) {
            if (this.keyClass.isAssignableFrom(key.getClass())) {
                return ((Optional)this.realCache.getUnchecked(key)).orElse(null);
            }
            return null;
        }

        @Override
        public V getOrDefault(Object key, V defaultValue) {
            if (this.keyClass.isAssignableFrom(key.getClass())) {
                return ((Optional)this.realCache.getUnchecked(key)).orElse(defaultValue);
            }
            return defaultValue;
        }

        @Override
        public V put(K key, V value) {
            V oldValue = ((Optional)this.realCache.getUnchecked(key)).orElse(null);
            this.overrides.put(key, value);
            this.realCache.invalidate(key);
            return oldValue;
        }

        @Override
        public V remove(Object key) {
            this.overrides.remove(key);
            this.realCache.invalidate(key);
            return null;
        }

        @Override
        public void putAll(@NotNull Map<? extends K, ? extends V> m) {
            m.forEach(this::put);
        }

        @Override
        public void clear() {
            this.overrides.clear();
            this.realCache.invalidateAll();
        }

        @Override
        @NotNull
        public Set<K> keySet() {
            return this.keys.get();
        }

        @Override
        @NotNull
        public Collection<V> values() {
            return Collections.emptyList();
        }

        @Override
        public int size() {
            return this.keys.get().size();
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean containsKey(Object key) {
            return this.keys.get().contains(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return false;
        }

        @Override
        @NotNull
        public Set<Map.Entry<K, V>> entrySet() {
            return new AbstractSet<Map.Entry<K, V>>(){

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return Iterators.transform(keys.get().iterator(), key -> new Map.Entry<K, V>(){

                        @Override
                        public K getKey() {
                            return key;
                        }

                        @Override
                        public V getValue() {
                            return this.get(key);
                        }

                        @Override
                        public V setValue(V value) {
                            return this.put(key, value);
                        }
                    });
                }

                @Override
                public int size() {
                    return keys.get().size();
                }
            };
        }

        @Override
        public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
            for (K location : this.keys.get()) {
                V existing;
                V replacement;
                boolean needsReplacement;
                try {
                    needsReplacement = function.apply(location, null) != null;
                }
                catch (Throwable e) {
                    needsReplacement = true;
                }
                if (!needsReplacement || (replacement = function.apply(location, existing = this.get(location))) == existing) continue;
                this.put(location, replacement);
            }
        }
    }

    private class DynamicBaker
    implements class_7775 {
        private final class_10525 modelDebugName;

        private DynamicBaker(class_10525 modelDebugName) {
            this.modelDebugName = modelDebugName;
        }

        public class_1087 method_45873(class_2960 location, class_3665 transform) {
            return ((Optional)DynamicModelProvider.this.loadedBlockModels.getUnchecked((Object)location)).map(unbakedModel -> {
                DynamicModelProvider.this.resolver.clearResolver();
                unbakedModel.method_62326((class_10526.class_10103)DynamicModelProvider.this.resolver);
                return class_1100.method_65765((class_1100)unbakedModel, (class_7775)this, (class_3665)transform);
            }).orElse(DynamicModelProvider.this.missingModel);
        }

        public class_10527 method_65732() {
            return DynamicModelProvider.this.textureGetter.method_65738(this.modelDebugName);
        }

        public class_10525 method_65733() {
            return this.modelDebugName;
        }
    }

    public static interface DynamicModelPlugin {
        public Optional<class_1100> modifyModelOnLoad(Optional<class_1100> var1, class_2960 var2);

        public class_9979 modifyBlockModelOnLoad(class_9979 var1, class_1091 var2, class_2680 var3);

        public class_1100 modifyModelBeforeBake(class_1100 var1, class_2960 var2, class_3665 var3, class_7775 var4);

        public class_1087 modifyModelAfterBake(class_1087 var1, class_1100 var2, class_2960 var3, class_3665 var4, class_7775 var5);

        public class_9979 modifyBlockModelBeforeBake(class_9979 var1, class_1091 var2, class_7775 var3);

        public class_1087 modifyBlockModelAfterBake(class_1087 var1, class_9979 var2, class_1091 var3, class_7775 var4);
    }

    public static interface ModelManagerExtension {
        public DynamicModelProvider mfix$getModelProvider();
    }
}

