/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.blockstate;

import com.google.common.collect.Iterators;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2769;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FakeStateMap<S>
implements Map<Map<class_2769<?>, Comparable<?>>, S> {
    private final Map<class_2769<?>, Comparable<?>>[] keys;
    private Map<Map<class_2769<?>, Comparable<?>>, S> fastLookup;
    private final Object[] values;
    private int usedSlots;

    public FakeStateMap(int numStates) {
        this.keys = new Map[numStates];
        this.values = new Object[numStates];
        this.usedSlots = 0;
    }

    @Override
    public int size() {
        return this.usedSlots;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object o) {
        return this.getFastLookup().containsKey(o);
    }

    @Override
    public boolean containsValue(Object o) {
        return this.getFastLookup().containsValue(o);
    }

    private Map<Map<class_2769<?>, Comparable<?>>, S> getFastLookup() {
        if (this.fastLookup == null) {
            Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap(this.usedSlots);
            Map<class_2769<?>, Comparable<?>>[] keys = this.keys;
            Object[] values = this.values;
            for (int i = 0; i < this.usedSlots; ++i) {
                map.put(keys[i], values[i]);
            }
            this.fastLookup = map;
        }
        return this.fastLookup;
    }

    @Override
    public S get(Object o) {
        return this.getFastLookup().get(o);
    }

    @Override
    @Nullable
    public S put(Map<class_2769<?>, Comparable<?>> propertyComparableMap, S s) {
        if (this.fastLookup != null) {
            throw new IllegalStateException("Cannot populate map after fast lookup is built");
        }
        this.keys[this.usedSlots] = propertyComparableMap;
        this.values[this.usedSlots] = s;
        ++this.usedSlots;
        return null;
    }

    @Override
    public S remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(@NotNull Map<? extends Map<class_2769<?>, Comparable<?>>, ? extends S> map) {
        for (Map.Entry<Map<class_2769<?>, Comparable<?>>, S> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.usedSlots; ++i) {
            this.keys[i] = null;
            this.values[i] = null;
        }
        this.usedSlots = 0;
    }

    private <T> List<T> asList(T ... array) {
        List<T> list = Arrays.asList(array);
        if (this.usedSlots < array.length) {
            list = list.subList(0, this.usedSlots);
        }
        return list;
    }

    @Override
    @NotNull
    public Set<Map<class_2769<?>, Comparable<?>>> keySet() {
        return new AbstractSet<Map<class_2769<?>, Comparable<?>>>(){

            @Override
            public Iterator<Map<class_2769<?>, Comparable<?>>> iterator() {
                return FakeStateMap.this.keys.length == FakeStateMap.this.usedSlots ? Iterators.forArray((Object[])FakeStateMap.this.keys) : FakeStateMap.this.asList(FakeStateMap.this.keys).iterator();
            }

            @Override
            public int size() {
                return FakeStateMap.this.usedSlots;
            }
        };
    }

    @Override
    @NotNull
    public Collection<S> values() {
        return this.asList(this.values);
    }

    @Override
    @NotNull
    public Set<Map.Entry<Map<class_2769<?>, Comparable<?>>, S>> entrySet() {
        return new AbstractSet<Map.Entry<Map<class_2769<?>, Comparable<?>>, S>>(){

            @Override
            public int size() {
                return FakeStateMap.this.usedSlots;
            }

            @Override
            @NotNull
            public Iterator<Map.Entry<Map<class_2769<?>, Comparable<?>>, S>> iterator() {
                return new Iterator<Map.Entry<Map<class_2769<?>, Comparable<?>>, S>>(){
                    int currentIdx = 0;

                    @Override
                    public boolean hasNext() {
                        return this.currentIdx < FakeStateMap.this.usedSlots;
                    }

                    @Override
                    public Map.Entry<Map<class_2769<?>, Comparable<?>>, S> next() {
                        if (this.currentIdx >= FakeStateMap.this.usedSlots) {
                            throw new IndexOutOfBoundsException();
                        }
                        AbstractMap.SimpleImmutableEntry entry = new AbstractMap.SimpleImmutableEntry(FakeStateMap.this.keys[this.currentIdx], FakeStateMap.this.values[this.currentIdx]);
                        ++this.currentIdx;
                        return entry;
                    }
                };
            }
        };
    }
}

