/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.konkrete.gui.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.konkrete.config.Config;
import de.keksuccino.konkrete.config.ConfigEntry;
import de.keksuccino.konkrete.gui.content.AdvancedButton;
import de.keksuccino.konkrete.gui.content.AdvancedTextField;
import de.keksuccino.konkrete.gui.content.scrollarea.ScrollArea;
import de.keksuccino.konkrete.gui.content.scrollarea.ScrollAreaEntry;
import de.keksuccino.konkrete.input.CharacterFilter;
import de.keksuccino.konkrete.input.MouseInput;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.localization.Locals;
import de.keksuccino.konkrete.math.MathUtils;
import de.keksuccino.konkrete.rendering.RenderUtils;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;

@Deprecated(forRemoval=true)
public class ConfigScreen
extends class_437 {
    protected Config config;
    protected ScrollArea configList;
    protected class_437 parent;
    protected String title;
    protected AdvancedButton doneBtn;
    protected String activeDescription = null;
    protected Map<String, String> descriptions = new HashMap<String, String>();
    protected static final Color ENTRY_BACKGROUND_COLOR = new Color(92, 92, 92);
    protected static final Color SCREEN_BACKGROUND_COLOR = new Color(54, 54, 54);
    protected static final Color HEADER_FOOTER_COLOR = new Color(33, 33, 33);

    public ConfigScreen(Config config, String title, class_437 parent) {
        super((class_2561)class_2561.method_43470((String)""));
        this.config = config;
        this.parent = parent;
        this.title = title;
        this.configList = new ScrollArea(0, 50, 300, 0);
        this.configList.backgroundColor = ENTRY_BACKGROUND_COLOR;
        for (String s : this.config.getCategories()) {
            this.configList.addEntry(new CategoryConfigScrollAreaEntry(this.configList, s));
            for (ConfigEntry e : this.config.getEntriesForCategory(s)) {
                if (e.getType() == ConfigEntry.EntryType.STRING) {
                    this.configList.addEntry(new StringConfigScrollAreaEntry(this.configList, e));
                }
                if (e.getType() == ConfigEntry.EntryType.INTEGER) {
                    this.configList.addEntry(new IntegerConfigScrollAreaEntry(this.configList, e));
                }
                if (e.getType() == ConfigEntry.EntryType.DOUBLE) {
                    this.configList.addEntry(new DoubleConfigScrollAreaEntry(this.configList, e));
                }
                if (e.getType() == ConfigEntry.EntryType.FLOAT) {
                    this.configList.addEntry(new FloatConfigScrollAreaEntry(this.configList, e));
                }
                if (e.getType() == ConfigEntry.EntryType.LONG) {
                    this.configList.addEntry(new LongConfigScrollAreaEntry(this.configList, e));
                }
                if (e.getType() != ConfigEntry.EntryType.BOOLEAN) continue;
                this.configList.addEntry(new BooleanConfigScrollAreaEntry(this.configList, e));
            }
        }
        this.doneBtn = new AdvancedButton(0, 0, 100, 20, Locals.localize("popup.done", new String[0]), true, press -> class_310.method_1551().method_1507(this.parent));
        ConfigScreen.colorizeButton(this.doneBtn);
        this.doneBtn.ignoreBlockedInput = true;
        this.doneBtn.ignoreLeftMouseDownClickBlock = true;
    }

    protected void method_25426() {
        this.configList.x = this.field_22789 / 2 - 150;
        this.configList.height = this.field_22790 - 100;
    }

    public void method_25432() {
        this.saveConfig();
    }

    public void method_25419() {
        class_310.method_1551().method_1507(this.parent);
    }

    public boolean method_25422() {
        return true;
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.enableBlend();
        graphics.method_25294(0, 0, this.field_22789, this.field_22790, SCREEN_BACKGROUND_COLOR.getRGB());
        this.configList.render(graphics);
        graphics.method_25294(0, 0, this.field_22789, 50, HEADER_FOOTER_COLOR.getRGB());
        if (this.title != null) {
            graphics.method_25303(this.field_22793, this.title, this.field_22789 / 2 - this.field_22793.method_1727(this.title) / 2, 20, Color.WHITE.getRGB());
        }
        graphics.method_25294(0, this.field_22790 - 50, this.field_22789, this.field_22790, HEADER_FOOTER_COLOR.getRGB());
        this.doneBtn.method_46421(this.field_22789 / 2 - this.doneBtn.method_25368() / 2);
        this.doneBtn.method_46419(this.field_22790 - 35);
        this.doneBtn.method_25394(graphics, mouseX, mouseY, partialTicks);
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        for (ScrollAreaEntry e : this.configList.getEntries()) {
            String name;
            if (!(e instanceof ConfigScrollAreaEntry) || !e.isHovered() || !this.descriptions.containsKey(name = ((ConfigScrollAreaEntry)e).configEntry.getName())) continue;
            if (ConfigScrollAreaEntry.isHeaderFooterHovered()) break;
            ConfigScreen.renderDescription(graphics, this.descriptions.get(name), mouseX, mouseY);
            break;
        }
    }

    public void method_25420(class_332 guiGraphics, int i, int j, float f) {
    }

    public void setValueDescription(String valueName, String desc) {
        this.descriptions.put(valueName, desc);
    }

    public void setCategoryDisplayName(String categoryName, String displayName) {
        CategoryConfigScrollAreaEntry e = this.getCategoryEntryByName(categoryName);
        if (e != null) {
            e.displayName = displayName;
        }
    }

    public void setValueDisplayName(String valueName, String displayName) {
        ConfigScrollAreaEntry e = this.getEntryByValueName(valueName);
        if (e != null) {
            e.displayName = displayName;
        }
    }

    protected ConfigScrollAreaEntry getEntryByValueName(String valueName) {
        for (ScrollAreaEntry e : this.configList.getEntries()) {
            if (!(e instanceof ConfigScrollAreaEntry) || !((ConfigScrollAreaEntry)e).configEntry.getName().equals(valueName)) continue;
            return (ConfigScrollAreaEntry)e;
        }
        return null;
    }

    protected CategoryConfigScrollAreaEntry getCategoryEntryByName(String categoryName) {
        for (ScrollAreaEntry e : this.configList.getEntries()) {
            if (!(e instanceof CategoryConfigScrollAreaEntry) || !((CategoryConfigScrollAreaEntry)e).category.equals(categoryName)) continue;
            return (CategoryConfigScrollAreaEntry)e;
        }
        return null;
    }

    protected void saveConfig() {
        for (ScrollAreaEntry e : this.configList.getEntries()) {
            if (!(e instanceof ConfigScrollAreaEntry)) continue;
            ((ConfigScrollAreaEntry)e).onSave();
        }
        this.config.syncConfig();
    }

    protected static void renderDescription(class_332 graphics, String description, int mouseX, int mouseY) {
        if (description != null) {
            String[] desc;
            int width = 10;
            int height = 10;
            for (String s : desc = StringUtils.splitLines(description, "%n%")) {
                int i = class_310.method_1551().field_1772.method_1727(s) + 10;
                if (i > width) {
                    width = i;
                }
                height += 10;
            }
            mouseY += 5;
            if (class_310.method_1551().field_1755.field_22789 < (mouseX += 5) + width) {
                mouseX -= width + 10;
            }
            if (class_310.method_1551().field_1755.field_22790 < mouseY + height) {
                mouseY -= height + 10;
            }
            RenderUtils.setZLevelPre(graphics, 600);
            ConfigScreen.renderDescriptionBackground(graphics, mouseX, mouseY, width, height);
            RenderSystem.enableBlend();
            int i2 = 5;
            for (String s : desc) {
                graphics.method_25303(class_310.method_1551().field_1772, s, mouseX + 5, mouseY + i2, Color.WHITE.getRGB());
                i2 += 10;
            }
            RenderUtils.setZLevelPost(graphics);
            RenderSystem.disableBlend();
        }
    }

    protected static void renderDescriptionBackground(class_332 graphics, int x, int y, int width, int height) {
        graphics.method_25294(x, y, x + width, y + height, new Color(26, 26, 26, 250).getRGB());
    }

    protected static void colorizeButton(AdvancedButton b) {
        b.setBackgroundColor(new Color(100, 100, 100), new Color(130, 130, 130), new Color(180, 180, 180), new Color(199, 199, 199), 1);
    }

    protected static class CategoryConfigScrollAreaEntry
    extends ScrollAreaEntry {
        protected String category;
        protected class_327 textRenderer;
        protected String displayName;

        public CategoryConfigScrollAreaEntry(ScrollArea parent, String category) {
            super(parent);
            this.textRenderer = class_310.method_1551().field_1772;
            this.category = category;
        }

        @Override
        public void renderEntry(class_332 graphics) {
            int center = this.x + this.getWidth() / 2;
            graphics.method_25294(this.x, this.y, this.x + this.getWidth(), this.y + this.getHeight(), ENTRY_BACKGROUND_COLOR.getRGB());
            if (this.displayName != null) {
                int nameWidth = this.textRenderer.method_1727(this.displayName);
                graphics.method_25303(this.textRenderer, this.displayName, center - nameWidth / 2, this.y + 10, Color.WHITE.getRGB());
            } else {
                int nameWidth = this.textRenderer.method_1727(this.category);
                graphics.method_25303(this.textRenderer, this.category, center - nameWidth / 2, this.y + 10, Color.WHITE.getRGB());
            }
        }

        @Override
        public int getHeight() {
            return 30;
        }
    }

    protected static class StringConfigScrollAreaEntry
    extends ConfigScrollAreaEntry {
        private AdvancedTextField input;

        public StringConfigScrollAreaEntry(ScrollArea parent, ConfigEntry configEntry) {
            super(parent, configEntry);
            this.input = new AdvancedTextField(class_310.method_1551().field_1772, 0, 0, 100, 20, true, null);
            this.input.method_1880(10000);
            this.input.method_1852(configEntry.getValue());
        }

        @Override
        public void render(class_332 graphics) {
            super.render(graphics);
            int center = this.x + this.getWidth() / 2;
            this.input.method_46421(center + 10);
            this.input.method_46419(this.y + 3);
            this.input.method_25394(graphics, MouseInput.getMouseX(), MouseInput.getMouseY(), class_310.method_1551().method_61966().method_60637(false));
        }

        @Override
        protected void onSave() {
            this.configEntry.setValue(this.input.method_1882());
        }
    }

    protected static class IntegerConfigScrollAreaEntry
    extends ConfigScrollAreaEntry {
        private AdvancedTextField input;

        public IntegerConfigScrollAreaEntry(ScrollArea parent, ConfigEntry configEntry) {
            super(parent, configEntry);
            this.input = new AdvancedTextField(class_310.method_1551().field_1772, 0, 0, 100, 20, true, CharacterFilter.getIntegerCharacterFiler());
            this.input.method_1880(10000);
            this.input.method_1852(configEntry.getValue());
        }

        @Override
        public void render(class_332 graphics) {
            super.render(graphics);
            int center = this.x + this.getWidth() / 2;
            this.input.method_46421(center + 10);
            this.input.method_46419(this.y + 3);
            this.input.method_25394(graphics, MouseInput.getMouseX(), MouseInput.getMouseY(), class_310.method_1551().method_61966().method_60637(false));
        }

        @Override
        protected void onSave() {
            if (MathUtils.isInteger(this.input.method_1882())) {
                this.configEntry.setValue(this.input.method_1882());
            } else {
                System.out.println("################ ERROR [KONKRETE] ################");
                System.out.println("Unable to save value to config! Invalid value type!");
                System.out.println("Value: " + this.input.method_1882());
                System.out.println("Variable Type: INTEGER");
                System.out.println("##################################################");
            }
        }
    }

    protected static class DoubleConfigScrollAreaEntry
    extends ConfigScrollAreaEntry {
        private AdvancedTextField input;

        public DoubleConfigScrollAreaEntry(ScrollArea parent, ConfigEntry configEntry) {
            super(parent, configEntry);
            this.input = new AdvancedTextField(class_310.method_1551().field_1772, 0, 0, 100, 20, true, CharacterFilter.getDoubleCharacterFiler());
            this.input.method_1880(10000);
            this.input.method_1852(configEntry.getValue());
        }

        @Override
        public void render(class_332 graphics) {
            super.render(graphics);
            int center = this.x + this.getWidth() / 2;
            this.input.method_46421(center + 10);
            this.input.method_46419(this.y + 3);
            this.input.method_25394(graphics, MouseInput.getMouseX(), MouseInput.getMouseY(), class_310.method_1551().method_61966().method_60637(false));
        }

        @Override
        protected void onSave() {
            if (MathUtils.isDouble(this.input.method_1882())) {
                this.configEntry.setValue(this.input.method_1882());
            } else {
                System.out.println("################ ERROR [KONKRETE] ################");
                System.out.println("Unable to save value to config! Invalid value type!");
                System.out.println("Value: " + this.input.method_1882());
                System.out.println("Variable Type: DOUBLE");
                System.out.println("##################################################");
            }
        }
    }

    protected static class FloatConfigScrollAreaEntry
    extends ConfigScrollAreaEntry {
        private AdvancedTextField input;

        public FloatConfigScrollAreaEntry(ScrollArea parent, ConfigEntry configEntry) {
            super(parent, configEntry);
            this.input = new AdvancedTextField(class_310.method_1551().field_1772, 0, 0, 100, 20, true, CharacterFilter.getDoubleCharacterFiler());
            this.input.method_1880(10000);
            this.input.method_1852(configEntry.getValue());
        }

        @Override
        public void render(class_332 graphics) {
            super.render(graphics);
            int center = this.x + this.getWidth() / 2;
            this.input.method_46421(center + 10);
            this.input.method_46419(this.y + 3);
            this.input.method_25394(graphics, MouseInput.getMouseX(), MouseInput.getMouseY(), class_310.method_1551().method_61966().method_60637(false));
        }

        @Override
        protected void onSave() {
            if (MathUtils.isFloat(this.input.method_1882())) {
                this.configEntry.setValue(this.input.method_1882());
            } else {
                System.out.println("################ ERROR [KONKRETE] ################");
                System.out.println("Unable to save value to config! Invalid value type!");
                System.out.println("Value: " + this.input.method_1882());
                System.out.println("Variable Type: FLOAT");
                System.out.println("##################################################");
            }
        }
    }

    protected static class LongConfigScrollAreaEntry
    extends ConfigScrollAreaEntry {
        private AdvancedTextField input;

        public LongConfigScrollAreaEntry(ScrollArea parent, ConfigEntry configEntry) {
            super(parent, configEntry);
            this.input = new AdvancedTextField(class_310.method_1551().field_1772, 0, 0, 100, 20, true, CharacterFilter.getIntegerCharacterFiler());
            this.input.method_1880(10000);
            this.input.method_1852(configEntry.getValue());
        }

        @Override
        public void render(class_332 graphics) {
            super.render(graphics);
            int center = this.x + this.getWidth() / 2;
            this.input.method_46421(center + 10);
            this.input.method_46419(this.y + 3);
            this.input.method_25394(graphics, MouseInput.getMouseX(), MouseInput.getMouseY(), class_310.method_1551().method_61966().method_60637(false));
        }

        @Override
        protected void onSave() {
            if (MathUtils.isLong(this.input.method_1882())) {
                this.configEntry.setValue(this.input.method_1882());
            } else {
                System.out.println("################ ERROR [KONKRETE] ################");
                System.out.println("Unable to save value to config! Invalid value type!");
                System.out.println("Value: " + this.input.method_1882());
                System.out.println("Variable Type: LONG");
                System.out.println("##################################################");
            }
        }
    }

    protected static class BooleanConfigScrollAreaEntry
    extends ConfigScrollAreaEntry {
        private AdvancedButton toggleBtn;
        private boolean state = false;

        public BooleanConfigScrollAreaEntry(ScrollArea parent, ConfigEntry configEntry) {
            super(parent, configEntry);
            if (configEntry.getValue().equalsIgnoreCase("true")) {
                this.state = true;
            }
            this.toggleBtn = new AdvancedButton(0, 0, 102, 20, "", true, press -> {
                if (!BooleanConfigScrollAreaEntry.isHeaderFooterHovered()) {
                    boolean bl = this.state = !this.state;
                    if (this.state) {
                        this.toggleBtn.method_25355((class_2561)class_2561.method_43470((String)("\u00a7a" + Locals.localize("configscreen.boolean.enabled", new String[0]))));
                    } else {
                        this.toggleBtn.method_25355((class_2561)class_2561.method_43470((String)("\u00a7c" + Locals.localize("configscreen.boolean.disabled", new String[0]))));
                    }
                }
            });
            if (this.state) {
                this.toggleBtn.method_25355((class_2561)class_2561.method_43470((String)("\u00a7a" + Locals.localize("configscreen.boolean.enabled", new String[0]))));
            } else {
                this.toggleBtn.method_25355((class_2561)class_2561.method_43470((String)("\u00a7c" + Locals.localize("configscreen.boolean.disabled", new String[0]))));
            }
            ConfigScreen.colorizeButton(this.toggleBtn);
        }

        @Override
        public void render(class_332 graphics) {
            super.render(graphics);
            int center = this.x + this.getWidth() / 2;
            this.toggleBtn.method_46421(center + 9);
            this.toggleBtn.method_46419(this.y + 3);
            this.toggleBtn.method_25394(graphics, MouseInput.getMouseX(), MouseInput.getMouseY(), class_310.method_1551().method_61966().method_60637(false));
        }

        @Override
        protected void onSave() {
            this.configEntry.setValue("" + this.state);
        }
    }

    protected static abstract class ConfigScrollAreaEntry
    extends ScrollAreaEntry {
        protected ConfigEntry configEntry;
        protected class_327 font;
        protected String displayName;

        public ConfigScrollAreaEntry(ScrollArea parent, ConfigEntry configEntry) {
            super(parent);
            this.font = class_310.method_1551().field_1772;
            this.configEntry = configEntry;
        }

        @Override
        public void renderEntry(class_332 graphics) {
            int center = this.x + this.getWidth() / 2;
            graphics.method_25294(this.x, this.y, this.x + this.getWidth(), this.y + this.getHeight(), ENTRY_BACKGROUND_COLOR.getRGB());
            if (this.displayName != null) {
                int nameWidth = this.font.method_1727(this.displayName);
                graphics.method_25303(this.font, this.displayName, center - nameWidth - 10, this.y + 10, Color.WHITE.getRGB());
            } else {
                int nameWidth = this.font.method_1727(this.configEntry.getName());
                graphics.method_25303(this.font, this.configEntry.getName(), center - nameWidth - 10, this.y + 10, Color.WHITE.getRGB());
            }
        }

        @Override
        public int getHeight() {
            return 26;
        }

        protected abstract void onSave();

        public static boolean isHeaderFooterHovered() {
            class_437 s = class_310.method_1551().field_1755;
            if (s != null) {
                int mouseX = MouseInput.getMouseX();
                int mouseY = MouseInput.getMouseY();
                int minXHeaderFooter = 0;
                int maxXHeaderFooter = s.field_22789;
                int minYHeader = 0;
                int maxYHeader = 50;
                int minYFooter = s.field_22790 - 50;
                int maxYFooter = s.field_22790;
                if (mouseX >= minXHeaderFooter && mouseX <= maxXHeaderFooter && mouseY >= minYHeader && mouseY <= maxYHeader) {
                    return true;
                }
                if (mouseX >= minXHeaderFooter && mouseX <= maxXHeaderFooter && mouseY >= minYFooter && mouseY <= maxYFooter) {
                    return true;
                }
            }
            return false;
        }
    }
}

