/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.migrate;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import journeymap.client.task.MigrationTask;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;

public class Migration {
    private final String targetPackage;

    public Migration(String targetPackage) {
        this.targetPackage = targetPackage;
    }

    public boolean performTasks() {
        boolean success = true;
        ArrayList<MigrationTask> tasks = new ArrayList<MigrationTask>();
        try {
            Set<Class<?>> classes = Migration.getClasses(this.targetPackage);
            for (Class<?> clazz : classes) {
                if (!MigrationTask.class.isAssignableFrom(clazz = Class.forName(clazz.getName()))) continue;
                try {
                    MigrationTask task = (MigrationTask)clazz.newInstance();
                    if (!task.isActive(Journeymap.JM_VERSION)) continue;
                    tasks.add(task);
                }
                catch (Throwable t) {
                    Journeymap.getLogger().error("Couldn't instantiate MigrationTask {} : {}", clazz, (Object)LogFormatter.toPartialString(t));
                    success = false;
                }
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Couldn't find MigrationTasks: {} : {}", (Object)t, (Object)LogFormatter.toPartialString(t));
            success = false;
        }
        for (MigrationTask task : tasks) {
            try {
                if (((Boolean)task.call()).booleanValue()) continue;
                success = false;
            }
            catch (Throwable t) {
                Journeymap.getLogger().fatal(LogFormatter.toString(t));
                success = false;
            }
        }
        if (!success) {
            Journeymap.getLogger().fatal("Some or all of JourneyMap migration failed! You may experience significant errors.");
        }
        return success;
    }

    private static Set<Class<?>> getClasses(String packageName) throws ClassNotFoundException, IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        assert (classLoader != null);
        String path = packageName.replace('.', '/');
        Enumeration<URL> resources = classLoader.getResources(path);
        ArrayList<File> dirs = new ArrayList<File>();
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            dirs.add(new File(resource.getFile()));
        }
        HashSet classes = new HashSet();
        for (File directory : dirs) {
            classes.addAll(Migration.findClasses(directory, packageName));
        }
        return classes;
    }

    private static Set<Class<?>> findClasses(File directory, String packageName) throws ClassNotFoundException {
        File[] files;
        HashSet classes = new HashSet();
        if (!directory.exists()) {
            return classes;
        }
        for (File file : files = directory.listFiles()) {
            if (file.isDirectory()) {
                assert (!file.getName().contains("."));
                classes.addAll(Migration.findClasses(file, packageName + "." + file.getName()));
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            classes.add(Class.forName(packageName + "." + file.getName().substring(0, file.getName().length() - 6)));
        }
        return classes;
    }
}

