/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui;

import java.util.Map;
import journeymap.client.JourneymapClient;
import journeymap.client.cartography.color.BiomeColor;
import journeymap.client.cartography.color.BlockStateColor;
import journeymap.client.data.WaypointsData;
import journeymap.client.log.ChatLog;
import journeymap.client.properties.MiniMapProperties;
import journeymap.client.render.ingame.WaypointDecorationRenderer;
import journeymap.client.render.ingame.WaypointRenderer;
import journeymap.client.ui.colorpalette.ColorPaletteItemEditor;
import journeymap.client.ui.colorpalette.ColorPaletteManagerScreen;
import journeymap.client.ui.colorpalette.ColorPaletteScreen;
import journeymap.client.ui.colorpalette.MobsAndPlayersColorEditor;
import journeymap.client.ui.component.screens.JmUI;
import journeymap.client.ui.component.screens.JmUILegacy;
import journeymap.client.ui.dialog.AboutDialog;
import journeymap.client.ui.dialog.GridEditor;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.client.ui.minimap.MiniMap;
import journeymap.client.ui.option.AddonOptionsManager;
import journeymap.client.ui.option.ClientOptionsManager;
import journeymap.client.ui.option.MinimapOptions;
import journeymap.client.ui.option.MultiplayerOptionsManager;
import journeymap.client.ui.option.ServerOptionsManager;
import journeymap.client.ui.waypointmanager.WaypointManager;
import journeymap.client.ui.waypointmanager.waypoint.WaypointEditor;
import journeymap.client.waypoint.ClientWaypointImpl;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import journeymap.common.properties.catagory.Category;
import net.minecraft.class_10209;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_408;
import net.minecraft.class_437;
import net.minecraft.class_490;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public enum UIManager {
    INSTANCE;

    private final Logger logger = Journeymap.getLogger();
    private MiniMap miniMap;
    private final WaypointRenderer waypointDecorationRenderer = new WaypointDecorationRenderer();
    class_310 minecraft = class_310.method_1551();

    public MiniMap getMinimap() {
        if (this.miniMap == null) {
            MiniMap tmp;
            try {
                int preset = JourneymapClient.getInstance().getMiniMapProperties1().isActive() ? 1 : 2;
                tmp = new MiniMap(JourneymapClient.getInstance().getMiniMapProperties(preset));
            }
            catch (Throwable e) {
                this.logger.error("Unexpected error: " + LogFormatter.toString(e));
                if (e instanceof LinkageError) {
                    ChatLog.announceError(e.getMessage() + " : JourneyMap is not compatible with this build of Forge!");
                }
                tmp = new MiniMap(new MiniMapProperties(1));
            }
            this.miniMap = tmp;
        }
        return this.miniMap;
    }

    public static void handleLinkageError(LinkageError error) {
        Journeymap.getLogger().error(LogFormatter.toString(error));
        try {
            ChatLog.announceError(error.getMessage() + " : JourneyMap is not compatible with this build of Forge!");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void closeAll() {
        try {
            this.closeCurrent();
        }
        catch (LinkageError e) {
            UIManager.handleLinkageError(e);
        }
        catch (Throwable e) {
            this.logger.error("Unexpected error: " + LogFormatter.toString(e));
        }
        this.minecraft.method_1507(null);
        this.minecraft.method_15995(true);
    }

    public void closeCurrent() {
        try {
            if (this.minecraft.field_1755 != null && this.minecraft.field_1755 instanceof JmUILegacy) {
                this.logger.debug("Closing " + String.valueOf(this.minecraft.field_1755.getClass()));
                this.minecraft.field_1755.method_25419();
            }
        }
        catch (LinkageError e) {
            UIManager.handleLinkageError(e);
        }
        catch (Throwable e) {
            this.logger.error("Unexpected error: " + LogFormatter.toString(e));
        }
    }

    public void closeWithKeyBind() {
        try {
            class_437 class_4372;
            if (this.minecraft.field_1755 != null && (class_4372 = this.minecraft.field_1755) instanceof JmUI) {
                JmUI jmUI = (JmUI)class_4372;
                this.logger.debug("Closing " + String.valueOf(((Object)((Object)jmUI)).getClass()));
                jmUI.closeWithKeyBind();
            } else if (this.minecraft.field_1755 != null && (class_4372 = this.minecraft.field_1755) instanceof JmUILegacy) {
                JmUILegacy jmUILegacy = (JmUILegacy)class_4372;
                this.logger.debug("Closing " + String.valueOf(((Object)((Object)jmUILegacy)).getClass()));
                jmUILegacy.closeWithKeyBind();
            }
        }
        catch (LinkageError e) {
            UIManager.handleLinkageError(e);
        }
        catch (Throwable e) {
            this.logger.error("Unexpected error: " + LogFormatter.toString(e));
        }
    }

    public void openInventory() {
        this.logger.debug("Opening inventory");
        this.closeAll();
        this.minecraft.method_1507((class_437)new class_490((class_1657)this.minecraft.field_1724));
    }

    public <T extends class_437> T open(Class<T> uiClass, class_437 returnDisplay) {
        try {
            if (uiClass.getSuperclass().isAssignableFrom(JmUILegacy.class) || uiClass.getSuperclass().isAssignableFrom(JmUI.class) || uiClass.getSuperclass().getSuperclass().isAssignableFrom(JmUI.class)) {
                return (T)this.open((class_437)uiClass.getConstructor(class_437.class).newInstance(returnDisplay));
            }
        }
        catch (LinkageError e) {
            UIManager.handleLinkageError(e);
            return null;
        }
        catch (Throwable e) {
            try {
                return (T)this.open((class_437)uiClass.getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Throwable e2) {
                this.logger.log(Level.ERROR, "1st unexpected exception creating UI: " + LogFormatter.toString(e));
                this.logger.log(Level.ERROR, "2nd unexpected exception creating UI: " + LogFormatter.toString(e2));
                this.closeCurrent();
                return null;
            }
        }
        return null;
    }

    public <T extends JmUILegacy> T open(Class<T> uiClass) {
        try {
            if (MiniMap.uiState().active) {
                MiniMap.updateUIState(false);
            }
            JmUILegacy ui = (JmUILegacy)((Object)uiClass.newInstance());
            return (T)((Object)this.open(ui));
        }
        catch (LinkageError e) {
            UIManager.handleLinkageError(e);
            return null;
        }
        catch (Throwable e) {
            this.logger.log(Level.ERROR, "Unexpected exception creating UI: " + LogFormatter.toString(e));
            this.closeCurrent();
            return null;
        }
    }

    public <T extends class_437> T open(T ui) {
        this.closeCurrent();
        this.logger.debug("Opening UI " + ui.getClass().getSimpleName());
        try {
            if (ui instanceof Fullscreen) {
                ((Fullscreen)ui).reset();
            }
            this.minecraft.method_1507(ui);
            class_304.method_1437();
        }
        catch (LinkageError e) {
            UIManager.handleLinkageError(e);
            return null;
        }
        catch (Throwable t) {
            this.logger.error(String.format("Unexpected exception opening UI %s: %s", ui.getClass(), LogFormatter.toString(t)));
        }
        return ui;
    }

    public void toggleMinimap() {
        try {
            this.setMiniMapEnabled(!this.isMiniMapEnabled());
        }
        catch (LinkageError e) {
            UIManager.handleLinkageError(e);
        }
        catch (Throwable t) {
            this.logger.error(String.format("Unexpected exception in toggleMinimap: %s", LogFormatter.toString(t)));
        }
    }

    public void toggleMiniMapEntityNames() {
        this.getMinimap().getCurrentMinimapProperties().showEntityNames.toggle();
    }

    public boolean isMiniMapEnabled() {
        try {
            return this.getMinimap().getCurrentMinimapProperties().enabled.get();
        }
        catch (LinkageError e) {
            UIManager.handleLinkageError(e);
        }
        catch (Throwable t) {
            this.logger.error(String.format("Unexpected exception in isMiniMapEnabled: %s", LogFormatter.toString(t)));
        }
        return false;
    }

    public void setMiniMapEnabled(boolean enable) {
        try {
            this.getMinimap().getCurrentMinimapProperties().enabled.set(enable);
            this.getMinimap().getCurrentMinimapProperties().save();
        }
        catch (LinkageError e) {
            UIManager.handleLinkageError(e);
        }
        catch (Throwable t) {
            this.logger.error(String.format("Unexpected exception in setMiniMapEnabled: %s", LogFormatter.toString(t)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawMiniMap(class_332 graphics) {
        class_10209.method_64146().method_15396("journeymap");
        try {
            boolean doDraw = false;
            if (this.getMinimap().getCurrentMinimapProperties().enabled.get().booleanValue()) {
                class_437 currentScreen = this.minecraft.field_1755;
                boolean bl = doDraw = currentScreen == null || currentScreen instanceof class_408;
                if (doDraw) {
                    if (!MiniMap.uiState().active) {
                        if (MiniMap.state().getLastMapTypeChange() == 0L) {
                            this.getMinimap().reset();
                        } else {
                            MiniMap.state().requireRefresh();
                        }
                    }
                    this.getMinimap().drawMap(graphics);
                }
            } else if (!this.getMinimap().getCurrentMinimapProperties().enabled.get().booleanValue() && MiniMap.uiState().active) {
                MiniMap.updateUIState(false);
            }
            if (doDraw && !MiniMap.uiState().active) {
                MiniMap.updateUIState(true);
            }
        }
        catch (LinkageError e) {
            UIManager.handleLinkageError(e);
        }
        catch (Throwable e) {
            Journeymap.getLogger().error("Error drawing minimap: " + LogFormatter.toString(e));
        }
        finally {
            class_10209.method_64146().method_15407();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawWaypointDecorations(class_332 graphics) {
        boolean renderingWaypointDecorations = false;
        class_10209.method_64146().method_15396("journeymap");
        try {
            if (JourneymapClient.getInstance().enabled() && JourneymapClient.getInstance().getWaypointProperties().renderWaypoints.get().booleanValue() && JourneymapClient.getInstance().getWaypointProperties().renderWaypointsWorld.get().booleanValue() && this.minecraft.field_1724 != null && !this.minecraft.field_1690.field_1842) {
                class_10209.method_64146().method_15396("waypoint_decorations");
                renderingWaypointDecorations = true;
                this.waypointDecorationRenderer.render(graphics);
            }
        }
        catch (LinkageError e) {
            UIManager.handleLinkageError(e);
        }
        catch (Throwable e) {
            Journeymap.getLogger().error("Error drawing waypoint decorations: " + LogFormatter.toString(e));
        }
        finally {
            if (renderingWaypointDecorations) {
                class_10209.method_64146().method_15407();
            }
            class_10209.method_64146().method_15407();
        }
    }

    public MiniMap getMiniMap() {
        return this.getMinimap();
    }

    public Fullscreen openFullscreenMap() {
        if (this.minecraft.field_1755 instanceof Fullscreen) {
            return (Fullscreen)this.minecraft.field_1755;
        }
        if (this.minecraft.field_1755 instanceof JmUILegacy || this.minecraft.field_1755 == null) {
            class_304.method_1437();
            return (Fullscreen)((Object)this.open((class_437)Fullscreen.class));
        }
        return null;
    }

    public void openFullscreenMap(ClientWaypointImpl holder) {
        try {
            if (holder.isInPlayerDimension()) {
                Fullscreen map = (Fullscreen)((Object)this.open((class_437)Fullscreen.class));
                map.centerOn(holder);
            }
        }
        catch (LinkageError e) {
            UIManager.handleLinkageError(e);
        }
        catch (Throwable e) {
            Journeymap.getLogger().error("Error opening map on waypoint: " + LogFormatter.toString(e));
        }
    }

    public class_437 openOptionsManager(class_437 returnDisplay, boolean clientOnly) {
        return this.open(new ClientOptionsManager(returnDisplay, clientOnly));
    }

    public void openOptionsManager(class_437 returnDisplay, Category ... initialCategories) {
        try {
            this.open(new ClientOptionsManager(returnDisplay, false, initialCategories));
        }
        catch (LinkageError e) {
            UIManager.handleLinkageError(e);
        }
        catch (Throwable e) {
            this.logger.log(Level.ERROR, "Unexpected exception creating MasterOptions with return class: " + LogFormatter.toString(e));
        }
    }

    public void openSplash(class_437 returnDisplay) {
        this.open(AboutDialog.class, returnDisplay);
    }

    public void openWaypointManager(ClientWaypointImpl holder, class_437 returnDisplay) {
        if (WaypointsData.isManagerEnabled()) {
            try {
                WaypointManager manager = new WaypointManager(holder, returnDisplay);
                this.open(manager);
            }
            catch (LinkageError e) {
                UIManager.handleLinkageError(e);
            }
            catch (Throwable e) {
                Journeymap.getLogger().error("Error opening waypoint manager: " + LogFormatter.toString(e));
            }
        }
    }

    public void openWaypointEditor(ClientWaypointImpl holder, boolean openedWithHotkey) {
        this.openWaypointEditor(holder, null, openedWithHotkey);
    }

    public void openWaypointEditor(ClientWaypointImpl holder, @Nullable class_2338 pos, boolean openedWithHotkey) {
        if (WaypointsData.isManagerEnabled()) {
            try {
                WaypointEditor editor = holder == null ? new WaypointEditor(openedWithHotkey, pos) : new WaypointEditor(holder);
                editor.display();
            }
            catch (LinkageError e) {
                UIManager.handleLinkageError(e);
            }
            catch (Throwable e) {
                Journeymap.getLogger().error("Error opening waypoint editor: " + LogFormatter.toString(e));
            }
        }
    }

    public void openColorPalette(class_437 returnDisplay) {
        try {
            ColorPaletteScreen screen = new ColorPaletteScreen(returnDisplay);
            this.open(screen);
        }
        catch (LinkageError e) {
            UIManager.handleLinkageError(e);
        }
        catch (Throwable e) {
            Journeymap.getLogger().error("Error opening color palette screen: " + LogFormatter.toString(e));
        }
    }

    public void openColorPaletteBlockEditor(String blockId, Map<String, BlockStateColor> blockStatesToColor, boolean saveToStandard, boolean saveToWorld, class_437 returnDisplay) {
        try {
            ColorPaletteItemEditor.BlockEditor editor = new ColorPaletteItemEditor.BlockEditor(blockId, blockStatesToColor, saveToStandard, saveToWorld, returnDisplay);
            this.open(editor);
        }
        catch (LinkageError e) {
            UIManager.handleLinkageError(e);
        }
        catch (Throwable e) {
            Journeymap.getLogger().error("Error opening color palette block editor: {}", (Object)LogFormatter.toString(e));
        }
    }

    public void openColorPaletteBiomeEditor(String blockId, BiomeColor biomeColor, boolean saveToStandard, boolean saveToWorld, class_437 returnDisplay) {
        try {
            ColorPaletteItemEditor.BiomeEditor editor = new ColorPaletteItemEditor.BiomeEditor(blockId, biomeColor, saveToStandard, saveToWorld, returnDisplay);
            this.open(editor);
        }
        catch (LinkageError e) {
            UIManager.handleLinkageError(e);
        }
        catch (Throwable e) {
            Journeymap.getLogger().error("Error opening color palette biome editor: {}", (Object)LogFormatter.toString(e));
        }
    }

    public void openMobsAndPlayersColorEditor(class_437 returnDisplay) {
        try {
            MobsAndPlayersColorEditor editor = new MobsAndPlayersColorEditor(returnDisplay);
            this.open(editor);
        }
        catch (LinkageError e) {
            UIManager.handleLinkageError(e);
        }
        catch (Throwable e) {
            Journeymap.getLogger().error("Error opening mobs and players color editor: " + LogFormatter.toString(e));
        }
    }

    public void openColorPaletteManager(ColorPaletteScreen returnDisplay) {
        try {
            ColorPaletteManagerScreen manager = new ColorPaletteManagerScreen(returnDisplay);
            this.open(manager);
        }
        catch (LinkageError e) {
            UIManager.handleLinkageError(e);
        }
        catch (Throwable e) {
            Journeymap.getLogger().error("Error opening color palette manager: " + LogFormatter.toString(e));
        }
    }

    public void openGridEditor(class_437 returnDisplay) {
        try {
            GridEditor editor = new GridEditor(returnDisplay);
            this.open(editor);
        }
        catch (LinkageError e) {
            UIManager.handleLinkageError(e);
        }
        catch (Throwable e) {
            Journeymap.getLogger().error("Error opening grid editor: " + LogFormatter.toString(e));
        }
    }

    public void openMinimapPosition(class_437 returnDisplay, MiniMapProperties properties) {
        try {
            MinimapOptions editor = new MinimapOptions(returnDisplay, properties);
            this.open(editor);
        }
        catch (LinkageError e) {
            UIManager.handleLinkageError(e);
        }
        catch (Throwable e) {
            Journeymap.getLogger().error("Error opening grid editor: " + LogFormatter.toString(e));
        }
    }

    public void openServerEditor(class_437 returnDisplay) {
        try {
            ServerOptionsManager editor = new ServerOptionsManager(returnDisplay);
            this.open(editor);
        }
        catch (LinkageError e) {
            UIManager.handleLinkageError(e);
        }
        catch (Throwable e) {
            Journeymap.getLogger().error("Error opening server manager: " + LogFormatter.toString(e));
        }
    }

    public void openMultiplayerEditor(class_437 returnDisplay) {
        try {
            MultiplayerOptionsManager editor = new MultiplayerOptionsManager(returnDisplay);
            this.open(editor);
        }
        catch (LinkageError e) {
            UIManager.handleLinkageError(e);
        }
        catch (Throwable e) {
            Journeymap.getLogger().error("Error opening multiplayer options manager: " + LogFormatter.toString(e));
        }
    }

    public void openAddonOptionsEditor(class_437 returnDisplay, boolean clientOnly) {
        try {
            AddonOptionsManager editor = new AddonOptionsManager(returnDisplay, clientOnly);
            this.open(editor);
        }
        catch (LinkageError e) {
            UIManager.handleLinkageError(e);
        }
        catch (Throwable e) {
            Journeymap.getLogger().error("Error opening Addon options manager: " + LogFormatter.toString(e));
        }
    }

    public ServerOptionsManager getServerEditor() {
        if (this.minecraft.field_1755 instanceof ServerOptionsManager) {
            return (ServerOptionsManager)this.minecraft.field_1755;
        }
        return null;
    }

    public MultiplayerOptionsManager getMultiplayerOptions() {
        if (this.minecraft.field_1755 instanceof MultiplayerOptionsManager) {
            return (MultiplayerOptionsManager)this.minecraft.field_1755;
        }
        return null;
    }

    public void reset() {
        try {
            Fullscreen.state().requireRefresh();
            this.getMinimap().reset();
        }
        catch (LinkageError e) {
            UIManager.handleLinkageError(e);
        }
        catch (Throwable e) {
            Journeymap.getLogger().error("Error during reset: " + LogFormatter.toString(e));
        }
    }

    public void switchMiniMapPreset() {
        try {
            int currentPreset = this.getMinimap().getCurrentMinimapProperties().getId();
            this.switchMiniMapPreset(currentPreset == 1 ? 2 : 1);
        }
        catch (LinkageError e) {
            UIManager.handleLinkageError(e);
        }
        catch (Throwable e) {
            Journeymap.getLogger().error("Error during switchMiniMapPreset: " + LogFormatter.toString(e));
        }
    }

    public void switchMiniMapPreset(int which) {
        try {
            this.getMinimap().setMiniMapProperties(JourneymapClient.getInstance().getMiniMapProperties(which));
            MiniMap.state().requireRefresh();
        }
        catch (LinkageError e) {
            UIManager.handleLinkageError(e);
        }
        catch (Throwable e) {
            Journeymap.getLogger().error("Error during switchMiniMapPreset: " + LogFormatter.toString(e));
        }
    }
}

