/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render.draw;

import com.google.common.cache.CacheLoader;
import earcut4j.Earcut;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import journeymap.api.v2.client.display.Context;
import journeymap.api.v2.client.display.PolygonOverlay;
import journeymap.api.v2.client.model.MapPolygon;
import journeymap.api.v2.client.model.ShapeProperties;
import journeymap.api.v2.client.model.TextProperties;
import journeymap.client.data.DataCache;
import journeymap.client.render.draw.BaseOverlayDrawStep;
import journeymap.client.render.draw.DrawStep;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.map.Renderer;
import journeymap.client.texture.TextureCache;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.minimap.DisplayVars;
import journeymap.client.ui.minimap.Shape;
import journeymap.common.Journeymap;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4597;
import org.jetbrains.annotations.NotNull;

public class DrawPolygonStep
extends BaseOverlayDrawStep<PolygonOverlay> {
    protected List<Point2D.Double> fillPoints = new ArrayList<Point2D.Double>();
    protected List<List<Point2D.Double>> strokePoints = new ArrayList<List<Point2D.Double>>();
    protected List<Point2D.Double> texturePoints = new ArrayList<Point2D.Double>();
    private class_2960 textureResource;
    private class_1044 texture;
    boolean doRender = true;
    boolean onScreen;

    public DrawPolygonStep(PolygonOverlay polygon) {
        super(polygon);
    }

    @Override
    public void draw(class_332 graphics, class_4597 buffers, DrawStep.Pass pass, double xOffset, double yOffset, Renderer renderer, double fontScale, double rotation) {
        if (pass == DrawStep.Pass.Object) {
            if (((PolygonOverlay)this.overlay).getOuterArea().getPoints().isEmpty()) {
                this.onScreen = false;
                return;
            }
            this.onScreen = this.isOnScreen(xOffset, yOffset, renderer, rotation);
            if (this.onScreen && this.doRender) {
                this.ensureTexture();
                DrawUtil.drawPolygon(graphics, buffers, xOffset, yOffset, this.fillPoints, this.strokePoints, this.texturePoints, (class_1043)this.texture, ((PolygonOverlay)this.overlay).getShapeProperties());
            }
        } else if ((pass == DrawStep.Pass.Text || pass == DrawStep.Pass.Tooltip) && this.onScreen && this.doRender && this.isTextInMinimap(renderer)) {
            super.drawText(graphics, pass, xOffset, yOffset, renderer, fontScale, rotation);
        }
    }

    public void setTextureResource(class_2960 textureResource) {
        this.textureResource = textureResource;
        this.texture = null;
    }

    public class_2960 getTextureResource() {
        return this.textureResource;
    }

    protected void ensureTexture() {
        if (this.textureResource == null || this.texture != null) {
            return;
        }
        try {
            this.texture = TextureCache.getTexture(this.textureResource);
            this.texture.method_23207();
        }
        catch (Exception e) {
            Journeymap.getLogger().error("Error getting PolygonOverlay texture: " + String.valueOf(e), (Throwable)e);
        }
    }

    private boolean isTextInMinimap(Renderer renderer) {
        if (renderer.getUIState().ui == Context.UI.Minimap) {
            class_310 mc = class_310.method_1551();
            DisplayVars dv = UIManager.INSTANCE.getMiniMap().getDisplayVars();
            Point2D.Double centerPoint = renderer.getPixel(mc.field_1724.method_23317(), mc.field_1724.method_23321());
            Rectangle2D.Double centerRect = new Rectangle2D.Double(((Point2D)centerPoint).getX() - (double)(dv.minimapWidth / 2), ((Point2D)centerPoint).getY() - (double)(dv.minimapHeight / 2), dv.minimapWidth, dv.minimapHeight);
            if (dv.getShape() == Shape.Circle) {
                return centerPoint.distance(this.labelPosition) < (double)(dv.minimapWidth / 2);
            }
            return centerRect.contains(renderer.getWindowPosition(this.labelPosition));
        }
        return true;
    }

    @Override
    protected void updatePositions(Renderer renderer, double rotation) {
        if (((PolygonOverlay)this.overlay).getOuterArea().getPoints().isEmpty()) {
            return;
        }
        if (Context.UI.Minimap == renderer.getUIState().ui) {
            class_243 playerPos = class_310.method_1551().field_1724.method_19538();
            int limit = renderer.getZoom() * renderer.getGridSize() / 2;
            if (!((class_2338)((PolygonOverlay)this.overlay).getOuterArea().getPoints().get(0)).method_19771(new class_2382(class_3532.method_15357((double)playerPos.method_10216()), class_3532.method_15357((double)playerPos.method_10214()), class_3532.method_15357((double)playerPos.method_10215())), (double)limit)) {
                this.doRender = false;
                return;
            }
        }
        this.doRender = true;
        List<class_2338> points = DataCache.INSTANCE.getTriangulation((PolygonOverlay)this.overlay);
        this.fillPoints.clear();
        this.texturePoints.clear();
        for (class_2338 class_23382 : points) {
            Point2D.Double pixel = renderer.getBlockPixelInGrid(class_23382);
            if (this.fillPoints.isEmpty()) {
                this.screenBounds.setRect(pixel.x, pixel.y, 1.0, 1.0);
            } else {
                this.screenBounds.add(pixel);
            }
            this.fillPoints.add(pixel);
            this.texturePoints.add(new Point2D.Double(class_23382.method_10263(), class_23382.method_10260()));
        }
        boolean needClockwise = ((PolygonOverlay)this.overlay).getShapeProperties().getStrokePosition() != ShapeProperties.StrokePosition.CENTER;
        this.strokePoints.clear();
        this.strokePoints.add(DrawPolygonStep.toScreen(renderer, ((PolygonOverlay)this.overlay).getOuterArea(), needClockwise, false));
        if (((PolygonOverlay)this.overlay).getHoles() != null) {
            for (MapPolygon hole : ((PolygonOverlay)this.overlay).getHoles()) {
                this.strokePoints.add(DrawPolygonStep.toScreen(renderer, hole, needClockwise, true));
            }
        }
        TextProperties textProperties = ((PolygonOverlay)this.overlay).getTextProperties();
        this.labelPosition.setLocation(this.screenBounds.getCenterX() + (double)textProperties.getOffsetX(), this.screenBounds.getCenterY() + (double)textProperties.getOffsetY());
    }

    private static List<Point2D.Double> toScreen(@NotNull Renderer renderer, @NotNull MapPolygon polygon, boolean needClockwise, boolean hole) {
        ArrayList<Point2D.Double> points = new ArrayList<Point2D.Double>();
        if (polygon.getPoints().isEmpty()) {
            return points;
        }
        int direction = 0;
        class_2338 prev = (class_2338)polygon.getPoints().getLast();
        for (class_2338 pos : polygon.getPoints()) {
            points.add(renderer.getBlockPixelInGrid(pos));
            if (!needClockwise) continue;
            direction += (pos.method_10263() + prev.method_10263()) * (pos.method_10260() - prev.method_10260());
            prev = pos;
        }
        if (needClockwise && direction < 0 != hole) {
            Collections.reverse(points);
        }
        return points;
    }

    public static List<MapPolygon> triangulate(@NotNull PolygonOverlay overlay) {
        List holesList = Optional.ofNullable(overlay.getHoles()).orElse(new ArrayList());
        List blockPoints = Stream.concat(overlay.getOuterArea().getPoints().stream(), holesList.stream().flatMap(hole -> hole.getPoints().stream())).collect(Collectors.toList());
        double[] points = new double[blockPoints.size() * 2];
        for (int index = 0; index < blockPoints.size(); ++index) {
            points[index * 2] = ((class_2338)blockPoints.get(index)).method_10263();
            points[index * 2 + 1] = ((class_2338)blockPoints.get(index)).method_10260();
        }
        int[] holes = new int[holesList.size()];
        int holeIndex = overlay.getOuterArea().getPoints().size();
        for (int index = 0; index < holesList.size(); ++index) {
            holes[index] = holeIndex;
            holeIndex += ((MapPolygon)holesList.get(index)).getPoints().size();
        }
        List<Integer> triangles = Earcut.earcut(points, holes, 2);
        ArrayList<MapPolygon> trianglePolys = new ArrayList<MapPolygon>();
        for (int index = 0; index < triangles.size(); index += 3) {
            ArrayList<class_2338> trianglePoints = new ArrayList<class_2338>();
            trianglePoints.add((class_2338)blockPoints.get(triangles.get(index + 2)));
            trianglePoints.add((class_2338)blockPoints.get(triangles.get(index + 1)));
            trianglePoints.add((class_2338)blockPoints.get(triangles.get(index)));
            trianglePolys.add(new MapPolygon(trianglePoints));
        }
        return trianglePolys;
    }

    public static class SimpleCacheLoader
    extends CacheLoader<PolygonOverlay, DrawPolygonStep> {
        public DrawPolygonStep load(PolygonOverlay overlay) throws Exception {
            return new DrawPolygonStep(overlay);
        }
    }

    public static class TriangulationCacheLoader
    extends CacheLoader<PolygonOverlay, List<class_2338>> {
        public List<class_2338> load(PolygonOverlay overlay) throws Exception {
            return DrawPolygonStep.triangulate(overlay).stream().flatMap(poly -> poly.getPoints().stream()).collect(Collectors.toList());
        }
    }
}

