/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.ui.screen.filebrowser;

import de.keksuccino.fancymenu.util.rendering.ui.screen.filebrowser.AbstractFileBrowserScreen;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.ScrollArea;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.entry.ScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.ExtendedButton;
import java.io.File;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseFileScreen
extends AbstractFileBrowserScreen {
    @NotNull
    public static ChooseFileScreen build(@NotNull File rootDirectory, @NotNull Consumer<File> callback) {
        return new ChooseFileScreen(rootDirectory, rootDirectory, callback);
    }

    public ChooseFileScreen(@Nullable File rootDirectory, @NotNull File startDirectory, @NotNull Consumer<File> callback) {
        super((class_2561)class_2561.method_43471((String)"fancymenu.ui.filechooser.choose.file"), rootDirectory, startDirectory, callback);
    }

    @Override
    @NotNull
    protected ExtendedButton buildConfirmButton() {
        return new ExtendedButton(0, 0, 150, 20, (class_2561)class_2561.method_43471((String)"fancymenu.guicomponents.ok"), button -> {
            AbstractFileBrowserScreen.AbstractFileScrollAreaEntry selected = this.getSelectedEntry();
            if (selected != null && !selected.resourceUnfriendlyFileName) {
                this.callback.accept(new File(selected.file.getPath().replace("\\", "/")));
            }
        }){

            @Override
            public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
                AbstractFileBrowserScreen.AbstractFileScrollAreaEntry e = ChooseFileScreen.this.getSelectedEntry();
                this.field_22763 = e != null && !e.resourceUnfriendlyFileName && e.file.isFile();
                super.method_25394(graphics, mouseX, mouseY, partial);
            }
        };
    }

    @Override
    protected AbstractFileBrowserScreen.AbstractFileScrollAreaEntry buildFileEntry(@NotNull File f) {
        return new FileScrollAreaEntry(this.fileListScrollArea, f);
    }

    public boolean method_25404(int keycode, int scancode, int modifiers) {
        AbstractFileBrowserScreen.AbstractFileScrollAreaEntry selected;
        if (keycode == 257 && (selected = this.getSelectedEntry()) != null) {
            this.callback.accept(new File(selected.file.getPath().replace("\\", "/")));
            return true;
        }
        return super.method_25404(keycode, scancode, modifiers);
    }

    public class FileScrollAreaEntry
    extends AbstractFileBrowserScreen.AbstractFileScrollAreaEntry {
        public FileScrollAreaEntry(@NotNull ScrollArea parent, File file) {
            super(ChooseFileScreen.this, parent, file);
        }

        @Override
        public void onClick(ScrollAreaEntry entry) {
            if (this.resourceUnfriendlyFileName) {
                return;
            }
            long now = System.currentTimeMillis();
            if (now - this.lastClick < 400L) {
                if (this.file.isFile()) {
                    ChooseFileScreen.this.callback.accept(new File(this.file.getPath().replace("\\", "/")));
                } else if (this.file.isDirectory()) {
                    ChooseFileScreen.this.setDirectory(this.file, true);
                }
            }
            ChooseFileScreen.this.updatePreview(this.file);
            this.lastClick = now;
        }
    }
}

