/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering;

import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinGuiGraphics;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import java.awt.Color;
import java.util.function.Function;
import net.minecraft.class_1041;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4588;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class RenderingUtils {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final DrawableColor MISSING_TEXTURE_COLOR_MAGENTA = DrawableColor.of(Color.MAGENTA);
    public static final DrawableColor MISSING_TEXTURE_COLOR_BLACK = DrawableColor.BLACK;
    public static final class_2960 FULLY_TRANSPARENT_TEXTURE = class_2960.method_60655((String)"fancymenu", (String)"textures/fully_transparent.png");

    public static void renderMissing(@NotNull class_332 graphics, int x, int y, int width, int height) {
        int partW = width / 2;
        int partH = height / 2;
        graphics.method_51739(class_1921.method_51785(), x, y, x + partW, y + partH, MISSING_TEXTURE_COLOR_MAGENTA.getColorInt());
        graphics.method_51739(class_1921.method_51785(), x + partW, y, x + width, y + partH, MISSING_TEXTURE_COLOR_BLACK.getColorInt());
        graphics.method_51739(class_1921.method_51785(), x, y + partH, x + partW, y + height, MISSING_TEXTURE_COLOR_BLACK.getColorInt());
        graphics.method_51739(class_1921.method_51785(), x + partW, y + partH, x + width, y + height, MISSING_TEXTURE_COLOR_MAGENTA.getColorInt());
    }

    public static void blitRepeat(@NotNull class_332 graphics, @NotNull class_2960 location, int x, int y, int areaRenderWidth, int areaRenderHeight, int texWidth, int texHeight, int color) {
        RenderingUtils.blitRepeat(graphics, class_1921::method_62277, location, x, y, areaRenderWidth, areaRenderHeight, texWidth, texHeight, color);
    }

    public static void blitRepeat(@NotNull class_332 graphics, @NotNull Function<class_2960, class_1921> renderType, @NotNull class_2960 location, int x, int y, int areaRenderWidth, int areaRenderHeight, int texWidth, int texHeight, int color) {
        graphics.method_25291(renderType, location, x, y, 0.0f, 0.0f, areaRenderWidth, areaRenderHeight, texWidth, texHeight, color);
    }

    public static void blitNineSlicedTexture(class_332 graphics, class_2960 texture, int x, int y, int width, int height, int textureWidth, int textureHeight, int borderTop, int borderRight, int borderBottom, int borderLeft, int color) {
        RenderingUtils.blitNineSlicedTexture(graphics, class_1921::method_62277, texture, x, y, width, height, textureWidth, textureHeight, borderTop, borderRight, borderBottom, borderLeft, color);
    }

    public static void blitNineSlicedTexture(class_332 graphics, @NotNull Function<class_2960, class_1921> renderType, class_2960 texture, int x, int y, int width, int height, int textureWidth, int textureHeight, int borderTop, int borderRight, int borderBottom, int borderLeft, int color) {
        int pieceHeight;
        int j;
        int pieceWidth;
        int i;
        graphics.method_25291(renderType, texture, x, y, 0.0f, 0.0f, borderLeft, borderTop, textureWidth, textureHeight, color);
        graphics.method_25291(renderType, texture, x + width - borderRight, y, (float)(textureWidth - borderRight), 0.0f, borderRight, borderTop, textureWidth, textureHeight, color);
        graphics.method_25291(renderType, texture, x, y + height - borderBottom, 0.0f, (float)(textureHeight - borderBottom), borderLeft, borderBottom, textureWidth, textureHeight, color);
        graphics.method_25291(renderType, texture, x + width - borderRight, y + height - borderBottom, (float)(textureWidth - borderRight), (float)(textureHeight - borderBottom), borderRight, borderBottom, textureWidth, textureHeight, color);
        int centerWidth = textureWidth - borderLeft - borderRight;
        int centerHeight = textureHeight - borderTop - borderBottom;
        for (i = borderLeft; i < width - borderRight; i += centerWidth) {
            pieceWidth = Math.min(centerWidth, width - borderRight - i);
            graphics.method_25291(renderType, texture, x + i, y, (float)borderLeft, 0.0f, pieceWidth, borderTop, textureWidth, textureHeight, color);
        }
        for (i = borderLeft; i < width - borderRight; i += centerWidth) {
            pieceWidth = Math.min(centerWidth, width - borderRight - i);
            graphics.method_25291(renderType, texture, x + i, y + height - borderBottom, (float)borderLeft, (float)(textureHeight - borderBottom), pieceWidth, borderBottom, textureWidth, textureHeight, color);
        }
        for (j = borderTop; j < height - borderBottom; j += centerHeight) {
            pieceHeight = Math.min(centerHeight, height - borderBottom - j);
            graphics.method_25291(renderType, texture, x, y + j, 0.0f, (float)borderTop, borderLeft, pieceHeight, textureWidth, textureHeight, color);
        }
        for (j = borderTop; j < height - borderBottom; j += centerHeight) {
            pieceHeight = Math.min(centerHeight, height - borderBottom - j);
            graphics.method_25291(renderType, texture, x + width - borderRight, y + j, (float)(textureWidth - borderRight), (float)borderTop, borderRight, pieceHeight, textureWidth, textureHeight, color);
        }
        for (i = borderLeft; i < width - borderRight; i += centerWidth) {
            pieceWidth = Math.min(centerWidth, width - borderRight - i);
            for (int j2 = borderTop; j2 < height - borderBottom; j2 += centerHeight) {
                int pieceHeight2 = Math.min(centerHeight, height - borderBottom - j2);
                graphics.method_25291(renderType, texture, x + i, y + j2, (float)borderLeft, (float)borderTop, pieceWidth, pieceHeight2, textureWidth, textureHeight, color);
            }
        }
    }

    public static float getPartialTick() {
        return class_310.method_1551().method_61966().method_60637(false);
    }

    public static boolean isXYInArea(int targetX, int targetY, int x, int y, int width, int height) {
        return RenderingUtils.isXYInArea((double)targetX, (double)targetY, (double)x, (double)y, (double)width, (double)height);
    }

    public static boolean isXYInArea(double targetX, double targetY, double x, double y, double width, double height) {
        return targetX >= x && targetX < x + width && targetY >= y && targetY < y + height;
    }

    public static void resetGuiScale() {
        class_1041 m = class_310.method_1551().method_22683();
        m.method_15997((double)m.method_4476(((Integer)class_310.method_1551().field_1690.method_42474().method_41753()).intValue(), ((Boolean)class_310.method_1551().field_1690.method_42437().method_41753()).booleanValue()));
    }

    public static int replaceAlphaInColor(int color, int newAlpha) {
        newAlpha = Math.min(newAlpha, 255);
        return color & 0xFFFFFF | newAlpha << 24;
    }

    public static int replaceAlphaInColor(int color, float newAlpha) {
        return RenderingUtils.replaceAlphaInColor(color, (int)(newAlpha * 255.0f));
    }

    public static void fillF(@NotNull class_332 graphics, float minX, float minY, float maxX, float maxY, int color) {
        RenderingUtils.fillF(graphics, minX, minY, maxX, maxY, 0.0f, color);
    }

    public static void fillF(@NotNull class_332 graphics, float minX, float minY, float maxX, float maxY, float z, int color) {
        RenderingUtils.fillF(graphics, class_1921.method_51784(), minX, minY, maxX, maxY, z, color);
    }

    public static void fillF(@NotNull class_332 graphics, @NotNull class_1921 renderType, float minX, float minY, float maxX, float maxY, int color) {
        RenderingUtils.fillF(graphics, renderType, minX, minY, maxX, maxY, 0.0f, color);
    }

    public static void fillF(@NotNull class_332 graphics, @NotNull class_1921 renderType, float minX, float minY, float maxX, float maxY, float z, int color) {
        float f;
        Matrix4f matrix4f = graphics.method_51448().method_23760().method_23761();
        if (minX < maxX) {
            f = minX;
            minX = maxX;
            maxX = f;
        }
        if (minY < maxY) {
            f = minY;
            minY = maxY;
            maxY = f;
        }
        class_4588 $$10 = ((IMixinGuiGraphics)graphics).getBufferSource_FancyMenu().getBuffer(renderType);
        $$10.method_22918(matrix4f, minX, minY, z).method_39415(color);
        $$10.method_22918(matrix4f, minX, maxY, z).method_39415(color);
        $$10.method_22918(matrix4f, maxX, maxY, z).method_39415(color);
        $$10.method_22918(matrix4f, maxX, minY, z).method_39415(color);
    }

    public static void blitF(@NotNull class_332 graphics, Function<class_2960, class_1921> renderTypeFunc, class_2960 location, float $$2, float $$3, float $$4, float $$5, float $$6, float $$7, float $$8, float $$9, int color) {
        RenderingUtils.blitF(graphics, renderTypeFunc, location, $$2, $$3, $$4, $$5, $$6, $$7, $$6, $$7, $$8, $$9, color);
    }

    public static void blitF(@NotNull class_332 graphics, Function<class_2960, class_1921> renderTypeFunc, class_2960 location, float $$2, float $$3, float $$4, float $$5, float $$6, float $$7, float $$8, float $$9) {
        RenderingUtils.blitF(graphics, renderTypeFunc, location, $$2, $$3, $$4, $$5, $$6, $$7, $$6, $$7, $$8, $$9);
    }

    public static void blitF(@NotNull class_332 graphics, Function<class_2960, class_1921> renderTypeFunc, class_2960 location, float $$2, float $$3, float $$4, float $$5, float $$6, float $$7, float $$8, float $$9, float $$10, float $$11) {
        RenderingUtils.blitF(graphics, renderTypeFunc, location, $$2, $$3, $$4, $$5, $$6, $$7, $$8, $$9, $$10, $$11, -1);
    }

    public static void blitF(@NotNull class_332 graphics, Function<class_2960, class_1921> renderTypeFunc, class_2960 location, float $$2, float $$3, float $$4, float $$5, float $$6, float $$7, float $$8, float $$9, float $$10, float $$11, int color) {
        RenderingUtils.innerBlit(graphics, renderTypeFunc, location, $$2, $$2 + $$6, $$3, $$3 + $$7, ($$4 + 0.0f) / $$10, ($$4 + $$8) / $$10, ($$5 + 0.0f) / $$11, ($$5 + $$9) / $$11, color);
    }

    private static void innerBlit(@NotNull class_332 graphics, Function<class_2960, class_1921> renderTypeFunc, class_2960 location, float $$2, float $$3, float $$4, float $$5, float $$6, float $$7, float $$8, float $$9, int color) {
        class_1921 renderType = renderTypeFunc.apply(location);
        Matrix4f matrix4f = graphics.method_51448().method_23760().method_23761();
        class_4588 consumer = ((IMixinGuiGraphics)graphics).getBufferSource_FancyMenu().getBuffer(renderType);
        consumer.method_22918(matrix4f, $$2, $$4, 0.0f).method_22913($$6, $$8).method_39415(color);
        consumer.method_22918(matrix4f, $$2, $$5, 0.0f).method_22913($$6, $$9).method_39415(color);
        consumer.method_22918(matrix4f, $$3, $$5, 0.0f).method_22913($$7, $$9).method_39415(color);
        consumer.method_22918(matrix4f, $$3, $$4, 0.0f).method_22913($$7, $$8).method_39415(color);
    }
}

