/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.variables;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.customization.variables.Variable;
import de.keksuccino.fancymenu.customization.variables.VariableHandler;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.cycle.CommonCycles;
import de.keksuccino.fancymenu.util.cycle.LocalizedEnumValueCycle;
import de.keksuccino.fancymenu.util.input.CharacterFilter;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.screen.ConfirmationScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.TextInputScreen;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.ScrollArea;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.entry.ScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.entry.TextListScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.entry.TextScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.ExtendedButton;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ManageVariablesScreen
extends class_437 {
    protected Consumer<List<Variable>> callback;
    protected ScrollArea variableListScrollArea = new ScrollArea(0, 0, 0, 0);
    protected ExtendedButton doneButton;
    protected ExtendedButton setValueButton;
    protected ExtendedButton deleteVariableButton;
    protected ExtendedButton addVariableButton;
    protected ExtendedButton toggleResetOnLaunchButton;

    public ManageVariablesScreen(@NotNull Consumer<List<Variable>> callback) {
        super((class_2561)class_2561.method_43471((String)"fancymenu.overlay.menu_bar.variables.manage"));
        this.callback = callback;
        this.updateVariableScrollArea();
    }

    protected void method_25426() {
        this.addVariableButton = new ExtendedButton(0, 0, 220, 20, (class_2561)class_2561.method_43471((String)"fancymenu.overlay.menu_bar.variables.manage.add_variable"), button -> {
            TextInputScreen s = new TextInputScreen((class_2561)class_2561.method_43471((String)"fancymenu.overlay.menu_bar.variables.manage.add_variable.input_name"), CharacterFilter.buildOnlyLowercaseFileNameFilter(), call -> {
                if (call != null && !VariableHandler.variableExists(call)) {
                    VariableHandler.setVariable(call, "");
                    this.updateVariableScrollArea();
                }
                class_310.method_1551().method_1507((class_437)this);
            });
            class_310.method_1551().method_1507((class_437)s);
        });
        this.method_25429((class_364)this.addVariableButton);
        UIBase.applyDefaultWidgetSkinTo(this.addVariableButton);
        this.setValueButton = new ExtendedButton(0, 0, 220, 20, (class_2561)class_2561.method_43471((String)"fancymenu.overlay.menu_bar.variables.manage.set_value"), button -> {
            VariableScrollEntry e = this.getSelectedEntry();
            if (e != null) {
                TextInputScreen s = new TextInputScreen((class_2561)class_2561.method_43471((String)"fancymenu.overlay.menu_bar.variables.manage.set_value"), null, call -> {
                    if (call != null) {
                        e.variable.setValue((String)call);
                    }
                    class_310.method_1551().method_1507((class_437)this);
                });
                s.setText(e.variable.getValue());
                class_310.method_1551().method_1507((class_437)s);
            }
        }).setIsActiveSupplier(consumes -> this.getSelectedEntry() != null);
        this.method_25429((class_364)this.setValueButton);
        UIBase.applyDefaultWidgetSkinTo(this.setValueButton);
        this.deleteVariableButton = new ExtendedButton(0, 0, 220, 20, (class_2561)class_2561.method_43471((String)"fancymenu.overlay.menu_bar.variables.manage.delete_variable"), button -> {
            VariableScrollEntry e = this.getSelectedEntry();
            if (e != null) {
                class_310.method_1551().method_1507((class_437)ConfirmationScreen.ofStrings(call -> {
                    if (call.booleanValue()) {
                        VariableHandler.removeVariable(e.variable.getName());
                        this.updateVariableScrollArea();
                    }
                    class_310.method_1551().method_1507((class_437)this);
                }, LocalizationUtils.splitLocalizedStringLines("fancymenu.overlay.menu_bar.variables.manage.delete_variable.confirm", new String[0])));
            }
        }).setIsActiveSupplier(consumes -> this.getSelectedEntry() != null);
        this.method_25429((class_364)this.deleteVariableButton);
        UIBase.applyDefaultWidgetSkinTo(this.deleteVariableButton);
        LocalizedEnumValueCycle<CommonCycles.CycleEnabledDisabled> resetOnLaunchDisabled = CommonCycles.cycleEnabledDisabled("fancymenu.overlay.menu_bar.variables.manage.clear_on_launch", false);
        this.toggleResetOnLaunchButton = new ExtendedButton(0, 0, 220, 20, (class_2561)class_2561.method_43473(), button -> {
            VariableScrollEntry e = this.getSelectedEntry();
            if (e != null) {
                e.variable.setResetOnLaunch(!e.variable.isResetOnLaunch());
            }
        }).setIsActiveSupplier(consumes -> this.getSelectedEntry() != null).setLabelSupplier(consumes -> {
            VariableScrollEntry e = this.getSelectedEntry();
            if (e != null) {
                LocalizedEnumValueCycle<CommonCycles.CycleEnabledDisabled> enabledDisabled = CommonCycles.cycleEnabledDisabled("fancymenu.overlay.menu_bar.variables.manage.clear_on_launch");
                enabledDisabled.setCurrentValue(CommonCycles.CycleEnabledDisabled.getByBoolean(e.variable.isResetOnLaunch()));
                return enabledDisabled.getCycleComponent();
            }
            return resetOnLaunchDisabled.getCycleComponent();
        });
        this.method_25429((class_364)this.toggleResetOnLaunchButton);
        UIBase.applyDefaultWidgetSkinTo(this.toggleResetOnLaunchButton);
        this.doneButton = new ExtendedButton(0, 0, 220, 20, (class_2561)class_2561.method_43471((String)"fancymenu.guicomponents.done"), button -> this.callback.accept(VariableHandler.getVariables()));
        this.method_25429((class_364)this.doneButton);
        UIBase.applyDefaultWidgetSkinTo(this.doneButton);
    }

    public void method_25419() {
        this.callback.accept(VariableHandler.getVariables());
    }

    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        RenderSystem.enableBlend();
        graphics.method_51739(class_1921.method_51785(), 0, 0, this.field_22789, this.field_22790, UIBase.getUIColorTheme().screen_background_color.getColorInt());
        class_5250 titleComp = this.field_22785.method_27661().method_27696(class_2583.field_24360.method_10982(Boolean.valueOf(true)));
        graphics.method_51439(this.field_22793, (class_2561)titleComp, 20, 20, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);
        graphics.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"fancymenu.overlay.menu_bar.variables.manage.variables"), 20, 50, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);
        this.variableListScrollArea.setWidth(this.field_22789 / 2 - 40, true);
        this.variableListScrollArea.setHeight(this.field_22790 - 85, true);
        this.variableListScrollArea.setX(20, true);
        this.variableListScrollArea.setY(65, true);
        this.variableListScrollArea.render(graphics, mouseX, mouseY, partial);
        int buttonWidth = this.field_22789 - 20 - (this.variableListScrollArea.getXWithBorder() + (this.variableListScrollArea.getWidthWithBorder() + 20));
        if (buttonWidth < 150) {
            buttonWidth = 150;
        }
        if (buttonWidth > 220) {
            buttonWidth = 220;
        }
        this.doneButton.method_25358(buttonWidth);
        this.doneButton.method_46421(this.field_22789 - 20 - this.doneButton.method_25368());
        this.doneButton.method_46419(this.field_22790 - 20 - 20);
        this.doneButton.method_25394(graphics, mouseX, mouseY, partial);
        this.toggleResetOnLaunchButton.method_25358(buttonWidth);
        this.toggleResetOnLaunchButton.method_46421(this.field_22789 - 20 - this.toggleResetOnLaunchButton.method_25368());
        this.toggleResetOnLaunchButton.method_46419(this.doneButton.method_46427() - 15 - 20);
        this.toggleResetOnLaunchButton.method_25394(graphics, mouseX, mouseY, partial);
        this.deleteVariableButton.method_25358(buttonWidth);
        this.deleteVariableButton.method_46421(this.field_22789 - 20 - this.deleteVariableButton.method_25368());
        this.deleteVariableButton.method_46419(this.toggleResetOnLaunchButton.method_46427() - 5 - 20);
        this.deleteVariableButton.method_25394(graphics, mouseX, mouseY, partial);
        this.setValueButton.method_25358(buttonWidth);
        this.setValueButton.method_46421(this.field_22789 - 20 - this.setValueButton.method_25368());
        this.setValueButton.method_46419(this.deleteVariableButton.method_46427() - 5 - 20);
        this.setValueButton.method_25394(graphics, mouseX, mouseY, partial);
        this.addVariableButton.method_25358(buttonWidth);
        this.addVariableButton.method_46421(this.field_22789 - 20 - this.addVariableButton.method_25368());
        this.addVariableButton.method_46419(this.setValueButton.method_46427() - 15 - 20);
        this.addVariableButton.method_25394(graphics, mouseX, mouseY, partial);
        super.method_25394(graphics, mouseX, mouseY, partial);
    }

    public void method_25420(@NotNull class_332 $$0, int $$1, int $$2, float $$3) {
    }

    @Nullable
    protected VariableScrollEntry getSelectedEntry() {
        for (ScrollAreaEntry e : this.variableListScrollArea.getEntries()) {
            VariableScrollEntry s;
            if (!(e instanceof VariableScrollEntry) || !(s = (VariableScrollEntry)e).isSelected()) continue;
            return s;
        }
        return null;
    }

    protected void updateVariableScrollArea() {
        this.variableListScrollArea.clearEntries();
        for (Variable v : VariableHandler.getVariables()) {
            VariableScrollEntry e = new VariableScrollEntry(this.variableListScrollArea, v, entry -> {});
            this.variableListScrollArea.addEntry(e);
        }
        if (this.variableListScrollArea.getEntries().isEmpty()) {
            this.variableListScrollArea.addEntry(new TextScrollAreaEntry(this.variableListScrollArea, (class_2561)class_2561.method_43471((String)"fancymenu.overlay.menu_bar.variables.manage.no_variables").method_10862(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().error_text_color.getColorInt())), entry -> {}));
        }
    }

    public static class VariableScrollEntry
    extends TextListScrollAreaEntry {
        public Variable variable;

        public VariableScrollEntry(ScrollArea parent, @NotNull Variable variable, @NotNull Consumer<TextListScrollAreaEntry> onClick) {
            super(parent, (class_2561)class_2561.method_43470((String)variable.name).method_10862(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().description_area_text_color.getColorInt())), UIBase.getUIColorTheme().listing_dot_color_1.getColor(), onClick);
            this.variable = variable;
        }
    }
}

