/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.placeholder.placeholders.advanced;

import de.keksuccino.fancymenu.customization.placeholder.DeserializedPlaceholderString;
import de.keksuccino.fancymenu.customization.placeholder.Placeholder;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.SerializationUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.class_1074;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CropTextPlaceholder
extends Placeholder {
    private static final Logger LOGGER = LogManager.getLogger();

    public CropTextPlaceholder() {
        super("crop_text");
    }

    @Override
    public String getReplacementFor(DeserializedPlaceholderString dps) {
        try {
            String input = dps.values.get("text");
            int removeFromStart = SerializationUtils.deserializeNumber(Integer.class, -1, dps.values.get("remove_from_start"));
            int removeFromEnd = SerializationUtils.deserializeNumber(Integer.class, -1, dps.values.get("remove_from_end"));
            if (input != null) {
                if (input.length() <= removeFromStart) {
                    return "";
                }
                if (input.length() <= removeFromEnd) {
                    return "";
                }
                String sub1 = input.substring(removeFromStart);
                if (sub1.length() <= removeFromEnd) {
                    return "";
                }
                return sub1.substring(0, sub1.length() - removeFromEnd);
            }
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to parse 'Crop Text' placeholder!", (Throwable)ex);
        }
        return null;
    }

    @Override
    @Nullable
    public List<String> getValueNames() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("text");
        l.add("remove_from_start");
        l.add("remove_from_end");
        return l;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return class_1074.method_4662((String)"fancymenu.placeholders.crop_text", (Object[])new Object[0]);
    }

    @Override
    public List<String> getDescription() {
        return Arrays.asList(LocalizationUtils.splitLocalizedStringLines("fancymenu.placeholders.crop_text.desc", new String[0]));
    }

    @Override
    public String getCategory() {
        return class_1074.method_4662((String)"fancymenu.fancymenu.editor.dynamicvariabletextfield.categories.advanced", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public DeserializedPlaceholderString getDefaultPlaceholderString() {
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        m.put("text", "some text");
        m.put("remove_from_start", "0");
        m.put("remove_from_end", "0");
        return DeserializedPlaceholderString.build(this.getIdentifier(), m);
    }
}

