/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.element.elements.playerentity.v2;

import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.customization.element.elements.playerentity.v2.PlayerEntityRenderer;
import de.keksuccino.fancymenu.customization.element.elements.playerentity.v2.textures.CapeResourceSupplier;
import de.keksuccino.fancymenu.customization.element.elements.playerentity.v2.textures.SkinResourceSupplier;
import de.keksuccino.fancymenu.customization.placeholder.PlaceholderParser;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import java.awt.Color;
import java.util.Objects;
import net.minecraft.class_10055;
import net.minecraft.class_1453;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4597;
import net.minecraft.class_5348;
import net.minecraft.class_8685;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerEntityElement
extends AbstractElement {
    private static final Logger LOGGER = LogManager.getLogger();
    protected DrawableColor nameTagBackgroundColor = DrawableColor.BLACK;
    protected final class_10055 renderState = new class_10055();
    public final PlayerEntityRenderer normalRenderer = new PlayerEntityRenderer(false);
    public final PlayerEntityRenderer slimRenderer = new PlayerEntityRenderer(true);
    public volatile boolean copyClientPlayer = false;
    @NotNull
    public volatile String playerName = "Steve";
    public boolean showPlayerName = true;
    public boolean hasParrotOnShoulder = false;
    public boolean parrotOnLeftShoulder = false;
    public boolean crouching = false;
    public boolean isBaby = false;
    public String scale = "30";
    public boolean headFollowsMouse = true;
    public boolean bodyFollowsMouse = true;
    public volatile boolean slim = true;
    public volatile boolean autoSkin = false;
    public volatile boolean autoCape = false;
    @Nullable
    public SkinResourceSupplier skinTextureSupplier;
    @Nullable
    public CapeResourceSupplier capeTextureSupplier;
    public String bodyXRot;
    public String bodyYRot;
    public String headXRot;
    public String headYRot;
    public String headZRot;
    public String leftArmXRot;
    public String leftArmYRot;
    public String leftArmZRot;
    public String rightArmXRot;
    public String rightArmYRot;
    public String rightArmZRot;
    public String leftLegXRot;
    public String leftLegYRot;
    public String leftLegZRot;
    public String rightLegXRot;
    public String rightLegYRot;
    public String rightLegZRot;
    public boolean bodyXRotAdvancedMode;
    public boolean bodyYRotAdvancedMode;
    public boolean headXRotAdvancedMode;
    public boolean headYRotAdvancedMode;
    public boolean headZRotAdvancedMode;
    public boolean leftArmXRotAdvancedMode;
    public boolean leftArmYRotAdvancedMode;
    public boolean leftArmZRotAdvancedMode;
    public boolean rightArmXRotAdvancedMode;
    public boolean rightArmYRotAdvancedMode;
    public boolean rightArmZRotAdvancedMode;
    public boolean leftLegXRotAdvancedMode;
    public boolean leftLegYRotAdvancedMode;
    public boolean leftLegZRotAdvancedMode;
    public boolean rightLegXRotAdvancedMode;
    public boolean rightLegYRotAdvancedMode;
    public boolean rightLegZRotAdvancedMode;

    public PlayerEntityElement(@NotNull ElementBuilder<?, ?> builder) {
        super(builder);
        this.normalRenderer.playerState = this.renderState;
        this.slimRenderer.playerState = this.renderState;
    }

    @Override
    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        if (this.shouldRender() && PlayerEntityElement.isEditor()) {
            graphics.method_25294(this.getAbsoluteX(), this.getAbsoluteY(), this.getAbsoluteX() + this.getAbsoluteWidth(), this.getAbsoluteY() + this.getAbsoluteHeight(), Color.RED.getRGB());
            graphics.method_27534(class_310.method_1551().field_1772, (class_2561)class_2561.method_43470((String)"PLAYER ENTITY ELEMENT"), this.getAbsoluteX() + this.getAbsoluteWidth() / 2, this.getAbsoluteY() + this.getAbsoluteHeight() / 2 - 11, -1);
            graphics.method_27534(class_310.method_1551().field_1772, (class_2561)class_2561.method_43470((String)"TEMPORARILY REMOVED FROM FANCYMENU!"), this.getAbsoluteX() + this.getAbsoluteWidth() / 2, this.getAbsoluteY() + this.getAbsoluteHeight() / 2, -1);
            graphics.method_27534(class_310.method_1551().field_1772, (class_2561)class_2561.method_43470((String)"WILL GET ADDED BACK SOON!"), this.getAbsoluteX() + this.getAbsoluteWidth() / 2, this.getAbsoluteY() + this.getAbsoluteHeight() / 2 + 11, -1);
        }
    }

    protected void renderEntity(@NotNull class_332 graphics) {
        float scale = (float)this.getAbsoluteHeight() / 2.125f;
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416((float)this.getAbsoluteX() + (float)this.getAbsoluteWidth() / 2.0f, (float)(this.getAbsoluteY() + this.getAbsoluteHeight()), 100.0f);
        graphics.method_51448().method_22905(scale, scale, scale);
        graphics.method_51448().method_46416(0.0f, -0.0625f, 0.0f);
        graphics.method_51452();
        class_308.method_34742();
        graphics.method_51448().method_22903();
        graphics.method_51448().method_22905(1.0f, 1.0f, -1.0f);
        graphics.method_51448().method_46416(0.0f, -2.2515001f, 0.0f);
        graphics.method_64039(multiBufferSource -> this.getActiveRenderer().render(this.renderState, graphics.method_51448(), (class_4597)multiBufferSource, 0xF000F0));
        graphics.method_51448().method_22909();
        graphics.method_51452();
        class_308.method_24211();
        graphics.method_51448().method_22909();
    }

    protected void renderNameTag(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        if (!this.showPlayerName) {
            return;
        }
        class_2561 name = this.getDisplayName();
        class_327 font = class_310.method_1551().field_1772;
        float scale = 1.2f;
        int textWidth = (int)((float)font.method_27525((class_5348)name) * scale);
        Objects.requireNonNull(font);
        int textHeight = (int)(9.0f * scale);
        int headHeight = (int)((float)this.getAbsoluteHeight() * 0.3f);
        int nameTagOffsetY = 30 + headHeight / 2;
        int nameTagWidth = textWidth + 10;
        int nameTagHeight = textHeight + 6;
        int nameTagX = this.getAbsoluteX() + this.getAbsoluteWidth() / 2 - nameTagWidth / 2;
        int nameTagY = this.getAbsoluteY() + this.getAbsoluteHeight() / 2 - nameTagHeight - nameTagOffsetY;
        graphics.method_25294(nameTagX, nameTagY, nameTagX + nameTagWidth, nameTagY + nameTagHeight, this.nameTagBackgroundColor.getColorIntWithAlpha(0.3f));
        graphics.method_51448().method_22903();
        graphics.method_51448().method_22905(scale, scale, scale);
        graphics.method_51439(font, name, (int)((float)nameTagX / scale) + 5, (int)((float)nameTagY / scale) + 3, -1, true);
        graphics.method_51448().method_22909();
    }

    @Override
    @NotNull
    public class_2561 getDisplayName() {
        return PlayerEntityElement.buildComponent(this.playerName);
    }

    protected float stringToFloat(@Nullable String s) {
        if (s == null) {
            return 0.0f;
        }
        s = PlaceholderParser.replacePlaceholders(s);
        s = s.replace(" ", "");
        try {
            return Float.parseFloat(s);
        }
        catch (Exception exception) {
            return 0.0f;
        }
    }

    public void setCopyClientPlayer(boolean copyClientPlayer) {
        if (copyClientPlayer) {
            this.copyClientPlayer = true;
            this.autoCape = false;
            this.autoSkin = false;
            this.slim = false;
            this.setPlayerName(class_310.method_1551().method_1548().method_1676());
            this.setSkinByPlayerName();
            this.setCapeByPlayerName();
        } else {
            this.copyClientPlayer = false;
            this.skinTextureSupplier = null;
            this.capeTextureSupplier = null;
        }
    }

    public void setPlayerName(@Nullable String playerName) {
        if (playerName == null) {
            playerName = "Steve";
        }
        this.playerName = playerName;
    }

    public void setShowPlayerName(boolean showName) {
        this.showPlayerName = showName;
    }

    public void setHasParrotOnShoulder(boolean hasParrot, boolean onLeftShoulder) {
        this.hasParrotOnShoulder = hasParrot;
        this.parrotOnLeftShoulder = onLeftShoulder;
        this.updateParrotOnShoulder();
    }

    public void updateParrotOnShoulder() {
        class_1453.class_7989 variantRight;
        class_1453.class_7989 variantLeft = this.parrotOnLeftShoulder ? class_1453.class_7989.field_41550 : null;
        class_1453.class_7989 class_79892 = variantRight = this.parrotOnLeftShoulder ? null : class_1453.class_7989.field_41550;
        if (!this.hasParrotOnShoulder) {
            variantLeft = null;
            variantRight = null;
        }
        this.normalRenderer.leftShoulderParrot = variantLeft;
        this.normalRenderer.rightShoulderParrot = variantRight;
        this.slimRenderer.leftShoulderParrot = variantLeft;
        this.slimRenderer.rightShoulderParrot = variantRight;
    }

    public void setCrouching(boolean crouching) {
        this.crouching = crouching;
        this.normalRenderer.isCrouching = crouching;
        this.slimRenderer.isCrouching = crouching;
    }

    public void setIsBaby(boolean isBaby) {
        this.isBaby = isBaby;
        this.normalRenderer.isBaby = isBaby;
        this.slimRenderer.isBaby = isBaby;
    }

    public void setCapeByPlayerName() {
        this.capeTextureSupplier = new CapeResourceSupplier(this.playerName, true);
    }

    public void setSkinByPlayerName() {
        this.skinTextureSupplier = new SkinResourceSupplier(this.playerName, true);
    }

    public void setSkinBySource(@NotNull String resourceSource) {
        this.skinTextureSupplier = new SkinResourceSupplier(resourceSource, false);
    }

    public void setCapeBySource(@NotNull String resourceSource) {
        this.capeTextureSupplier = new CapeResourceSupplier(resourceSource, false);
    }

    protected void updatePose(int mouseX, int mouseY) {
        float f = (float)(this.getAbsoluteX() + (this.getAbsoluteX() + this.getAbsoluteWidth())) / 2.0f;
        float g = (float)(this.getAbsoluteY() + (this.getAbsoluteY() + this.getAbsoluteHeight())) / 2.0f;
        float h = (float)Math.atan((f - (float)mouseX) / 40.0f);
        float i = (float)Math.atan((g - (float)mouseY) / 40.0f);
        if (this.bodyFollowsMouse) {
            this.getActiveRenderer().bodyXRot = -((float)Math.toRadians(h * 20.0f));
            this.getActiveRenderer().bodyYRot = (float)Math.PI + (float)Math.toRadians(-i * 20.0f);
        } else {
            this.getActiveRenderer().bodyXRot = (float)Math.toRadians(this.stringToFloat(this.bodyXRot));
            this.getActiveRenderer().bodyYRot = (float)Math.PI + (float)Math.toRadians(this.stringToFloat(this.bodyYRot));
        }
        if (this.headFollowsMouse) {
            this.getActiveRenderer().headXRot = (float)Math.toRadians(h * 20.0f);
            this.getActiveRenderer().headYRot = (float)Math.toRadians(-i * 20.0f);
            this.getActiveRenderer().headZRot = 0.0f;
        } else {
            this.getActiveRenderer().headXRot = (float)Math.toRadians(this.stringToFloat(this.headXRot));
            this.getActiveRenderer().headYRot = (float)Math.toRadians(this.stringToFloat(this.headYRot));
            this.getActiveRenderer().headZRot = (float)Math.toRadians(this.stringToFloat(this.headZRot));
        }
        this.getActiveRenderer().leftArmXRot = (float)Math.toRadians(this.stringToFloat(this.leftArmXRot));
        this.getActiveRenderer().leftArmYRot = (float)Math.toRadians(this.stringToFloat(this.leftArmYRot));
        this.getActiveRenderer().leftArmZRot = (float)Math.toRadians(this.stringToFloat(this.leftArmZRot));
        this.getActiveRenderer().rightArmXRot = (float)Math.toRadians(this.stringToFloat(this.rightArmXRot));
        this.getActiveRenderer().rightArmYRot = (float)Math.toRadians(this.stringToFloat(this.rightArmYRot));
        this.getActiveRenderer().rightArmZRot = (float)Math.toRadians(this.stringToFloat(this.rightArmZRot));
        this.getActiveRenderer().leftLegXRot = (float)Math.toRadians(this.stringToFloat(this.leftLegXRot));
        this.getActiveRenderer().leftLegYRot = (float)Math.toRadians(this.stringToFloat(this.leftLegYRot));
        this.getActiveRenderer().leftLegZRot = (float)Math.toRadians(this.stringToFloat(this.leftLegZRot));
        this.getActiveRenderer().rightLegXRot = (float)Math.toRadians(this.stringToFloat(this.rightLegXRot));
        this.getActiveRenderer().rightLegYRot = (float)Math.toRadians(this.stringToFloat(this.rightLegYRot));
        this.getActiveRenderer().rightLegZRot = (float)Math.toRadians(this.stringToFloat(this.rightLegZRot));
    }

    protected class_8685 updateSkinAndCape() {
        class_8685 skin;
        if (this.copyClientPlayer || this.autoSkin) {
            boolean bl = this.slim = this.skinTextureSupplier == null || this.skinTextureSupplier.isSlimPlayerNameSkin();
        }
        if (this.capeTextureSupplier != null && this.capeTextureSupplier.hasNoCape()) {
            this.capeTextureSupplier = null;
        }
        class_2960 skinLoc = this.skinTextureSupplier != null ? this.skinTextureSupplier.getSkinLocation() : SkinResourceSupplier.DEFAULT_SKIN_LOCATION;
        class_2960 capeLoc = null;
        if (this.capeTextureSupplier != null && !this.capeTextureSupplier.hasNoCape() && (capeLoc = this.capeTextureSupplier.getCapeLocation()) == CapeResourceSupplier.DEFAULT_CAPE_LOCATION) {
            capeLoc = null;
        }
        this.normalRenderer.skin = skin = new class_8685(skinLoc, null, capeLoc, null, this.slim ? class_8685.class_7920.field_41122 : class_8685.class_7920.field_41123, true);
        this.slimRenderer.skin = skin;
        return skin;
    }

    @NotNull
    public PlayerEntityRenderer getActiveRenderer() {
        if (this.slim) {
            return this.slimRenderer;
        }
        return this.normalRenderer;
    }
}

