/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.element.elements.browser;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.customization.customgui.CustomGuiBaseScreen;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.customization.placeholder.PlaceholderParser;
import de.keksuccino.fancymenu.util.mcef.BrowserHandler;
import de.keksuccino.fancymenu.util.mcef.MCEFUtil;
import de.keksuccino.fancymenu.util.mcef.WrappedMCEFBrowser;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.konkrete.input.MouseInput;
import java.awt.Color;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BrowserElement
extends AbstractElement {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final DrawableColor ERROR_BACKGROUND_COLOR = DrawableColor.of(Color.RED);
    @NotNull
    public String url = "https://docs.fancymenu.net";
    public boolean interactable = true;
    public boolean hideVideoControls = false;
    public boolean loopVideos = false;
    public boolean muteMedia = false;
    public float mediaVolume = 1.0f;
    @Nullable
    public WrappedMCEFBrowser browser = null;
    public int lastTickWidth = -1;
    public int lastTickHeight = -1;
    public long lastLeftClickTime = -1L;

    public BrowserElement(@NotNull ElementBuilder<?, ?> builder) {
        super(builder);
    }

    @Override
    public void afterConstruction() {
        if (MCEFUtil.isMCEFLoaded()) {
            this.browser = BrowserHandler.get(this.getInstanceIdentifier());
            if (this.browser == null) {
                this.browser = WrappedMCEFBrowser.build(PlaceholderParser.replacePlaceholders(this.url), true, false);
            }
            BrowserHandler.notifyHandler(this.getInstanceIdentifier(), this.browser);
        }
    }

    @Override
    public void onCloseScreen(@Nullable class_437 closedScreen, @Nullable class_437 newScreen) {
        if (closedScreen != null && newScreen != null) {
            boolean bothCustomGuis;
            boolean bl = bothCustomGuis = closedScreen instanceof CustomGuiBaseScreen && newScreen instanceof CustomGuiBaseScreen;
            if (closedScreen instanceof CustomGuiBaseScreen) {
                CustomGuiBaseScreen c1 = (CustomGuiBaseScreen)closedScreen;
                if (newScreen instanceof CustomGuiBaseScreen) {
                    CustomGuiBaseScreen c2 = (CustomGuiBaseScreen)newScreen;
                    if (c1.getIdentifier().equals(c2.getIdentifier())) {
                        return;
                    }
                }
            }
            if (!bothCustomGuis && closedScreen.getClass() == newScreen.getClass()) {
                return;
            }
        }
        if (this.browser != null) {
            BrowserHandler.remove(this.getInstanceIdentifier(), true);
        }
    }

    @Override
    @Nullable
    public List<class_364> getWidgetsToRegister() {
        if (this.browser == null) {
            return null;
        }
        return List.of(this.browser);
    }

    @Override
    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        if (this.shouldRender()) {
            int x = this.getAbsoluteX();
            int y = this.getAbsoluteY();
            int w = this.getAbsoluteWidth();
            int h = this.getAbsoluteHeight();
            if (this.browser != null) {
                BrowserHandler.notifyHandler(this.getInstanceIdentifier(), this.browser);
                if (!this.browser.isHideVideoControls() && this.hideVideoControls) {
                    this.browser.setHideVideoControls(true);
                }
                if (this.browser.isHideVideoControls() && !this.hideVideoControls) {
                    this.browser.setHideVideoControls(false);
                }
                if (!this.browser.isLoopAllVideos() && this.loopVideos) {
                    this.browser.setLoopAllVideos(true);
                }
                if (this.browser.isLoopAllVideos() && !this.loopVideos) {
                    this.browser.setLoopAllVideos(false);
                }
                if (!this.browser.isMuteAllMediaOnLoad() && this.muteMedia) {
                    this.browser.setMuteAllMediaOnLoad(true);
                }
                if (this.browser.isMuteAllMediaOnLoad() && !this.muteMedia) {
                    this.browser.setMuteAllMediaOnLoad(false);
                }
                if (this.mediaVolume > 1.0f) {
                    this.mediaVolume = 1.0f;
                }
                if (this.mediaVolume < 0.0f) {
                    this.mediaVolume = 0.0f;
                }
                if (this.browser.getVolume() != this.mediaVolume) {
                    this.browser.setVolume(this.mediaVolume);
                }
                this.browser.setOpacity(this.opacity);
                this.browser.method_48229(x, y);
                if (this.lastTickWidth != w || this.lastTickHeight != h) {
                    this.browser.method_55445(w, h);
                }
                this.lastTickWidth = w;
                this.lastTickHeight = h;
                String finalUrl = PlaceholderParser.replacePlaceholders(this.url);
                if (!finalUrl.equals(this.getLastTickUrl())) {
                    this.browser.setUrl(finalUrl);
                    this.setLastTickUrl(finalUrl);
                }
                this.browser.setInteractable(this.interactable && !BrowserElement.isEditor());
                RenderSystem.enableBlend();
                this.browser.method_25394(graphics, mouseX, mouseY, partial);
                if (BrowserElement.isEditor()) {
                    if (MouseInput.isLeftMouseDown() && this.browser.method_25405(mouseX, mouseY)) {
                        this.lastLeftClickTime = System.currentTimeMillis();
                    }
                    if (this.lastLeftClickTime + 5000L > System.currentTimeMillis()) {
                        graphics.method_25294(x, y, x + w, y + h, ERROR_BACKGROUND_COLOR.getColorIntWithAlpha(0.4f));
                        class_327 class_3272 = class_310.method_1551().field_1772;
                        class_5250 class_52502 = class_2561.method_43471((String)"fancymenu.elements.browser.disabled_in_editor").method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)));
                        int n = x + w / 2;
                        int n2 = y + h / 2;
                        Objects.requireNonNull(class_310.method_1551().field_1772);
                        graphics.method_27534(class_3272, (class_2561)class_52502, n, n2 - 9 / 2, -1);
                        graphics.method_51452();
                    }
                }
            } else {
                RenderSystem.enableBlend();
                graphics.method_51739(class_1921.method_51785(), x, y, x + w, y + h, ERROR_BACKGROUND_COLOR.getColorInt());
                class_327 class_3273 = class_310.method_1551().field_1772;
                class_5250 class_52503 = class_2561.method_43471((String)"fancymenu.elements.browser.mcef_not_loaded.line_1").method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)));
                int n = x + w / 2;
                int n3 = y + h / 2;
                Objects.requireNonNull(class_310.method_1551().field_1772);
                graphics.method_27534(class_3273, (class_2561)class_52503, n, n3 - 9 - 2, -1);
                graphics.method_27534(class_310.method_1551().field_1772, (class_2561)class_2561.method_43471((String)"fancymenu.elements.browser.mcef_not_loaded.line_2").method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true))), x + w / 2, y + h / 2 + 2, -1);
            }
        }
    }

    @Nullable
    public String getLastTickUrl() {
        return this.getMemory().getStringProperty("last_tick_url");
    }

    public void setLastTickUrl(@Nullable String url) {
        this.getMemory().putProperty("last_tick_url", url);
    }
}

