/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.action.actions.other;

import de.keksuccino.fancymenu.customization.action.Action;
import de.keksuccino.fancymenu.customization.action.ActionInstance;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.minecraftoptions.MinecraftOption;
import de.keksuccino.fancymenu.util.minecraftoptions.MinecraftOptions;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.screen.CellScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.StringBuilderScreen;
import de.keksuccino.fancymenu.util.rendering.ui.widget.editbox.EditBoxSuggestions;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditMinecraftOptionAction
extends Action {
    private static final Logger LOGGER = LogManager.getLogger();

    public EditMinecraftOptionAction() {
        super("edit_minecraft_option");
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public void execute(@Nullable String value) {
        if (value != null && value.contains(":")) {
            String name = value.split(":", 2)[0];
            String setTo = value.split(":", 2)[1];
            MinecraftOption instance = MinecraftOptions.getOption(name);
            if (instance == null) {
                LOGGER.error("[FANCYMENU] EditMinecraftOptionAction was unable to find Minecraft config option: " + name);
                return;
            }
            try {
                instance.set(setTo);
                class_310.method_1551().field_1690.method_1640();
            }
            catch (Exception ex) {
                LOGGER.error("[FANCYMENU] EditMinecraftOptionAction failed to set Minecraft config option value '" + setTo + "' to option '" + name + "'.", (Throwable)ex);
            }
        }
    }

    @NotNull
    protected static List<String> getSupportedOptionNames() {
        ArrayList<String> names = new ArrayList<String>();
        MinecraftOptions.getOptions().values().forEach(optionInstance -> names.add(optionInstance.getName()));
        if (names.isEmpty()) {
            names.add("[ERROR: UNABLE TO GET OPTION NAMES!]");
        }
        return names;
    }

    @Override
    @NotNull
    public class_2561 getActionDisplayName() {
        return class_2561.method_43471((String)"fancymenu.actions.edit_minecraft_option");
    }

    @Override
    @NotNull
    public class_2561[] getActionDescription() {
        return LocalizationUtils.splitLocalizedLines("fancymenu.actions.edit_minecraft_option.desc", new String[0]);
    }

    @Override
    public class_2561 getValueDisplayName() {
        return class_2561.method_43473();
    }

    @Override
    public String getValueExample() {
        return "option_name:set_to_value";
    }

    @Override
    public void editValue(@NotNull class_437 parentScreen, @NotNull ActionInstance instance) {
        EditMinecraftOptionActionValueScreen s = new EditMinecraftOptionActionValueScreen(Objects.requireNonNullElse(instance.value, this.getValueExample()), value -> {
            if (value != null) {
                instance.value = value;
            }
            class_310.method_1551().method_1507(parentScreen);
        });
        class_310.method_1551().method_1507((class_437)s);
    }

    public static class EditMinecraftOptionActionValueScreen
    extends StringBuilderScreen {
        @NotNull
        protected String name = "";
        @NotNull
        protected String setTo = "";
        protected EditBoxSuggestions optionNameSuggestions;
        @Nullable
        protected CellScreen.LabelCell currentOptionValueLabelCell = null;

        protected EditMinecraftOptionActionValueScreen(@NotNull String value, @NotNull Consumer<String> callback) {
            super((class_2561)class_2561.method_43471((String)"fancymenu.editor.actions.generic_edit_value"), callback);
            if (value.contains(":")) {
                this.name = value.split(":", 2)[0];
                this.setTo = value.split(":", 2)[1];
            }
        }

        @Override
        protected void initCells() {
            this.addStartEndSpacerCell();
            this.addLabelCell((class_2561)class_2561.method_43471((String)"fancymenu.actions.edit_minecraft_option.edit.option_name"));
            CellScreen.TextInputCell nameCell = this.addTextInputCell(null, true, true).setText(this.name);
            this.optionNameSuggestions = EditBoxSuggestions.createWithCustomSuggestions(this, nameCell.editBox, EditBoxSuggestions.SuggestionsRenderPosition.ABOVE_EDIT_BOX, EditMinecraftOptionAction.getSupportedOptionNames());
            UIBase.applyDefaultWidgetSkinTo(this.optionNameSuggestions);
            nameCell.editBox.method_1863(s -> {
                this.optionNameSuggestions.method_23934();
                this.name = s;
                if (this.currentOptionValueLabelCell != null) {
                    this.currentOptionValueLabelCell.setText(this.buildCurrentOptionValueComponent());
                }
            });
            this.addCellGroupEndSpacerCell();
            this.addLabelCell((class_2561)class_2561.method_43471((String)"fancymenu.actions.edit_minecraft_option.edit.set_to_value"));
            this.addTextInputCell(null, true, true).setEditListener(s -> {
                this.setTo = s;
            }).setText(this.setTo);
            this.addCellGroupEndSpacerCell();
            this.currentOptionValueLabelCell = this.addLabelCell(this.buildCurrentOptionValueComponent());
            this.addSpacerCell(20);
        }

        @NotNull
        protected class_2561 buildCurrentOptionValueComponent() {
            String current;
            MinecraftOption instance = MinecraftOptions.getOption(this.name);
            String string = current = instance != null ? instance.get() : "-----";
            if (current == null) {
                current = "-----";
            }
            class_5250 curComp = class_2561.method_43470((String)current).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(false)));
            return class_2561.method_43469((String)"fancymenu.actions.edit_minecraft_option.edit.current_value", (Object[])new Object[]{curComp}).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)));
        }

        @Override
        public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
            super.method_25394(graphics, mouseX, mouseY, partial);
            this.optionNameSuggestions.method_23923(graphics, mouseX, mouseY);
        }

        @Override
        public boolean method_25404(int $$0, int $$1, int $$2) {
            if (this.optionNameSuggestions.method_23924($$0, $$1, $$2)) {
                return true;
            }
            return super.method_25404($$0, $$1, $$2);
        }

        public boolean method_25401(double $$0, double $$1, double scrollDeltaX, double scrollDeltaY) {
            if (this.optionNameSuggestions.method_23921(scrollDeltaY)) {
                return true;
            }
            return super.method_25401($$0, $$1, scrollDeltaX, scrollDeltaY);
        }

        @Override
        public boolean method_25402(double $$0, double $$1, int $$2) {
            if (this.optionNameSuggestions.method_23922($$0, $$1, $$2)) {
                return true;
            }
            return super.method_25402($$0, $$1, $$2);
        }

        @Override
        @NotNull
        public String buildString() {
            return this.name + ":" + this.setTo;
        }
    }
}

