/*
 * Decompiled with CFR 0.152.
 */
package dev.notalpha.dashloader.misc;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Objects;
import net.minecraft.class_2477;
import net.minecraft.class_310;

public class TranslationHelper {
    private static final TranslationHelper INSTANCE = new TranslationHelper();
    private final HashMap<String, String> translations = new HashMap();
    private String langCode;

    private TranslationHelper() {
    }

    public static TranslationHelper getInstance() {
        String langCode = class_310.method_1551().method_1526().method_4669();
        if (!Objects.equals(TranslationHelper.INSTANCE.langCode, langCode)) {
            TranslationHelper.INSTANCE.langCode = langCode;
            INSTANCE.loadLang(langCode);
        }
        return INSTANCE;
    }

    private void loadLang(String langCode) {
        this.langCode = langCode;
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream("dashloader/lang/" + langCode + ".json");
        if (stream != null) {
            class_2477.method_29425((InputStream)stream, this.translations::put);
        } else {
            stream = this.getClass().getClassLoader().getResourceAsStream("dashloader/lang/en_us.json");
            if (stream != null) {
                class_2477.method_29425((InputStream)stream, this.translations::put);
            }
        }
    }

    public String get(String text) {
        return this.translations.getOrDefault(text, text);
    }

    public boolean has(String key) {
        return this.translations.containsKey(key);
    }
}

