/*
 * Decompiled with CFR 0.152.
 */
package dev.notalpha.dashloader.misc;

import java.lang.reflect.Field;
import java.lang.reflect.InaccessibleObjectException;
import java.lang.runtime.SwitchBootstraps;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_1011;
import org.apache.commons.lang3.builder.MultilineRecursiveToStringStyle;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class ObjectDumper {
    public static String dump(Object object) {
        return ReflectionToStringBuilder.toString((Object)object, (ToStringStyle)new Style());
    }

    private static final class Style
    extends MultilineRecursiveToStringStyle {
        public Style() {
            this.setFieldNameValueSeparator(": ");
            this.setUseIdentityHashCode(false);
            this.setUseShortClassName(true);
        }

        public void appendDetail(StringBuffer buffer, String fieldName, Object value) {
            try {
                if (value == null) {
                    buffer.append(fieldName).append("null");
                    return;
                }
                if (Objects.equals(fieldName, "glRef")) {
                    buffer.append("<id>");
                    return;
                }
                Object object = value;
                Objects.requireNonNull(object);
                Object object2 = object;
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ThreadLocal.class, HashMap.class, ArrayList.class, class_1011.class, IntBuffer.class, FloatBuffer.class, ByteBuffer.class, Enum.class}, (Object)object2, n)) {
                    case 0: {
                        ThreadLocal local = (ThreadLocal)object2;
                        this.appendDetail(buffer, fieldName, local.get());
                        break;
                    }
                    case 1: {
                        HashMap map = (HashMap)object2;
                        this.appendDetail(buffer, fieldName, map);
                        break;
                    }
                    case 2: {
                        ArrayList list = (ArrayList)object2;
                        this.appendDetail(buffer, fieldName, list);
                        break;
                    }
                    case 3: {
                        class_1011 image = (class_1011)object2;
                        buffer.append("Image{ format: ").append(image.method_4318()).append(", size: ").append(image.method_4307()).append("x").append(image.method_4323()).append(" }");
                        break;
                    }
                    case 4: {
                        IntBuffer buffer1 = (IntBuffer)object2;
                        this.appendBuff(buffer, buffer1, buffer1::get);
                        break;
                    }
                    case 5: {
                        FloatBuffer buffer1 = (FloatBuffer)object2;
                        this.appendBuff(buffer, buffer1, buffer1::get);
                        break;
                    }
                    case 6: {
                        ByteBuffer buffer1 = (ByteBuffer)object2;
                        this.appendBuff(buffer, buffer1, buffer1::get);
                        break;
                    }
                    case 7: {
                        Enum enumValue = (Enum)object2;
                        buffer.append(enumValue.name());
                        break;
                    }
                    default: {
                        this.fallback(buffer, fieldName, value);
                        break;
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(value == null ? "null" : value.toString(), e);
            }
        }

        private void fallback(StringBuffer buffer, String fieldName, Object value) {
            try {
                StringBuffer builder = new StringBuffer();
                super.appendDetail(builder, fieldName, value);
                String s = builder.toString();
                String result = s.split("@")[0];
                buffer.append(result);
            }
            catch (InaccessibleObjectException e) {
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace();
                buffer.append("unknown");
                try {
                    Field spaces = MultilineRecursiveToStringStyle.class.getDeclaredField("spaces");
                    spaces.setAccessible(true);
                    spaces.setInt((Object)this, spaces.getInt((Object)this) - 2);
                }
                catch (IllegalAccessException | NoSuchFieldException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }

        private void appendBuff(StringBuffer buffer, Buffer buff, Supplier<?> supplier) {
            buffer.append(buff.getClass().getSimpleName());
            buffer.append("[ ");
            int limit = buff.limit();
            if (limit < 50) {
                buff.rewind();
                for (int i = 0; i < limit; ++i) {
                    buffer.append(supplier.get());
                    buffer.append(", ");
                }
            } else {
                buffer.append("... ");
            }
            buffer.append("] limit: ");
            buffer.append(buff.limit());
        }

        protected void appendDetail(StringBuffer buffer, String fieldName, Map<?, ?> map) {
            buffer.append(this.getArrayStart());
            ArrayList entries = new ArrayList(map.entrySet());
            entries.sort((o1, o2) -> o1.getKey().toString().compareTo(o2.toString()));
            entries.forEach(entry -> {
                buffer.append(this.getArraySeparator());
                this.appendDetail(buffer, String.valueOf(entry.getKey()), entry.getValue());
            });
            buffer.append(this.getArrayEnd());
        }

        protected void appendIdentityHashCode(StringBuffer buffer, Object object) {
        }
    }
}

