/*
 * Decompiled with CFR 0.152.
 */
package dev.notalpha.dashloader.client.ui.toast;

import dev.notalpha.dashloader.client.ui.Color;
import dev.notalpha.dashloader.client.ui.DrawerUtil;
import dev.notalpha.dashloader.client.ui.toast.DashToastState;
import dev.notalpha.dashloader.client.ui.toast.DashToastStatus;
import dev.notalpha.dashloader.misc.HahaManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.class_1921;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_368;
import net.minecraft.class_374;
import net.minecraft.class_4588;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;

public class DashToast
implements class_368 {
    private static final int PROGRESS_BAR_HEIGHT = 2;
    private static final int PADDING = 8;
    private static final int LINES = 125;
    public final DashToastState state;
    private final Random random = new Random();
    @Nullable
    private final String fact = HahaManager.getFact();
    private List<Line> lines = new ArrayList<Line>();
    private long oldTime = System.currentTimeMillis();
    private float progress = 0.0f;
    private Color progressColor = DrawerUtil.getProgressColor(this.progress);
    private class_368.class_369 visibility;

    public DashToast() {
        this.state = new DashToastState();
        for (int i = 0; i < 125; ++i) {
            this.lines.add(new Line());
        }
    }

    private static void drawVertex(Matrix4f m4f, class_4588 consumer, float z, float x, float y, Color color) {
        consumer.method_22918(m4f, x, y, z).method_1336(color.red(), color.green(), color.blue(), color.alpha());
    }

    public int method_29049() {
        return 200;
    }

    public int method_29050() {
        return 40;
    }

    public class_368.class_369 method_61988() {
        return this.visibility;
    }

    public void method_61989(class_374 manager, long time) {
        if (this.state.getStatus() == DashToastStatus.CRASHED) {
            this.progress = (float)this.state.getProgress();
            this.progressColor = DrawerUtil.FAILED_COLOR;
        } else {
            this.progress = (float)this.state.getProgress();
            this.progressColor = DrawerUtil.getProgressColor(this.progress);
        }
        this.visibility = this.state.getStatus() == DashToastStatus.CRASHED && System.currentTimeMillis() - this.state.getTimeDone() > 10000L ? class_368.class_369.field_2209 : (this.state.getStatus() == DashToastStatus.DONE && System.currentTimeMillis() - this.state.getTimeDone() > 2000L ? class_368.class_369.field_2209 : class_368.class_369.field_2210);
    }

    public void method_1986(class_332 context, class_327 textRenderer, long startTime) {
        int n;
        int width = this.method_29049();
        int height = this.method_29050();
        int barY = height - 2;
        ArrayList<Line> newList = new ArrayList<Line>();
        ArrayList<Line> newListPrio = new ArrayList<Line>();
        long currentTime = System.currentTimeMillis();
        for (Line line : this.lines) {
            if (line.tick(width, height, this.progress, (float)(currentTime - this.oldTime) / 17.0f)) {
                newListPrio.add(line);
                continue;
            }
            newList.add(line);
        }
        this.oldTime = currentTime;
        this.lines = newList;
        this.lines.addAll(newListPrio);
        Vector4f vec = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
        vec.mul((Matrix4fc)context.method_51448().method_23760().method_23761());
        context.method_44379((int)vec.x, (int)vec.y, (int)(vec.x + (float)width), (int)(vec.y + (float)height));
        DrawerUtil.drawRect(context, 0, 0, width, height, DrawerUtil.BACKGROUND_COLOR);
        this.drawRaw(context, (matrix4f, consumer) -> {
            for (Line line : this.lines) {
                line.draw((Matrix4f)matrix4f, (class_4588)consumer);
            }
        });
        String progressText = this.state.getProgressText();
        if (this.fact != null) {
            n = barY - 8;
        } else {
            int n2 = barY / 2;
            Objects.requireNonNull(textRenderer);
            n = n2 + 9 / 2;
        }
        int progressTextY = n;
        DrawerUtil.drawText(context, textRenderer, 8, progressTextY, this.state.getText(), DrawerUtil.STATUS_COLOR);
        DrawerUtil.drawText(context, textRenderer, width - 8 - textRenderer.method_1727(progressText), progressTextY, progressText, DrawerUtil.STATUS_COLOR);
        if (this.fact != null) {
            Objects.requireNonNull(textRenderer);
            DrawerUtil.drawText(context, textRenderer, 8, 9 + 8, this.fact, DrawerUtil.FOREGROUND_COLOR);
        }
        DrawerUtil.drawRect(context, 0, barY, width, 2, DrawerUtil.PROGRESS_TRACK);
        DrawerUtil.drawRect(context, 0, barY, (int)((float)width * this.progress), 2, this.progressColor);
        this.drawRaw(context, (matrix4f, consumer) -> {
            for (Line line : this.lines) {
                line.drawGlow((Matrix4f)matrix4f, (class_4588)consumer);
            }
            DrawerUtil.drawGlow(matrix4f, consumer, 0.0f, barY, (int)((float)width * this.progress), 2.0f, 0.75f, this.progressColor, true, true, true, true);
        });
        context.method_44380();
    }

    private void drawRaw(class_332 context, BiConsumer<Matrix4f, class_4588> consumer) {
        Matrix4f matrix = context.method_51448().method_23760().method_23761();
        class_4588 vertexConsumer = context.field_44658.getBuffer(class_1921.method_51784());
        consumer.accept(matrix, vertexConsumer);
    }

    private final class Line {
        public final int width;
        public final int height;
        public ColorKind colorKind;
        public float x = -1000.0f;
        public float y = -1000.0f;
        public float speedBoost;
        private Color color;

        public Line() {
            this.width = DashToast.this.random.nextInt(30, 50);
            this.height = DashToast.this.random.nextInt(2, 5);
            this.colorKind = ColorKind.Neutral;
            this.color = new Color(-16776961);
        }

        public boolean tick(int screenWidth, int screenHeight, float progress, float delta) {
            this.x += (float)((double)this.speedBoost * (0.8 + 2.5 * (double)progress)) * delta;
            if (this.x > (float)screenWidth || this.x + (float)this.width < 0.0f) {
                this.x = -this.width;
                this.y = (float)screenHeight * DashToast.this.random.nextFloat();
                if (DashToast.this.state.getStatus() == DashToastStatus.CRASHED) {
                    if ((double)DashToast.this.random.nextFloat() > 0.9 || this.colorKind == ColorKind.Progress) {
                        this.colorKind = ColorKind.Crashed;
                    }
                } else {
                    this.colorKind = (double)DashToast.this.random.nextFloat() > 0.95 ? ColorKind.Progress : ColorKind.Neutral;
                }
                float weight = 1.0f - this.getWeight();
                float weightSpeed = (float)(0.7 + (double)weight * 0.6);
                float kindSpeed = this.colorKind == ColorKind.Neutral ? (float)(1.0 + (double)(DashToast.this.random.nextFloat() * 0.2f)) : (float)(1.0 + (double)(DashToast.this.random.nextFloat() * 0.8f));
                this.speedBoost = kindSpeed * weightSpeed;
                return this.colorKind != ColorKind.Neutral;
            }
            this.color = this.getColor(progress);
            return false;
        }

        public void draw(Matrix4f b4, class_4588 c) {
            Color end = DrawerUtil.withOpacity(this.color, 0.0f);
            DashToast.drawVertex(b4, c, 0.0f, this.x + (float)this.width, this.y, this.color);
            DashToast.drawVertex(b4, c, 0.0f, this.x, this.y, end);
            DashToast.drawVertex(b4, c, 0.0f, this.x, this.y + (float)this.height, end);
            DashToast.drawVertex(b4, c, 0.0f, this.x + (float)this.width, this.y + (float)this.height, this.color);
        }

        public void drawGlow(Matrix4f b4, class_4588 c) {
            if (this.colorKind != ColorKind.Neutral) {
                DrawerUtil.drawGlow(b4, c, this.x, this.y, this.width, this.height, (this.getWeight() + 2.0f) / 3.0f, this.color, false, true, false, true);
            }
        }

        public Color getColor(double progress) {
            Color color = switch (this.colorKind.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> DrawerUtil.NEUTRAL_LINE;
                case 1 -> {
                    if (DashToast.this.state.getStatus() == DashToastStatus.CRASHED) {
                        yield DrawerUtil.FAILED_COLOR;
                    }
                    yield DrawerUtil.getProgressColor(progress);
                }
                case 2 -> DrawerUtil.FAILED_COLOR;
            };
            return DrawerUtil.withOpacity(color, class_3532.method_15363((float)(this.x / (float)this.width), (float)0.0f, (float)1.0f));
        }

        public float getWeight() {
            return ((float)this.width * (float)this.height - 60.0f) / 190.0f;
        }
    }

    public static enum ColorKind {
        Neutral,
        Progress,
        Crashed;

    }
}

