/*
 * Decompiled with CFR 0.152.
 */
package dev.notalpha.dashloader.client.sprite.content;

import dev.notalpha.dashloader.api.CachingData;
import dev.notalpha.dashloader.api.DashModule;
import dev.notalpha.dashloader.api.cache.Cache;
import dev.notalpha.dashloader.api.cache.CacheStatus;
import dev.notalpha.dashloader.api.collection.IntIntList;
import dev.notalpha.dashloader.api.registry.RegistryReader;
import dev.notalpha.dashloader.api.registry.RegistryWriter;
import dev.notalpha.dashloader.config.ConfigHandler;
import dev.notalpha.dashloader.config.Option;
import dev.notalpha.taski.builtin.StepTask;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_7764;

public class SpriteContentModule
implements DashModule<Data> {
    public static final CachingData<Map<class_2960, class_7764>> SOURCE = new CachingData();

    @Override
    public void reset(Cache cache) {
        SOURCE.reset(cache, new HashMap());
    }

    @Override
    public Data save(RegistryWriter writer, StepTask task) {
        Map<class_2960, class_7764> spriteData = SOURCE.get(CacheStatus.SAVE);
        assert (spriteData != null);
        IntIntList map = new IntIntList();
        task.doForEach(spriteData, (identifier, spriteContents) -> {
            if (spriteContents != null) {
                map.put(writer.add(identifier), writer.add(spriteContents));
            }
        });
        return new Data(map);
    }

    @Override
    public void load(Data data, RegistryReader reader, StepTask task) {
        Map<class_2960, class_7764> spriteData = SOURCE.get(CacheStatus.LOAD);
        assert (spriteData != null);
        data.sprites.forEach((key, value) -> {
            class_2960 identifier = (class_2960)reader.get(key);
            class_7764 contents = (class_7764)reader.get(value);
            spriteData.put(identifier, contents);
        });
    }

    @Override
    public boolean isActive() {
        return ConfigHandler.optionActive(Option.CACHE_SPRITE_CONTENT);
    }

    @Override
    public Class<Data> getDataClass() {
        return Data.class;
    }

    public static class Data {
        public final IntIntList sprites;

        public Data(IntIntList sprites) {
            this.sprites = sprites;
        }
    }
}

