/*
 * Decompiled with CFR 0.152.
 */
package dev.notalpha.dashloader.client.model;

import dev.notalpha.dashloader.api.DashObject;
import dev.notalpha.dashloader.api.cache.CacheStatus;
import dev.notalpha.dashloader.api.registry.RegistryReader;
import dev.notalpha.dashloader.api.registry.RegistryWriter;
import dev.notalpha.dashloader.client.Dazy;
import dev.notalpha.dashloader.client.model.ModelModule;
import dev.notalpha.dashloader.mixin.accessor.MultipartBakedModelAccessor;
import dev.notalpha.dashloader.mixin.accessor.MultipartModelComponentAccessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_10527;
import net.minecraft.class_1087;
import net.minecraft.class_1095;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2960;
import net.minecraft.class_815;
import net.minecraft.class_816;
import net.minecraft.class_819;
import org.apache.commons.lang3.tuple.Pair;

public class DashMultipartBakedModel
implements DashObject<class_1095, DazyImpl> {
    public final List<Component> components;

    public DashMultipartBakedModel(List<Component> components) {
        this.components = components;
    }

    public DashMultipartBakedModel(class_1095 model, RegistryWriter writer) {
        MultipartBakedModelAccessor access = (MultipartBakedModelAccessor)model;
        List<class_1095.class_10204> accessComponents = access.getSelectors();
        int size = accessComponents.size();
        this.components = new ArrayList<Component>();
        HashMap<class_1087, class_816> modelMap = ModelModule.UNBAKED_TO_BAKED_MULTIPART_MODELS.get(CacheStatus.SAVE);
        HashMap<class_816, Pair<List<class_819>, class_2689<class_2248, class_2680>>> predicates = ModelModule.MULTIPART_PREDICATES.get(CacheStatus.SAVE);
        Pair<List<class_819>, class_2689<class_2248, class_2680>> pair = predicates.get(modelMap.get(model));
        class_2960 stateManagerIdentifier = ModelModule.getStateManagerIdentifier((class_2689<class_2248, class_2680>)((class_2689)pair.getRight()));
        for (int i = 0; i < size; ++i) {
            class_1087 componentModel = accessComponents.get(i).comp_3204();
            class_815 selector = ((MultipartModelComponentAccessor)((List)pair.getLeft()).get(i)).getSelector();
            this.components.add(new Component(writer.add(componentModel), writer.add(selector), writer.add(stateManagerIdentifier)));
        }
    }

    @Override
    public DazyImpl export(RegistryReader reader) {
        ArrayList<DazyImpl.Component> componentsOut = new ArrayList<DazyImpl.Component>(this.components.size());
        this.components.forEach(component -> {
            Dazy compModel = (Dazy)reader.get(component.model);
            class_2960 compIdentifier = (class_2960)reader.get(component.identifier);
            class_815 compSelector = (class_815)reader.get(component.selector);
            Predicate predicate = compSelector.getPredicate(ModelModule.getStateManager(compIdentifier));
            componentsOut.add(new DazyImpl.Component(compModel, predicate));
        });
        return new DazyImpl(componentsOut);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DashMultipartBakedModel that = (DashMultipartBakedModel)o;
        return this.components.equals(that.components);
    }

    public int hashCode() {
        return this.components.hashCode();
    }

    public static final class Component {
        public final int model;
        public final int selector;
        public final int identifier;

        public Component(int model, int selector, int identifier) {
            this.model = model;
            this.selector = selector;
            this.identifier = identifier;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Component component = (Component)o;
            if (this.model != component.model) {
                return false;
            }
            if (this.selector != component.selector) {
                return false;
            }
            return this.identifier == component.identifier;
        }

        public int hashCode() {
            int result = this.model;
            result = 31 * result + this.selector;
            result = 31 * result + this.identifier;
            return result;
        }
    }

    public static class DazyImpl
    extends Dazy<class_1095> {
        public final List<Component> components;

        public DazyImpl(List<Component> components) {
            this.components = components;
        }

        @Override
        protected class_1095 resolve(class_10527 spriteLoader) {
            ArrayList<class_1095.class_10204> componentsOut = new ArrayList<class_1095.class_10204>(this.components.size());
            for (Component component : this.components) {
                class_1087 model = component.model.get(spriteLoader);
                Predicate<class_2680> selector = component.selector;
                componentsOut.add(new class_1095.class_10204(selector, model));
            }
            class_1095 multipartBakedModel = new class_1095(componentsOut);
            MultipartBakedModelAccessor access = (MultipartBakedModelAccessor)multipartBakedModel;
            access.setStateCache(Collections.synchronizedMap(access.getStateCache()));
            return multipartBakedModel;
        }

        public static class Component {
            public final Dazy<? extends class_1087> model;
            public final Predicate<class_2680> selector;

            public Component(Dazy<? extends class_1087> model, Predicate<class_2680> selector) {
                this.model = model;
                this.selector = selector;
            }
        }
    }
}

