/*
 * Decompiled with CFR 0.152.
 */
package dev.notalpha.dashloader.client.font;

import dev.notalpha.dashloader.api.CachingData;
import dev.notalpha.dashloader.api.DashModule;
import dev.notalpha.dashloader.api.cache.Cache;
import dev.notalpha.dashloader.api.cache.CacheStatus;
import dev.notalpha.dashloader.api.collection.IntObjectList;
import dev.notalpha.dashloader.api.registry.RegistryReader;
import dev.notalpha.dashloader.api.registry.RegistryWriter;
import dev.notalpha.dashloader.client.font.DashTrueTypeFont;
import dev.notalpha.dashloader.config.ConfigHandler;
import dev.notalpha.dashloader.config.Option;
import dev.notalpha.taski.builtin.StepTask;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_390;
import org.lwjgl.util.freetype.FT_Face;

public class FontModule
implements DashModule<Data> {
    public static final CachingData<ProviderIndex> DATA = new CachingData();
    public static final CachingData<Map<FT_Face, DashTrueTypeFont.FontPrams>> FONT_TO_DATA = new CachingData();

    @Override
    public void reset(Cache cache) {
        DATA.reset(cache, new ProviderIndex(new HashMap<class_2960, List<class_390.class_9241>>(), new ArrayList<class_390>()));
        FONT_TO_DATA.reset(cache, new HashMap());
    }

    @Override
    public Data save(RegistryWriter factory, StepTask task) {
        ProviderIndex providerIndex = DATA.get(CacheStatus.SAVE);
        assert (providerIndex != null);
        int taskSize = 0;
        for (List<class_390.class_9241> value : providerIndex.providers.values()) {
            taskSize += value.size();
        }
        task.reset(taskSize += providerIndex.allProviders.size());
        IntObjectList<List<Integer>> providers = new IntObjectList<List<Integer>>();
        providerIndex.providers.forEach((identifier, fontFilterPairs) -> {
            ArrayList<Integer> values = new ArrayList<Integer>();
            for (class_390.class_9241 fontFilterPair : fontFilterPairs) {
                values.add(factory.add(fontFilterPair));
                task.next();
            }
            providers.put(factory.add(identifier), values);
        });
        ArrayList<Integer> allProviders = new ArrayList<Integer>();
        for (class_390 allProvider : providerIndex.allProviders) {
            allProviders.add(factory.add(allProvider));
            task.next();
        }
        return new Data(new DashProviderIndex(providers, allProviders));
    }

    @Override
    public void load(Data data, RegistryReader reader, StepTask task) {
        ProviderIndex index = new ProviderIndex(new HashMap<class_2960, List<class_390.class_9241>>(), new ArrayList<class_390>());
        data.fontMap.providers.forEach((key, value) -> {
            ArrayList<class_390.class_9241> fonts = new ArrayList<class_390.class_9241>();
            for (Integer i : value) {
                fonts.add((class_390.class_9241)reader.get(i));
            }
            index.providers.put((class_2960)reader.get(key), fonts);
        });
        data.fontMap.allProviders.forEach(value -> index.allProviders.add((class_390)reader.get((int)value)));
        DATA.set(CacheStatus.LOAD, index);
    }

    @Override
    public Class<Data> getDataClass() {
        return Data.class;
    }

    @Override
    public boolean isActive() {
        return ConfigHandler.optionActive(Option.CACHE_FONT);
    }

    public static final class ProviderIndex {
        public final Map<class_2960, List<class_390.class_9241>> providers;
        public final List<class_390> allProviders;

        public ProviderIndex(Map<class_2960, List<class_390.class_9241>> providers, List<class_390> allProviders) {
            this.providers = providers;
            this.allProviders = allProviders;
        }
    }

    public static final class Data {
        public final DashProviderIndex fontMap;

        public Data(DashProviderIndex fontMap) {
            this.fontMap = fontMap;
        }
    }

    public static final class DashProviderIndex {
        public final IntObjectList<List<Integer>> providers;
        public final List<Integer> allProviders;

        public DashProviderIndex(IntObjectList<List<Integer>> providers, List<Integer> allProviders) {
            this.providers = providers;
            this.allProviders = allProviders;
        }
    }
}

