/*
 * Decompiled with CFR 0.152.
 */
package dev.notalpha.dashloader.client.font;

import dev.notalpha.dashloader.api.DashObject;
import dev.notalpha.dashloader.api.cache.CacheStatus;
import dev.notalpha.dashloader.api.registry.RegistryReader;
import dev.notalpha.dashloader.client.font.FontModule;
import dev.notalpha.dashloader.io.IOHelper;
import dev.notalpha.dashloader.misc.UnsafeHelper;
import dev.notalpha.dashloader.mixin.accessor.TrueTypeFontAccessor;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Optional;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_395;
import net.minecraft.class_8532;
import net.minecraft.class_9111;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.util.freetype.FT_Face;
import org.lwjgl.util.freetype.FT_Vector;
import org.lwjgl.util.freetype.FreeType;

public final class DashTrueTypeFont
implements DashObject<class_395, class_395> {
    public final byte[] fontData;
    public final float oversample;
    public final int[] excludedCharacters;
    public final int size;
    public final float shiftX;
    public final float shiftY;
    private transient class_395 _font;

    public DashTrueTypeFont(byte[] fontData, float oversample, int[] excludedCharacters, int size, float shiftX, float shiftY) {
        this.fontData = fontData;
        this.oversample = oversample;
        this.excludedCharacters = excludedCharacters;
        this.size = size;
        this.shiftX = shiftX;
        this.shiftY = shiftY;
    }

    public DashTrueTypeFont(class_395 font) {
        TrueTypeFontAccessor fontAccess = (TrueTypeFontAccessor)font;
        FT_Face ft_face = fontAccess.getFace();
        FontPrams prams = FontModule.FONT_TO_DATA.get(CacheStatus.SAVE).get(ft_face);
        class_2960 ttFont = prams.id();
        byte[] data = null;
        try {
            Optional resource = class_310.method_1551().method_1478().method_14486(ttFont.method_45138("font/"));
            if (resource.isPresent()) {
                InputStream stream = ((class_3298)resource.get()).method_14482();
                data = IOHelper.streamToArray(stream);
                stream.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try (MemoryStack memoryStack = MemoryStack.stackPush();){
            FT_Vector vec = FT_Vector.malloc((MemoryStack)memoryStack);
            FreeType.FT_Get_Transform((FT_Face)ft_face, null, (FT_Vector)vec);
            this.shiftX = (float)vec.x() / 64.0f;
            this.shiftY = (float)vec.y() / 64.0f;
        }
        this.fontData = data;
        this.oversample = fontAccess.getOversample();
        this.excludedCharacters = prams.skip().codePoints().toArray();
        this.size = Math.round(prams.size() * this.oversample);
    }

    @Override
    public class_395 export(RegistryReader handler) {
        this._font = UnsafeHelper.allocateInstance(class_395.class);
        TrueTypeFontAccessor trueTypeFontAccess = (TrueTypeFontAccessor)this._font;
        trueTypeFontAccess.setOversample(this.oversample);
        return this._font;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postExport(RegistryReader reader) {
        ByteBuffer fontBuffer = MemoryUtil.memAlloc((int)this.fontData.length);
        fontBuffer.put(this.fontData);
        fontBuffer.flip();
        FT_Face ft_face = null;
        TrueTypeFontAccessor trueTypeFontAccess = (TrueTypeFontAccessor)this._font;
        IntArraySet set = new IntArraySet(this.excludedCharacters);
        class_8532 container = new class_8532(class_395.class_9908[]::new, x$0 -> new class_395.class_9908[x$0][]);
        try {
            Object object = class_9111.field_51483;
            synchronized (object) {
                try (MemoryStack memoryStack = MemoryStack.stackPush();){
                    int k;
                    PointerBuffer pointerBuffer = memoryStack.mallocPointer(1);
                    class_9111.method_59837((int)FreeType.FT_New_Memory_Face((long)class_9111.method_56143(), (ByteBuffer)fontBuffer, (long)0L, (PointerBuffer)pointerBuffer), (String)"Initializing font face");
                    ft_face = FT_Face.create((long)pointerBuffer.get());
                    FreeType.FT_Set_Pixel_Sizes((FT_Face)ft_face, (int)this.size, (int)this.size);
                    FT_Vector vec = class_9111.method_56147((FT_Vector)FT_Vector.malloc((MemoryStack)memoryStack), (float)this.shiftX, (float)this.shiftY);
                    FreeType.FT_Set_Transform((FT_Face)ft_face, null, (FT_Vector)vec);
                    IntBuffer intBuffer = memoryStack.mallocInt(1);
                    int j = (int)FreeType.FT_Get_First_Char((FT_Face)ft_face, (IntBuffer)intBuffer);
                    while ((k = intBuffer.get(0)) != 0) {
                        if (!set.contains(j)) {
                            container.method_51599(j, (Object)new class_395.class_9908(k));
                        }
                        j = (int)FreeType.FT_Get_Next_Char((FT_Face)ft_face, (long)j, (IntBuffer)intBuffer);
                    }
                }
            }
            trueTypeFontAccess.setContainer((class_8532<class_395.class_9908>)container);
            trueTypeFontAccess.setFace(ft_face);
            trueTypeFontAccess.setBuffer(fontBuffer);
        }
        catch (Throwable e) {
            Object object = class_9111.field_51483;
            synchronized (object) {
                if (ft_face != null) {
                    FreeType.FT_Done_Face(ft_face);
                }
            }
            MemoryUtil.memFree((Buffer)fontBuffer);
            throw e;
        }
    }

    public record FontPrams(class_2960 id, float size, String skip) {
    }
}

