/*
 * Decompiled with CFR 0.152.
 */
package dev.notalpha.dashloader;

import dev.notalpha.dashloader.api.DashObject;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DashObjectClass<R, D extends DashObject<R, ?>> {
    private final Class<D> dashClass;
    int dashObjectId;
    @Nullable
    private Class<R> targetClass;

    public DashObjectClass(Class<?> dashClass) {
        this.dashClass = dashClass;
    }

    public Class<D> getDashClass() {
        return this.dashClass;
    }

    @NotNull
    public Class<R> getTargetClass() {
        if (this.targetClass == null) {
            Type[] genericInterfaces = this.dashClass.getGenericInterfaces();
            if (genericInterfaces.length == 0) {
                throw new RuntimeException(String.valueOf(this.dashClass) + " does not implement DashObject.");
            }
            boolean foundDashObject = false;
            Class<?>[] interfaces = this.dashClass.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                if (interfaces[i] != DashObject.class) continue;
                foundDashObject = true;
                Type genericInterface = genericInterfaces[i];
                if (genericInterface instanceof ParameterizedType) {
                    ParameterizedType targetClass = (ParameterizedType)genericInterface;
                    Type type = targetClass.getActualTypeArguments()[0];
                    if (type instanceof Class) {
                        Class targetClass2;
                        this.targetClass = targetClass2 = (Class)type;
                        continue;
                    }
                    throw new RuntimeException(String.valueOf(this.dashClass) + " has a non resolvable DashObject parameter");
                }
                throw new RuntimeException(String.valueOf(this.dashClass) + " implements raw DashObject");
            }
            if (!foundDashObject) {
                throw new RuntimeException(String.valueOf(this.dashClass) + " must implement DashObject");
            }
        }
        return this.targetClass;
    }

    public int getDashObjectId() {
        return this.dashObjectId;
    }

    public String toString() {
        return "DashObjectClass{dashClass=" + String.valueOf(this.dashClass) + ", targetClass=" + String.valueOf(this.targetClass) + ", dashObjectId=" + this.dashObjectId + "}";
    }
}

