/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.legendarytooltips;

import com.anthonyhilyard.iceberg.events.client.RenderTooltipEvents;
import com.anthonyhilyard.iceberg.util.Tooltips;
import com.anthonyhilyard.legendarytooltips.config.LegendaryTooltipsConfig;
import com.anthonyhilyard.legendarytooltips.tooltip.ItemModelComponent;
import com.anthonyhilyard.legendarytooltips.tooltip.PaddingComponent;
import com.anthonyhilyard.legendarytooltips.tooltip.TooltipDecor;
import com.anthonyhilyard.prism.item.ItemColors;
import com.anthonyhilyard.prism.text.DynamicColor;
import com.mojang.datafixers.util.Either;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1799;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5348;
import net.minecraft.class_5632;
import net.minecraft.class_5684;
import net.minecraft.class_7225;
import net.minecraft.class_7417;
import net.minecraft.class_9779;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LegendaryTooltips {
    public static final String MODID = "legendarytooltips";
    public static final Logger LOGGER = LogManager.getLogger((String)"legendarytooltips");
    public static final int STANDARD = -1;
    public static final int NO_BORDER = -2;
    public static final int NUM_FRAMES = 16;
    private static class_1799 lastTooltipItem = null;

    public static void init() {
        LegendaryTooltipsConfig.register(LegendaryTooltipsConfig.class, (String)MODID);
    }

    public static LegendaryTooltipsConfig.FrameDefinition getDefinitionColors(class_1799 item, int defaultStartBorder, int defaultEndBorder, int defaultStartBackground, int defaultEndBackground, class_7225.class_7874 provider) {
        LegendaryTooltipsConfig.FrameDefinition result = LegendaryTooltipsConfig.getInstance().getFrameDefinition(item, provider);
        switch (result.index()) {
            case -2: {
                result = new LegendaryTooltipsConfig.FrameDefinition(result.resource(), result.index(), () -> defaultStartBorder, () -> defaultEndBorder, () -> defaultStartBackground, () -> defaultEndBackground, LegendaryTooltipsConfig.FrameSource.NONE, 0, result.frameWidth(), result.partSize(), result.partOffset(), result.cornerOffset());
                break;
            }
            case -1: {
                if (!LegendaryTooltipsConfig.getInstance().bordersMatchRarity.get().booleanValue()) break;
                DynamicColor rarityColor = DynamicColor.fromRgb((int)ItemColors.getColorForItem((class_1799)item, (class_5251)class_5251.method_27718((class_124)class_124.field_1068)).method_27716());
                int hue = rarityColor.hue();
                boolean addHue = false;
                if (hue >= 62 && hue <= 240) {
                    addHue = true;
                }
                int startHue = addHue ? hue - 4 : hue + 4;
                int endHue = addHue ? hue + 18 : hue - 18;
                int startBGHue = addHue ? hue - 3 : hue + 3;
                int endBGHue = addHue ? hue + 13 : hue - 13;
                startHue = (startHue + 360) % 360;
                endHue = (endHue + 360) % 360;
                startBGHue = (startBGHue + 360) % 360;
                endBGHue = (endBGHue + 360) % 360;
                DynamicColor startColor = DynamicColor.fromAHSV((int)255, (int)startHue, (int)rarityColor.saturation(), (int)rarityColor.value());
                DynamicColor endColor = DynamicColor.fromAHSV((int)255, (int)endHue, (int)rarityColor.saturation(), (int)((int)((float)rarityColor.value() * 0.95f)));
                DynamicColor startBGColor = DynamicColor.fromAHSV((int)228, (int)startBGHue, (int)((int)((float)rarityColor.saturation() * 0.9f)), (int)14);
                DynamicColor endBGColor = DynamicColor.fromAHSV((int)253, (int)endBGHue, (int)((int)((float)rarityColor.saturation() * 0.8f)), (int)18);
                result = new LegendaryTooltipsConfig.FrameDefinition(result.resource(), result.index(), () -> startColor.getIntValue(), () -> endColor.getIntValue(), () -> startBGColor.getIntValue(), () -> endBGColor.getIntValue(), LegendaryTooltipsConfig.FrameSource.NONE, 0, result.frameWidth(), result.partSize(), result.partOffset(), result.cornerOffset());
            }
        }
        if (result.startBorder() == null) {
            result = new LegendaryTooltipsConfig.FrameDefinition(result.resource(), result.index(), () -> defaultStartBorder, result.endBorder(), result.startBackground(), result.endBackground(), LegendaryTooltipsConfig.FrameSource.NONE, 0, result.frameWidth(), result.partSize(), result.partOffset(), result.cornerOffset());
        }
        if (result.endBorder() == null) {
            result = new LegendaryTooltipsConfig.FrameDefinition(result.resource(), result.index(), result.startBorder(), () -> defaultEndBorder, result.startBackground(), result.endBackground(), LegendaryTooltipsConfig.FrameSource.NONE, 0, result.frameWidth(), result.partSize(), result.partOffset(), result.cornerOffset());
        }
        if (result.startBackground() == null) {
            result = new LegendaryTooltipsConfig.FrameDefinition(result.resource(), result.index(), result.startBorder(), result.endBorder(), () -> defaultStartBackground, result.endBackground(), LegendaryTooltipsConfig.FrameSource.NONE, 0, result.frameWidth(), result.partSize(), result.partOffset(), result.cornerOffset());
        }
        if (result.endBackground() == null) {
            result = new LegendaryTooltipsConfig.FrameDefinition(result.resource(), result.index(), result.startBorder(), result.endBorder(), result.startBackground(), () -> defaultEndBackground, LegendaryTooltipsConfig.FrameSource.NONE, 0, result.frameWidth(), result.partSize(), result.partOffset(), result.cornerOffset());
        }
        return result;
    }

    public static RenderTooltipEvents.GatherResult onGatherComponentsEvent(class_1799 itemStack, int screenWidth, int screenHeight, List<Either<class_5348, class_5632>> tooltipElements, int maxWidth, int index) {
        class_5348 title;
        if (LegendaryTooltipsConfig.getInstance().compactTooltips.get().booleanValue()) {
            for (int i = 0; i < tooltipElements.size(); ++i) {
                class_2588 contents;
                class_5250 component;
                class_7417 class_74172;
                class_5348 text;
                if (!tooltipElements.get(i).left().isPresent() || !((text = (class_5348)tooltipElements.get(i).left().get()) instanceof class_5250) || !((class_74172 = (component = (class_5250)text).method_10851()) instanceof class_2588) || !(contents = (class_2588)class_74172).method_11022().startsWith("item.modifiers.")) continue;
                tooltipElements.remove(i);
                if ((tooltipElements.size() <= i - 1 || i <= 0 || !tooltipElements.get(i - 1).right().isPresent() || tooltipElements.get(i - 1).right().get() != class_5244.field_39003) && (!tooltipElements.get(i - 1).left().isPresent() || !((class_5348)tooltipElements.get(i - 1).left().get()).getString().isEmpty())) break;
                tooltipElements.remove(i - 1);
                break;
            }
        }
        if (LegendaryTooltipsConfig.showModelForItem(itemStack) && !tooltipElements.isEmpty() && tooltipElements.get(0).left().isPresent() && (title = LegendaryTooltipsConfig.getFormattedTitle((class_5348)tooltipElements.get(0).left().get())) != null) {
            tooltipElements.set(0, (Either<class_5348, class_5632>)Either.left((Object)title));
            tooltipElements.add(0, (Either<class_5348, class_5632>)Either.right((Object)new ItemModelComponent(itemStack)));
            if (tooltipElements.stream().filter(x -> !x.right().isPresent() || !(x.right().get() instanceof Tooltips.TitleBreakComponent)).count() == 2L) {
                tooltipElements.add(2, (Either<class_5348, class_5632>)Either.right((Object)new PaddingComponent(6)));
            } else {
                tooltipElements.add(2, (Either<class_5348, class_5632>)Either.right((Object)new PaddingComponent(12)));
            }
        }
        return new RenderTooltipEvents.GatherResult((class_1269)class_1269.field_5811, maxWidth, tooltipElements);
    }

    public static void onRenderTick(class_9779 tracker) {
        class_437 class_4372;
        if (LegendaryTooltipsConfig.getInstance() == null || !LegendaryTooltipsConfig.getInstance().isLoaded()) {
            return;
        }
        class_310 minecraft = class_310.method_1551();
        float deltaTime = tracker.method_60638() / 50.0f;
        TooltipDecor.updateTimer(deltaTime);
        ItemModelComponent.updateTimer(deltaTime);
        if (minecraft.field_1755 != null && (class_4372 = minecraft.field_1755) instanceof class_465) {
            class_1799 item;
            class_465 containerScreen = (class_465)class_4372;
            if (containerScreen.field_2787 != null && containerScreen.field_2787.method_7681() && lastTooltipItem != (item = containerScreen.field_2787.method_7677())) {
                TooltipDecor.resetTimer();
                lastTooltipItem = item;
            }
        }
    }

    public static RenderTooltipEvents.ColorExtResult onTooltipColorEvent(class_1799 stack, class_332 graphics, int x, int y, class_327 font, int backgroundStart, int backgroundEnd, int borderStart, int borderEnd, List<class_5684> components, boolean comparison, int index, class_2960 resource, boolean gradientBackground, boolean gradientBorder) {
        RenderTooltipEvents.ColorExtResult result = new RenderTooltipEvents.ColorExtResult(backgroundStart, backgroundEnd, borderStart, borderEnd, gradientBackground, gradientBorder);
        class_310 minecraft = class_310.method_1551();
        if (minecraft.field_1687 == null || minecraft.field_1687.method_30349() == null) {
            return result;
        }
        LegendaryTooltipsConfig.FrameDefinition frameDefinition = LegendaryTooltips.getDefinitionColors(stack, borderStart, borderEnd, backgroundStart, backgroundEnd, (class_7225.class_7874)minecraft.field_1687.method_30349());
        gradientBackground = LegendaryTooltipsConfig.showGradientBackground(resource);
        gradientBorder = LegendaryTooltipsConfig.showGradientBorder(resource);
        TooltipDecor.setCurrentTooltipBorderStart(frameDefinition.startBorder().get());
        TooltipDecor.setCurrentTooltipBorderEnd(frameDefinition.endBorder().get());
        TooltipDecor.setCurrentTooltipBackgroundStart(frameDefinition.startBackground().get());
        TooltipDecor.setCurrentTooltipBackgroundEnd(frameDefinition.endBackground().get());
        result = comparison ? new RenderTooltipEvents.ColorExtResult(0, 0, 0, 0, gradientBackground, gradientBorder) : new RenderTooltipEvents.ColorExtResult(frameDefinition.startBackground().get().intValue(), frameDefinition.endBackground().get().intValue(), frameDefinition.startBorder().get().intValue(), frameDefinition.endBorder().get().intValue(), gradientBackground, gradientBorder);
        return result;
    }

    public static void onPostTooltipEvent(class_1799 itemStack, class_332 graphics, int x, int y, class_327 font, int width, int height, List<class_5684> components, boolean comparison, int index) {
        class_310 minecraft = class_310.method_1551();
        if (minecraft.field_1687 == null || minecraft.field_1687.method_30349() == null) {
            return;
        }
        LegendaryTooltipsConfig.FrameDefinition frameDefinition = LegendaryTooltipsConfig.getInstance().getFrameDefinition(itemStack, (class_7225.class_7874)minecraft.field_1687.method_30349());
        if (frameDefinition.index() == -2) {
            return;
        }
        class_4587 poseStack = graphics.method_51448();
        if (LegendaryTooltipsConfig.getInstance().tooltipShadow.get().booleanValue()) {
            if (comparison) {
                TooltipDecor.drawShadow(poseStack, x, y - 11, width, height + 11);
            } else {
                TooltipDecor.drawShadow(poseStack, x, y, width, height);
            }
        }
        if (comparison) {
            TooltipDecor.drawBorder(poseStack, x, y - 11, width, height + 11, itemStack, components, font, frameDefinition, comparison, index);
        } else {
            TooltipDecor.drawBorder(poseStack, x, y, width, height, itemStack, components, font, frameDefinition, comparison, index);
        }
    }
}

