/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.immersiveui.system.particles.data;

import com.mojang.blaze3d.systems.RenderSystem;
import it.hurts.octostudios.immersiveui.system.particles.data.ParticleEmitter;
import it.hurts.octostudios.immersiveui.util.RenderUtils;
import it.hurts.octostudios.immersiveui.util.VectorUtils;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import oshi.util.tuples.Pair;

public class ParticleData {
    private final Texture2D texture;
    private final float maxSpeed;
    private final int maxLifetime;
    private final Vector2f startPos;
    private Vector2f oldPos;
    private final ParticleEmitter emitter;
    public Vector2f position;
    public Vector2f direction;
    public Vector2f gravityDirection;
    public float speed;
    public float gravity;
    private float gravityAccel;
    public float friction;
    public float size;
    public float angularVelocity;
    public int lifetime;
    public int startColor;
    public int endColor;
    public Pair<Integer, Integer> blendFunc;
    public boolean enableBlend;
    public boolean resizeWithLifetime;
    private int tickCount;

    public ParticleEmitter emitter() {
        return this.emitter;
    }

    public ParticleData(Texture2D texture, float maxSpeed, int maxLifetime, float xStart, float yStart, ParticleEmitter emitter) {
        this.texture = texture;
        this.maxSpeed = maxSpeed;
        this.maxLifetime = maxLifetime;
        this.lifetime = maxLifetime;
        this.speed = maxSpeed;
        this.emitter = emitter;
        this.position = this.startPos = new Vector2f(xStart, yStart);
        this.oldPos = this.startPos;
        this.size = 1.0f;
        this.friction = 0.0f;
        this.startColor = -1;
        this.endColor = 0;
        this.direction = new Vector2f(0.0f, 1.0f);
        this.gravityDirection = new Vector2f(0.0f, 1.0f);
        this.angularVelocity = 0.0f;
        this.resizeWithLifetime = true;
        this.enableBlend = true;
        this.blendFunc = new Pair((Object)770, (Object)1);
    }

    public class_4587 getPoseStackSnapshot() {
        class_4587 stack = new class_4587();
        stack.method_34425(this.emitter.pose());
        return stack;
    }

    public void tick() {
        this.oldPos = new Vector2f((Vector2fc)this.position);
        if (this.angularVelocity != 0.0f) {
            this.direction = VectorUtils.rotate(this.direction.normalize(), this.angularVelocity);
        } else {
            this.direction.normalize();
        }
        this.speed = class_3532.method_15363((float)(this.speed * (1.0f - this.friction)), (float)0.0f, (float)this.maxSpeed);
        this.gravityAccel += this.gravity / 20.0f;
        this.lifetime = class_3532.method_15340((int)(this.lifetime - 1), (int)0, (int)this.maxLifetime);
        this.position.add((Vector2fc)this.direction.mul(this.speed));
        if (this.gravityAccel != 0.0f) {
            this.position.add(this.gravityDirection.x * this.gravityAccel, this.gravityDirection.y * this.gravityAccel);
        }
        --this.lifetime;
        ++this.tickCount;
    }

    public void render(class_4587 pose, float partialTick) {
        class_310 MC = class_310.method_1551();
        Texture2D tex = this.getTexture();
        float lifePercentage = (float)this.lifetime / (float)this.maxLifetime;
        int color = RenderUtils.lerpColor(this.startColor, this.endColor, 1.0f - lifePercentage);
        int alpha = color >> 24 & 0xFF;
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        RenderSystem.setShaderColor((float)((float)red / 255.0f), (float)((float)green / 255.0f), (float)((float)blue / 255.0f), (float)((float)alpha / 255.0f));
        RenderSystem.setShaderTexture((int)0, (class_2960)this.getTexture().rl);
        RenderSystem.enableBlend();
        if (this.enableBlend) {
            RenderSystem.blendFunc((int)((Integer)this.blendFunc.getA()), (int)((Integer)this.blendFunc.getB()));
        }
        RenderUtils.renderTextureFromCenter(pose, class_3532.method_16439((float)partialTick, (float)this.oldPos.x, (float)this.position.x), class_3532.method_16439((float)partialTick, (float)this.oldPos.y, (float)this.position.y), tex.texOffX, tex.texOffY, tex.texWidth, tex.texHeight, tex.width, tex.height, this.size * (this.resizeWithLifetime ? lifePercentage : 1.0f));
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
    }

    public Texture2D getTexture() {
        return this.texture;
    }

    public float getMaxSpeed() {
        return this.maxSpeed;
    }

    public int getMaxLifetime() {
        return this.maxLifetime;
    }

    public Vector2f getStartPos() {
        return this.startPos;
    }

    public Vector2f getOldPos() {
        return this.oldPos;
    }

    public int getTickCount() {
        return this.tickCount;
    }

    public static class Texture2D {
        private class_2960 rl;
        private float width;
        private float height;
        private float texOffX;
        private float texOffY;
        private float texWidth;
        private float texHeight;

        public Texture2D(class_2960 texture, int texOffX, int texOffY, int texWidth, int texHeight, int width, int height) {
            this.rl = texture;
            this.texOffX = texOffX;
            this.texOffY = texOffY;
            this.texWidth = texWidth;
            this.texHeight = texHeight;
            this.width = width;
            this.height = height;
        }

        public Texture2D(class_2960 texture, int width, int height) {
            this.rl = texture;
            this.width = width;
            this.height = height;
            this.texWidth = width;
            this.texHeight = height;
        }

        public class_2960 getRl() {
            return this.rl;
        }

        public float getWidth() {
            return this.width;
        }

        public float getHeight() {
            return this.height;
        }

        public float getTexOffX() {
            return this.texOffX;
        }

        public float getTexOffY() {
            return this.texOffY;
        }

        public float getTexWidth() {
            return this.texWidth;
        }

        public float getTexHeight() {
            return this.texHeight;
        }

        public void setRl(class_2960 rl) {
            this.rl = rl;
        }

        public void setWidth(float width) {
            this.width = width;
        }

        public void setHeight(float height) {
            this.height = height;
        }

        public void setTexOffX(float texOffX) {
            this.texOffX = texOffX;
        }

        public void setTexOffY(float texOffY) {
            this.texOffY = texOffY;
        }

        public void setTexWidth(float texWidth) {
            this.texWidth = texWidth;
        }

        public void setTexHeight(float texHeight) {
            this.texHeight = texHeight;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Texture2D)) {
                return false;
            }
            Texture2D other = (Texture2D)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (Float.compare(this.getWidth(), other.getWidth()) != 0) {
                return false;
            }
            if (Float.compare(this.getHeight(), other.getHeight()) != 0) {
                return false;
            }
            if (Float.compare(this.getTexOffX(), other.getTexOffX()) != 0) {
                return false;
            }
            if (Float.compare(this.getTexOffY(), other.getTexOffY()) != 0) {
                return false;
            }
            if (Float.compare(this.getTexWidth(), other.getTexWidth()) != 0) {
                return false;
            }
            if (Float.compare(this.getTexHeight(), other.getTexHeight()) != 0) {
                return false;
            }
            class_2960 this$rl = this.getRl();
            class_2960 other$rl = other.getRl();
            return !(this$rl == null ? other$rl != null : !this$rl.equals(other$rl));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Texture2D;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Float.floatToIntBits(this.getWidth());
            result = result * 59 + Float.floatToIntBits(this.getHeight());
            result = result * 59 + Float.floatToIntBits(this.getTexOffX());
            result = result * 59 + Float.floatToIntBits(this.getTexOffY());
            result = result * 59 + Float.floatToIntBits(this.getTexWidth());
            result = result * 59 + Float.floatToIntBits(this.getTexHeight());
            class_2960 $rl = this.getRl();
            result = result * 59 + ($rl == null ? 43 : $rl.hashCode());
            return result;
        }

        public String toString() {
            return "ParticleData.Texture2D(rl=" + String.valueOf(this.getRl()) + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ", texOffX=" + this.getTexOffX() + ", texOffY=" + this.getTexOffY() + ", texWidth=" + this.getTexWidth() + ", texHeight=" + this.getTexHeight() + ")";
        }
    }
}

