/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.iceberg.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_5352;
import net.minecraft.class_7367;
import net.minecraft.class_7677;
import net.minecraft.class_9224;
import org.jetbrains.annotations.Nullable;

public class DynamicResourcePack
implements class_3262 {
    private final class_9224 location;
    private final String packName;
    private Map<DynamicResourceKey, class_7367<InputStream>> dynamicResourceMap = new HashMap<DynamicResourceKey, class_7367<InputStream>>();

    public DynamicResourcePack(String packName) {
        this.location = new class_9224(packName, (class_2561)class_2561.method_43470((String)packName), class_5352.field_25347, null);
        this.packName = packName;
    }

    public void clear() {
        this.dynamicResourceMap.clear();
    }

    public boolean removeResource(class_3264 type, class_2960 location) {
        DynamicResourceKey key = new DynamicResourceKey(type.method_14413(), location.method_12836(), location.method_12832());
        if (this.dynamicResourceMap.containsKey(key)) {
            this.dynamicResourceMap.remove(key);
            return true;
        }
        return false;
    }

    public boolean registerResource(class_3264 type, class_2960 location, class_7367<InputStream> resourceSupplier) {
        return this.register(type.method_14413(), location.method_12836(), location.method_12832(), resourceSupplier);
    }

    public boolean registerRootResource(String path, class_7367<InputStream> resourceSupplier) {
        return this.register("root", "", path, resourceSupplier);
    }

    private boolean register(String directory, String namespace, String path, class_7367<InputStream> resourceSupplier) {
        DynamicResourceKey key = new DynamicResourceKey(directory, namespace, path);
        if (!this.dynamicResourceMap.containsKey(key)) {
            this.dynamicResourceMap.put(key, resourceSupplier);
            return true;
        }
        return false;
    }

    @Nullable
    public class_7367<InputStream> method_14410(String ... path) {
        try {
            return this.getResource("root", "", String.join((CharSequence)"/", path));
        }
        catch (IOException e) {
            return null;
        }
    }

    @Nullable
    public class_7367<InputStream> method_14405(class_3264 type, class_2960 location) {
        try {
            return this.getResource(type.method_14413(), location.method_12836(), location.method_12832());
        }
        catch (IOException e) {
            return null;
        }
    }

    private class_7367<InputStream> getResource(String directory, String namespace, String path) throws IOException {
        DynamicResourceKey key = new DynamicResourceKey(directory, namespace, path);
        if (this.dynamicResourceMap.containsKey(key)) {
            return this.dynamicResourceMap.get(key);
        }
        throw new FileNotFoundException("Can't find dynamic resource " + path + ". Please ensure it has been registered.");
    }

    public void method_14408(class_3264 type, String namespace, String path, class_3262.class_7664 output) {
        this.dynamicResourceMap.entrySet().stream().filter(entry -> ((DynamicResourceKey)entry.getKey()).namespace.contentEquals(namespace)).filter(entry -> ((DynamicResourceKey)entry.getKey()).path.startsWith(path)).filter(entry -> ((DynamicResourceKey)entry.getKey()).type.contentEquals(type.method_14413())).forEach(entry -> output.accept((Object)class_2960.method_60655((String)namespace, (String)((DynamicResourceKey)entry.getKey()).path), (Object)((class_7367)entry.getValue())));
    }

    public Set<String> method_14406(class_3264 type) {
        HashSet<String> namespaces = new HashSet<String>();
        for (DynamicResourceKey key : this.dynamicResourceMap.keySet()) {
            if (!type.method_14413().contentEquals(key.type)) continue;
            namespaces.add(key.namespace);
        }
        return namespaces;
    }

    public <T> T method_14407(class_7677<T> p_10291_) throws IOException {
        return null;
    }

    public String method_14409() {
        return this.packName;
    }

    public void close() {
    }

    public class_9224 method_56926() {
        return this.location;
    }

    private record DynamicResourceKey(String type, String namespace, String path) {
    }
}

