/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.utils.logging;

import java.util.function.Supplier;
import org.fusesource.jansi.AnsiConsole;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.gravit.utils.helper.FormatHelper;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.helper.LogHelper$Level;
import pro.gravit.utils.logging.LogHelperAppender;

public class Slf4jLogHelperImpl
implements LogHelperAppender {
    private final Logger logger = LoggerFactory.getLogger("LogHelper");
    private final boolean JANSI;

    public Slf4jLogHelperImpl() {
        boolean bl;
        try {
            if (Boolean.getBoolean("launcher.noJAnsi")) {
                bl = false;
            } else {
                Class.forName("org.fusesource.jansi.Ansi");
                AnsiConsole.systemInstall();
                bl = true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            bl = false;
        }
        this.JANSI = bl;
    }

    @Override
    public void log(LogHelper$Level logHelper$Level, String string, boolean bl) {
        switch (logHelper$Level) {
            case DEV: {
                this.logger.trace(string);
                break;
            }
            case DEBUG: {
                this.logger.debug(string);
                break;
            }
            case INFO: {
                this.logger.info(string);
                break;
            }
            case WARNING: {
                this.logger.warn(string);
                break;
            }
            case ERROR: {
                this.logger.error(string);
            }
        }
    }

    @Override
    public void logJAnsi(LogHelper$Level logHelper$Level, Supplier<String> supplier, Supplier<String> supplier2, boolean bl) {
        if (this.JANSI) {
            this.log(logHelper$Level, supplier2.get(), bl);
        } else {
            this.log(logHelper$Level, supplier.get(), bl);
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return true;
    }

    @Override
    public void setDebugEnabled(boolean bl) {
    }

    @Override
    public boolean isStacktraceEnabled() {
        return true;
    }

    @Override
    public void setStacktraceEnabled(boolean bl) {
    }

    @Override
    public boolean isDevEnabled() {
        return true;
    }

    @Override
    public void setDevEnabled(boolean bl) {
    }

    @Override
    public void addOutput(LogHelper.OutputEnity outputEnity) {
    }

    @Override
    public boolean removeOutput(LogHelper.OutputEnity outputEnity) {
        return false;
    }

    @Override
    public void printVersion(String string) {
        if (this.JANSI) {
            this.logger.info(FormatHelper.ansiFormatVersion(string));
        } else {
            this.logger.info(FormatHelper.formatVersion(string));
        }
    }

    @Override
    public void printLicense(String string) {
        if (this.JANSI) {
            this.logger.info(FormatHelper.ansiFormatLicense(string));
        } else {
            this.logger.info(FormatHelper.formatLicense(string));
        }
    }
}

