/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.utils.command;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import pro.gravit.utils.command.Command;
import pro.gravit.utils.command.CommandCategory;
import pro.gravit.utils.helper.VerifyHelper;

public class BaseCommandCategory
implements CommandCategory {
    private final Map<String, Command> commands = new ConcurrentHashMap<String, Command>(32);

    @Override
    public void registerCommand(String string, Command command) {
        VerifyHelper.verifyIDName(string);
        VerifyHelper.putIfAbsent(this.commands, string.toLowerCase(), Objects.requireNonNull(command, "command"), String.format("Command has been already registered: '%s'", string.toLowerCase()));
    }

    @Override
    public Command unregisterCommand(String string) {
        return this.commands.remove(string);
    }

    @Override
    public Command findCommand(String string) {
        return this.commands.get(string);
    }

    @Override
    public Map<String, Command> commandsMap() {
        return this.commands;
    }
}

