/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.utils;

import java.util.Locale;
import java.util.Objects;
import pro.gravit.utils.Version$Type;

public final class Version
implements Comparable<Version> {
    public static final int MAJOR = 5;
    public static final int MINOR = 6;
    public static final int PATCH = 11;
    public static final int BUILD = 1;
    public static final Version$Type RELEASE = Version$Type.STABLE;
    public final int major;
    public final int minor;
    public final int patch;
    public final int build;
    public final Version$Type release;

    public Version(int n, int n2, int n3) {
        this.major = n;
        this.minor = n2;
        this.patch = n3;
        this.build = 0;
        this.release = Version$Type.UNKNOWN;
    }

    public Version(int n, int n2, int n3, int n4) {
        this.major = n;
        this.minor = n2;
        this.patch = n3;
        this.build = n4;
        this.release = Version$Type.UNKNOWN;
    }

    public Version(int n, int n2, int n3, int n4, Version$Type version$Type) {
        this.major = n;
        this.minor = n2;
        this.patch = n3;
        this.build = n4;
        this.release = version$Type;
    }

    public static Version of(int n, int n2, int n3) {
        return new Version(n, n2, n3);
    }

    public static Version of(int n, int n2, int n3, int n4) {
        return new Version(n, n2, n3, n4);
    }

    public static Version of(int n, int n2, int n3, int n4, Version$Type version$Type) {
        return new Version(n, n2, n3, n4, version$Type);
    }

    public static Version getVersion() {
        return new Version(5, 6, 11, 1, RELEASE);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Version version = (Version)object;
        return this.major == version.major && this.minor == version.minor && this.patch == version.patch && this.build == version.build;
    }

    public String getVersionString() {
        return String.format("%d.%d.%d", this.major, this.minor, this.patch);
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.patch, this.build);
    }

    public String getReleaseStatus() {
        if (this.release.equals((Object)Version$Type.UNKNOWN)) {
            return "";
        }
        return this.release.name().toLowerCase(Locale.ENGLISH);
    }

    public String toString() {
        return String.format("%d.%d.%d-%d %s", this.major, this.minor, this.patch, this.build, this.getReleaseStatus());
    }

    @Override
    public int compareTo(Version version) {
        if (version.major != this.major) {
            return Integer.compare(this.major, version.major);
        }
        if (version.minor != this.minor) {
            return Integer.compare(this.minor, version.minor);
        }
        if (version.patch != this.patch) {
            return Integer.compare(this.patch, version.patch);
        }
        return 0;
    }

    public boolean isUpperThan(Version version) {
        return this.compareTo(version) > 0;
    }

    public boolean isLowerThan(Version version) {
        return this.compareTo(version) < 0;
    }
}

