/*
 * Decompiled with CFR 0.152.
 */
package oshi.util;

import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.util.GlobalConfig;

@ThreadSafe
public final class Memoizer {
    private static final Supplier<Long> DEFAULT_EXPIRATION_NANOS = Memoizer.memoize(Memoizer::queryExpirationConfig, TimeUnit.MINUTES.toNanos(1L));

    private Memoizer() {
    }

    private static long queryExpirationConfig() {
        return TimeUnit.MILLISECONDS.toNanos(GlobalConfig.get("oshi.util.memoizer.expiration", 300));
    }

    public static long installedAppsExpiration() {
        return TimeUnit.MINUTES.toNanos(1L);
    }

    public static long defaultExpiration() {
        return DEFAULT_EXPIRATION_NANOS.get();
    }

    public static <T> Supplier<T> memoize(final Supplier<T> supplier, final long l) {
        return new Supplier<T>(){
            private final Supplier<T> delegate;
            private volatile T value;
            private volatile long expirationNanos;
            {
                this.delegate = supplier;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T get() {
                long l3 = this.expirationNanos;
                long l2 = System.nanoTime();
                if (l3 == 0L || l >= 0L && l2 - l3 >= 0L) {
                    1 var5_3 = this;
                    synchronized (var5_3) {
                        if (l3 == this.expirationNanos) {
                            Object t = this.delegate.get();
                            this.value = t;
                            l3 = l2 + l;
                            this.expirationNanos = l3 == 0L ? 1L : l3;
                            return t;
                        }
                    }
                }
                return this.value;
            }
        };
    }

    public static <T> Supplier<T> memoize(Supplier<T> supplier) {
        return Memoizer.memoize(supplier, -1L);
    }
}

